---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：61-devdデバイスイベント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **devctlキューサイズのデフォルト値1000**：カーネル側コード未確認
  2. **クライアントソケットのパーミッション設定**：ソケット作成コード未詳細確認

## 2) 参照した情報（Evidence一覧）
- E-01: `sbin/devd/devd.cc` - メインソースコード
- E-02: `sbin/devd/devd.hh` - C++クラス定義ヘッダ
- E-03: `sbin/devd/devd.h` - C互換ヘッダ（PATH_DEVCTL, DEVCTL_MAXBUF定義）
- E-04: `sbin/devd/devd.conf` - デフォルト設定ファイル
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面関連情報
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devdは/dev/devctlからイベントを読み取る | E-03 (55行目: PATH_DEVCTL="/dev/devctl") | ○ |
| C-02 | イベントは4種類（attach/detach/nomatch/notify）に分類 | E-01 (140-143行目: notify='!',nomatch='?',attach='+',detach='-') | ○ |
| C-03 | 設定ファイルパスのデフォルトは/etc/devd.conf | E-01 (104行目: CF="/etc/devd.conf") | ○ |
| C-04 | ストリーム型ソケットパスは/var/run/devd.pipe | E-01 (102行目: STREAMPIPE) | ○ |
| C-05 | シーケンスパケット型ソケットパスは/var/run/devd.seqpacket.pipe | E-01 (103行目: SEQPACKETPIPE) | ○ |
| C-06 | DEVCTL_MAXBUFは8192バイト | E-03 (56行目: DEVCTL_MAXBUF 8192) | ○ |
| C-07 | configクラスは4つのイベントリストを持つ | E-02 (180-183行目: _attach_list, _detach_list, _nomatch_list, _notify_list) | ○ |
| C-08 | match正規表現はREG_EXTENDED|REG_NOSUB|REG_ICASE | E-01 (294行目: regcomp) | ○ |
| C-09 | パターン先頭!で否定マッチ | E-01 (290行目: _inv(re[0] == '!')) | ○ |
| C-10 | アクション実行はfork/exec(/bin/sh -c) | E-01 (265行目: execl(_PATH_BSHELL,"sh","-c"...)) | ○ |
| C-11 | CLIENT_BUFSIZEは262144(256KB) | E-01 (129行目: CLIENT_BUFSIZE 262144) | ○ |
| C-12 | 優先度順にソートされる | E-01 (511-515行目: sort_vector, epv_greater) | ○ |
| C-13 | shell_quoteによるインジェクション対策 | E-01 (650-677行目: shell_quote実装) | ○ |
| C-14 | SIGHUPで設定再読み込み | E-01 (152行目: romeo_must_die変数, シグナルハンドラ) | ○ |
| C-15 | my_system()でSIGINT/SIGQUIT無視 | E-01 (241-248行目: sigaction) | ○ |
| C-16 | 画面27との関連 | E-05 (画面No27行) | ○ |
| C-17 | vm_guest変数によるVM検出 | E-01 (156行目: vm_guest変数) | ○ |
| C-18 | 変数展開で$$は$にエスケープ | E-01 (687-689行目: expand_one) | ○ |
| C-19 | devctlキューサイズのデフォルト値1000 | **根拠なし** | △ |
| C-20 | クライアントソケットのパーミッション | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- devctlキューサイズのデフォルト値はカーネル側（sys/kern/subr_bus.c等）で定義されており、devdユーザランド側のコードからは直接確認不可
  - 候補：sys/kern/subr_bus.c / sys/kern/bus_if.m / カーネルsysctl定義
- クライアントソケットのパーミッション設定の詳細はevent_loop()内のソケット作成部分を精査する必要がある
  - 候補：devd.cc内のsocket()呼び出し / bind()呼び出し

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なイベント処理フロー（ソースコードから明確に確認可能）
- 1: 中リスク - カーネル側パラメータのデフォルト値（カーネルソース参照が必要）
- 0: 低リスク - セキュリティ考慮事項（shell_quoteの実装が確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] devctlキューサイズのデフォルト値をカーネルソースで確認
- [ ] クライアントソケットのパーミッション設定を確認
- [ ] event_loop()の完全な処理フローを確認（本レポートでは部分的に確認）
- [ ] SIGHUP受信時の設定再読み込みの詳細動作を確認
