---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：62-bhyveハイパーバイザ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **VM実行ループの詳細なVM Exit処理パターン**：vmexit.cの完全な読み込みが未実施
  2. **Capsicumサンドボックスの具体的な制限範囲**：capsicum_helpers.h参照が未実施
  3. **スナップショット機能の詳細**：BHYVE_SNAPSHOT条件コンパイル部分の網羅確認が未実施

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.sbin/bhyve/bhyverun.c` - メインソースコード
- E-02: `usr.sbin/bhyve/bhyverun.h` - ヘッダファイル
- E-03: `usr.sbin/bhyve/config.h` - 設定管理ヘッダ
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bhyveはType-2ハイパーバイザ | E-04 (62行目) | ○ |
| C-02 | guest_ncpus等のグローバル変数定義 | E-01 (103-104行目) | ○ |
| C-03 | CPUトポロジの解析ロジック | E-01 (137-174行目: bhyve_topology_parse) | ○ |
| C-04 | NUMAドメイン設定 | E-01 (190-242行目: bhyve_numa_parse) | ○ |
| C-05 | メモリアフィニティ計算 | E-01 (244-299行目: calc_mem_affinity) | ○ |
| C-06 | ドメインサイズ未指定時の均等分配 | E-01 (294-298行目: vm_memsize/guest_ndomains) | ○ |
| C-07 | Capsicumサンドボックス対応 | E-01 (30-32行目: #ifndef WITHOUT_CAPSICUM) | ○ |
| C-08 | BHYVE_SNAPSHOTによる条件コンパイル | E-01 (36-43行目: #ifdef BHYVE_SNAPSHOT) | ○ |
| C-09 | BHYVE_GDBによるGDBサポート | E-01 (83-85行目: #ifdef BHYVE_GDB) | ○ |
| C-10 | vmmapiライブラリ使用 | E-01 (76行目: #include <vmmapi.h>) | ○ |
| C-11 | MB/GBマクロ定義 | E-01 (100-101行目) | ○ |
| C-12 | vcpu_info構造体定義 | E-01 (121-125行目) | ○ |
| C-13 | デバイスエミュレーション初期化順序 | E-01 (78-98行目: include群) | ○ |
| C-14 | PCIスロット0はホストブリッジ予約 | E-01 (pci_emul.cの参照) | ○ |
| C-15 | UCL設定ファイル対応 | E-01 (69行目: #include <ucl.h>, BHYVE_SNAPSHOT内) | ○ |
| C-16 | VM Exit処理の詳細パターン | **根拠なし** | △ |
| C-17 | Capsicumの具体的制限範囲 | **根拠なし** | △ |
| C-18 | スナップショット/リストアの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- VM Exit処理の詳細はvmexit.cを読む必要がある
  - 候補：usr.sbin/bhyve/vmexit.c
- Capsicum制限の詳細はcapsicum_helpers.hとcap_enter()呼び出しの確認が必要
  - 候補：usr.sbin/bhyve/bhyverun.c内のcap_enter() / capsicum_helpers.h
- スナップショット機能はsnapshot.cの詳細確認が必要
  - 候補：usr.sbin/bhyve/snapshot.c

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本構造（main(), トポロジ解析）
- 1: 中リスク - VM Exit処理パターンの網羅性
- 1: 中リスク - セキュリティ（Capsicum制限の正確性）

## 6) レビュアーチェックリスト（最小）
- [ ] vmexit.cのVM Exit処理パターンを確認
- [ ] Capsicumサンドボックスの具体的な制限を確認
- [ ] スナップショット機能の詳細を確認
- [ ] bhyve.8マニュアルページとの整合性を確認
