---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 12
  claims_without_evidence: 3
confidence_derived: 0.80
---

# 根拠レポート：63-Hyper-Vサポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：12 / 15、根拠なし：3
- 優先レビュー（高）
  1. **VMBusバージョンネゴシエーションの詳細**：vmbus.c内部の詳細確認が未実施
  2. **KVPサービスの詳細**：カーネル側KVPドライバの確認が未実施
  3. **Azure固有の要件**：WALinuxAgent連携の詳細が未確認

## 2) 参照した情報（Evidence一覧）
- E-01: `libexec/hyperv/Makefile` - スクリプト一覧定義
- E-02: `sys/dev/hyperv/vmbus/vmbus.c` - VMBusバスドライバ（ファイル存在確認）
- E-03: `sys/dev/hyperv/storvsc/hv_storvsc_drv_freebsd.c` - ストレージドライバ（ファイル存在確認）
- E-04: `sys/dev/hyperv/input/hv_kbd.c` - キーボードドライバ（ファイル存在確認）
- E-05: `contrib/hyperv/tools/scripts/` - ユーザランドスクリプト群
- E-06: `sbin/devd/hyperv.conf` - devdイベント設定（ファイル存在確認）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Hyper-V統合サービスを提供 | E-07 (63行目) | ○ |
| C-02 | libexec/hyperv配下にスクリプト存在 | E-01 (hv_set_ifconfig, hv_get_dns_info, hv_get_dhcp_info, hyperv_vfattach, hyperv_vfup) | ○ |
| C-03 | VMBusドライバ存在 | E-02 (ファイル存在確認) | ○ |
| C-04 | storvscドライバ存在 | E-03 (ファイル存在確認) | ○ |
| C-05 | hv_kbdドライバ存在 | E-04 (ファイル存在確認) | ○ |
| C-06 | devdイベント設定存在 | E-06 (ファイル存在確認) | ○ |
| C-07 | vmbus_chan.c存在 | E-02 (ディレクトリ一覧で確認) | ○ |
| C-08 | vmbus_br.c存在 | E-02 (ディレクトリ一覧で確認) | ○ |
| C-09 | vmbus_et.c存在 | E-02 (ディレクトリ一覧で確認) | ○ |
| C-10 | hyperv.c存在 | E-02 (ディレクトリ一覧で確認) | ○ |
| C-11 | hv_hid.c存在 | E-04 (ディレクトリ一覧で確認) | ○ |
| C-12 | SR-IOV VFアタッチスクリプト | E-05 (hyperv_vfattach存在確認) | ○ |
| C-13 | VMBusバージョンネゴシエーション詳細 | **根拠なし** | △ |
| C-14 | KVPサービスの詳細仕様 | **根拠なし** | △ |
| C-15 | Azure固有の要件とWALinuxAgent連携 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- VMBusプロトコルバージョンネゴシエーションの詳細はvmbus.c内部を精査する必要がある
  - 候補：sys/dev/hyperv/vmbus/vmbus.c / vmbus_reg.h
- KVPサービスのカーネル側実装の確認
  - 候補：sys/dev/hyperv/utilities/
- Azure環境固有の要件は外部ドキュメントの参照が必要
  - 候補：Microsoft公式ドキュメント / FreeBSD Azure wiki

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイル構成と存在確認
- 1: 中リスク - VMBusプロトコルの詳細仕様
- 1: 中リスク - Azure環境固有の要件

## 6) レビュアーチェックリスト（最小）
- [ ] VMBusプロトコルバージョンネゴシエーションの詳細を確認
- [ ] KVPサービスの実装を確認
- [ ] hnネットワークドライバの場所と構成を確認
- [ ] Azure環境での追加要件を確認
