---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：64-Xenサポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **Xenstoreトランザクション機能の詳細**：xenstore/ディレクトリの詳細確認が未実施
  2. **メモリバルーンドライバの詳細**：xenmem/ディレクトリの詳細確認が未実施

## 2) 参照した情報（Evidence一覧）
- E-01: `sys/xen/xen_common.c` - 共通初期化コード
- E-02: `sys/xen/` ディレクトリ一覧 - ファイル構成確認
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Xenサポートはsys/xen/に存在 | E-02, E-03 | ○ |
| C-02 | hvm_start_flagsでPVHv2判定 | E-01 (48行目) | ○ |
| C-03 | HYPERVISOR_shared_infoグローバル変数 | E-01 (51行目) | ○ |
| C-04 | per-CPU vcpu_info | E-01 (54行目: DPCPU_DEFINE) | ○ |
| C-05 | xen_setup_vcpu_info関数 | E-01 (56-96行目) | ○ |
| C-06 | vcpu_info 64バイトアラインメント | E-01 (73-74行目: _Static_assert) | ○ |
| C-07 | MFN計算式 vtophys >> PAGE_SHIFT | E-01 (65行目) | ○ |
| C-08 | xen_domain()マクロによる環境検出 | E-01 (71行目: KASSERT(xen_domain())) | ○ |
| C-09 | evtchn.hの存在 | E-02 (evtchn.h確認) | ○ |
| C-10 | xenbus/ディレクトリの存在 | E-02 (xenbus/確認) | ○ |
| C-11 | xenstore/ディレクトリの存在 | E-02 (xenstore/確認) | ○ |
| C-12 | xenmem/ディレクトリの存在 | E-02 (xenmem/確認) | ○ |
| C-13 | features.c/hの存在 | E-02 (features.c, features.h確認) | ○ |
| C-14 | Xenstoreトランザクション機能の詳細 | **根拠なし** | △ |
| C-15 | メモリバルーンドライバの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Xenstoreトランザクションの詳細はxenstore/内のソースコードを精査する必要がある
  - 候補：sys/xen/xenstore/ 内のソースファイル
- メモリバルーンドライバの詳細はxenmem/内のソースコードを精査する必要がある
  - 候補：sys/xen/xenmem/ 内のソースファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本構造とファイル構成
- 0: 低リスク - xen_common.cの解析精度
- 1: 中リスク - サブディレクトリ内の詳細仕様

## 6) レビュアーチェックリスト（最小）
- [ ] xenstore/内のトランザクションAPIを確認
- [ ] xenmem/内のバルーンドライバ実装を確認
- [ ] evtchn/内の割り込みルーティング実装を確認
- [ ] FreeBSDのXenサポートがPVモードを非対応としている根拠を確認
