---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：65-jail（コンテナ）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **VNET機能の詳細実装**：カーネル側VNET実装の確認が未実施
  2. **kern_jail.cの内部構造体定義**：カーネル側のprison構造体の詳細が未確認

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.sbin/jail/jail.c` - メインソースコード
- E-02: `usr.sbin/jail/jailp.h` - 内部ヘッダファイル
- E-03: `sys/kern/kern_jail.c` - カーネルjailサブシステム（ファイル存在確認）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト設定ファイルは/etc/jail.conf | E-02 (38行目: CONF_FILE) | ○ |
| C-02 | 操作フラグJF_START/JF_SET/JF_STOP | E-02 (58-60行目) | ○ |
| C-03 | JF_CLEANUPフラグ | E-02 (70行目) | ○ |
| C-04 | startcommands配列の定義 | E-01 (84-107行目) | ○ |
| C-05 | stopcommands配列の定義 | E-01 (109-129行目) | ○ |
| C-06 | cleancommands配列の定義 | E-01 (131-147行目) | ○ |
| C-07 | perm_sysctl配列（互換パラメータ） | E-01 (75-82行目) | ○ |
| C-08 | getoptオプション文字列 | E-01 (188行目: "cCde:f:hiJ:lmn:p:qrRs:u:U:v") | ○ |
| C-09 | -eオプションでjail一覧表示 | E-01 (270-277行目) | ○ |
| C-10 | 旧式コマンドライン互換 | E-01 (280-287行目: oldcl=1) | ○ |
| C-11 | enum intparamの定義 | E-02 (79-100行目) | ○ |
| C-12 | PF_*フラグ定義 | E-02 (47-56行目) | ○ |
| C-13 | DF_*依存関係フラグ | E-02 (43-45行目) | ○ |
| C-14 | paralimit変数 | E-01 (231-233行目) | ○ |
| C-15 | ZFSデータセット委譲 | E-01 (101行目: IP_ZFS_DATASET) | ○ |
| C-16 | VNETインタフェース設定 | E-01 (102行目: IP_VNET_INTERFACE) | ○ |
| C-17 | IP4/IP6アドレス設定 | E-01 (153-161行目: listparams) | ○ |
| C-18 | exec.prepareからexec.poststartまでの順序 | E-01 (84-107行目: startcommands) | ○ |
| C-19 | exec.prestopからexec.releaseまでの順序 | E-01 (109-129行目: stopcommands) | ○ |
| C-20 | RDTUN(読み取り専用)パラメータ制御 | E-01 (48行目: JP_RDTUN, 63行目: rdtun_params) | ○ |
| C-21 | VNET機能の詳細実装 | **根拠なし** | △ |
| C-22 | kern_jail.cのprison構造体詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- VNET機能の実装詳細はカーネル側（sys/net/vnet.h等）で定義されている
  - 候補：sys/net/vnet.h / sys/kern/kern_jail.c内のVNET処理
- prison構造体の詳細はsys/sys/jail.hおよびkern_jail.cで定義されている
  - 候補：sys/sys/jail.h / sys/kern/kern_jail.c

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ユーザランドコマンドの処理フロー
- 0: 低リスク - 設定ファイルパーサ
- 1: 中リスク - カーネル側のjail実装詳細

## 6) レビュアーチェックリスト（最小）
- [ ] kern_jail.cのprison構造体を確認
- [ ] VNET機能のカーネル側実装を確認
- [ ] jail.8マニュアルページとの整合性を確認
- [ ] securelevel制御の詳細を確認
