---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 13
  claims_without_evidence: 3
confidence_derived: 0.81
---

# 根拠レポート：66-ブートローダ（loader）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.81**
  - 根拠あり：13 / 16、根拠なし：3
- 優先レビュー（高）
  1. **Luaブートメニューの詳細動作**：stand/lua/内のスクリプト群の確認が未実施
  2. **BIOS版ブートローダの処理フロー**：stand/i386/の確認が未実施
  3. **Secure Boot対応の詳細**：署名検証処理の確認が未実施

## 2) 参照した情報（Evidence一覧）
- E-01: `stand/efi/loader/main.c` - EFIローダメインソース（先頭80行）
- E-02: `stand/efi/loader/` ディレクトリ一覧
- E-03: `stand/` ディレクトリ一覧
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stand/ディレクトリにブートローダコード | E-03, E-04 | ○ |
| C-02 | EFI対応（stand/efi/loader/） | E-02 (ディレクトリ存在) | ○ |
| C-03 | main.c内のZFSブート対応 | E-01 (36-38行目: #ifdef EFI_ZFS_BOOT) | ○ |
| C-04 | ACPIテーブル検出 | E-01 (73-79行目: acpi関連include) | ○ |
| C-05 | EFIプロトコル使用 | E-01 (50-60行目: EFI include群) | ○ |
| C-06 | libsa使用 | E-03 (libsa/ディレクトリ存在) | ○ |
| C-07 | liblua使用 | E-03 (liblua/ディレクトリ存在) | ○ |
| C-08 | lua/スクリプトディレクトリ | E-03 (lua/ディレクトリ存在) | ○ |
| C-09 | 複数アーキテクチャ対応 | E-03 (arm64, i386, powerpc等) | ○ |
| C-10 | efizfs.h存在 | E-02 (efizfs.h) | ○ |
| C-11 | framebuffer対応 | E-02 (framebuffer.c, framebuffer.h) | ○ |
| C-12 | version.veriexec存在 | E-02 (version.veriexec) | ○ |
| C-13 | kbootディレクトリ存在 | E-03 (kboot/) | ○ |
| C-14 | Luaブートメニューの詳細動作 | **根拠なし** | △ |
| C-15 | BIOS版の処理フロー | **根拠なし** | △ |
| C-16 | Secure Boot対応の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Luaブートメニューの詳細はstand/lua/内のスクリプトを精査する必要がある
  - 候補：stand/lua/menu.lua / stand/lua/config.lua
- BIOS版ブートローダはstand/i386/内に存在
  - 候補：stand/i386/loader/main.c
- Secure Boot対応は署名検証コードの確認が必要
  - 候補：stand/efi/loader/ 内の署名関連コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイル構成と基本アーキテクチャ
- 1: 中リスク - Luaスクリプトの詳細動作
- 1: 中リスク - Secure Boot対応の正確性

## 6) レビュアーチェックリスト（最小）
- [ ] stand/lua/内のブートメニュースクリプトを確認
- [ ] stand/i386/のBIOS版ブートローダを確認
- [ ] Secure Boot関連の処理を確認
- [ ] loader.confの全パラメータ一覧をdefaults/loader.confで確認
