---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：69-init / rc

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **rc.subrのrun_rc_command()の詳細ロジック**：シェルスクリプトの読み込みが未実施
  2. **rc.d/配下の個別スクリプトの構造**：代表的なスクリプトの確認が未実施

## 2) 参照した情報（Evidence一覧）
- E-01: `sbin/init/init.c` - initメインソース（300行読み込み）
- E-02: `sbin/rcorder/rcorder.c` - rcorderソース（80行読み込み）
- E-03: `libexec/rc/` ディレクトリ一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面関連
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PID 1検証 | E-01 (199-200行目: getuid()!=0, 205行目: getpid()!=1) | ○ |
| C-02 | state_func_t型定義 | E-01 (107-108行目) | ○ |
| C-03 | 状態関数群の宣言 | E-01 (110-118行目: single_user, runcom, read_ttys等) | ○ |
| C-04 | runcom_mode（AUTOBOOT/FASTBOOT） | E-01 (123行目) | ○ |
| C-05 | init_session構造体 | E-01 (141-160行目) | ○ |
| C-06 | GETTY_SPACING=5 | E-01 (78行目) | ○ |
| C-07 | GETTY_SLEEP=30 | E-01 (79行目) | ○ |
| C-08 | GETTY_NSPACE=3 | E-01 (80行目) | ○ |
| C-09 | DEATH_WATCH=10 | E-01 (83行目) | ○ |
| C-10 | DEATH_SCRIPT=120 | E-01 (84行目) | ○ |
| C-11 | setsid()呼び出し | E-01 (258行目) | ○ |
| C-12 | setlogin("root") | E-01 (265行目) | ○ |
| C-13 | オプション-d,-s,-f,-r | E-01 (272-289行目) | ○ |
| C-14 | SysV互換モード | E-01 (206-241行目: COMPAT_SYSV_INIT) | ○ |
| C-15 | BOOTTRACE()マクロ | E-01 (202行目) | ○ |
| C-16 | reroot機能 | E-01 (118行目: reroot, reroot_phase_two, 284行目) | ○ |
| C-17 | session_db (BerkeleyDB) | E-01 (180,184行目: start_session_db, session_db) | ○ |
| C-18 | SECURE定義時のパスワード要求 | E-01 (66-67行目: #ifdef SECURE, #include <pwd.h>) | ○ |
| C-19 | rcorder REQUIRE/PROVIDE/BEFORE/KEYWORD | E-02 (65-78行目) | ○ |
| C-20 | libexec/rc/ディレクトリ構成 | E-03 (rc, rc.subr, rc.conf, rc.shutdown, rc.d等) | ○ |
| C-21 | 画面25との関連 | E-04 (画面25行) | ○ |
| C-22 | 画面26との関連 | E-04 (画面26行) | ○ |
| C-23 | rc.subrのrun_rc_command詳細 | **根拠なし** | △ |
| C-24 | rc.d/個別スクリプトの構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- rc.subrのrun_rc_command()の詳細ロジックはシェルスクリプトの読み込みが必要
  - 候補：libexec/rc/rc.subr
- rc.d/配下の代表的なスクリプト構造
  - 候補：libexec/rc/rc.d/sshd, libexec/rc/rc.d/networking

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - initの状態遷移ロジック
- 0: 低リスク - 定数値とデータ構造
- 0: 低リスク - rcorderの依存関係解決パターン
- 1: 中リスク - RCスクリプトフレームワークの詳細

## 6) レビュアーチェックリスト（最小）
- [ ] rc.subrのrun_rc_command()を確認
- [ ] rc.d/配下の代表的なスクリプト構造を確認
- [ ] initの各状態関数（runcom, multi_user, death等）の詳細を確認
- [ ] init.8マニュアルとの整合性を確認
