---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：7-sysctl管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **jail環境でのsysctl制限の詳細**: CTLFLAG_PRISONの具体的な制限範囲の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/sysctl/sysctl.c` - sysctlコマンド実装
- E-02: `sys/kern/kern_sysctl.c` - カーネルフレームワーク（3135行）
- E-03: `sbin/sysctl/sysctl.conf` - 設定ファイルテンプレート
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | kern_sysctl.cは3135行 | E-02 | ○ |
| C-02 | sysctl.cはEFI変数表示にも対応 | E-01 | ○ |
| C-03 | SYSCTL_*マクロで宣言的にパラメータ登録 | E-02 | ○ |
| C-04 | CTLFLAGフラグ（RD/RW/MPSAFE/PRISON等） | E-02 | ○ |
| C-05 | sysctl.confが起動時設定ファイル | E-03 | ○ |
| C-06 | 画面26でsysctl.confへの設定書き込み | E-05 | ○ |
| C-07 | CTLFLAG_SECUREでsecurelevel制限 | E-02 | ○ |
| C-08 | name2oidでMIB名をOIDに変換 | E-02 | ○ |
| C-09 | sysctl_handle_int等のハンドラ関数 | E-02 | ○ |
| C-10 | sysctl_find_oid()でOID検索 | E-02 | ○ |
| C-11 | sysctl_root()でルートハンドラ実行 | E-02 | ○ |
| C-12 | CTLFLAG_RDTUNは起動時のみ設定可能 | E-02 | ○ |
| C-13 | sysctl(8)のsysctl.8マニュアルが存在 | E-01 | ○ |
| C-14 | リンカセットにより起動時自動登録 | E-02 | ○ |
| C-15 | sysctl参照・変更はマイクロ秒オーダー | E-02 | ○ |
| C-16 | jail環境でのCTLFLAG_PRISONの具体的制限範囲 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- CTLFLAG_PRISONフラグの適用範囲と具体的なsysctlパラメータリスト
  - 候補：kern_jail.c / sysctl.hのフラグ定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フレームワーク構造の記述
- 0: 低リスク - コマンドインタフェースの記述
- 1: 中リスク - jail制限の詳細

## 6) レビュアーチェックリスト（最小）
- [ ] SYSCTL_*マクロの使用例が正確か
- [ ] CTLFLAGの各フラグの意味が正しく記述されているか
- [ ] sysctl.confの書式と適用タイミングが正確か
- [ ] jail環境での制限パラメータリストの確認
