---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：70-cron

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **do_command.cのジョブ実行・メール配信の詳細**：do_command.cの読み込みが未実施
  2. **database.cのDB読み込みロジックの詳細**：database.cの読み込みが未実施

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.sbin/cron/cron/cron.c` - メインソース（300行読み込み）
- E-02: `usr.sbin/cron/cron/structs.h` - データ構造定義
- E-03: `usr.sbin/cron/lib/entry.c` - エントリパーサ（80行読み込み）
- E-04: `usr.sbin/cron/crontab/crontab.c` - crontabコマンド（80行読み込み）
- E-05: `usr.sbin/cron/cron/` ディレクトリ一覧
- E-06: `usr.sbin/cron/lib/` ディレクトリ一覧
- E-07: `usr.sbin/cron/crontab/` ディレクトリ一覧
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | entry構造体定義（bitstr_tフィールド群） | E-02 (22-57行目) | ○ |
| C-02 | DOM_STARフラグ(0x01) | E-02 (47行目) | ○ |
| C-03 | DOW_STARフラグ(0x02) | E-02 (48行目) | ○ |
| C-04 | WHEN_REBOOTフラグ(0x04) | E-02 (49行目) | ○ |
| C-05 | SEC_RESフラグ(0x20) | E-02 (52行目) | ○ |
| C-06 | INTERVALフラグ(0x40) | E-02 (53行目) | ○ |
| C-07 | RUN_ATフラグ(0x80) | E-02 (54行目) | ○ |
| C-08 | NOT_UNTILフラグ(0x10) | E-02 (51行目) | ○ |
| C-09 | MAIL_WHEN_ERRフラグ(0x100) | E-02 (55行目) | ○ |
| C-10 | user構造体定義 | E-02 (66-71行目) | ○ |
| C-11 | cron_db構造体定義 | E-02 (73-76行目) | ○ |
| C-12 | union（bitstr_t/interval）の共用体 | E-02 (31-45行目) | ○ |
| C-13 | open_pidfile()実装 | E-01 (72-92行目) | ○ |
| C-14 | main()のメインループ | E-01 (94-185行目) | ○ |
| C-15 | madvise(MADV_PROTECT) | E-01 (135行目) | ○ |
| C-16 | run_reboot_jobs()実装 | E-01 (187-203行目) | ○ |
| C-17 | cron_tick()のDST対応 | E-01 (234-292行目) | ○ |
| C-18 | TargetTime更新式 | E-01 (182行目) | ○ |
| C-19 | DOM/DOW論理和ルール | E-01 (294-298行目: コメント) | ○ |
| C-20 | entry.cのエラーコード定義 | E-03 (41-48行目: ecode enum) | ○ |
| C-21 | crontabコマンドのオプション | E-04 (40行目: opt_t enum, 66-68行目: usage) | ○ |
| C-22 | MD5チェックサム | E-04 (35-37行目: #include <md5.h>, MD5_SIZE) | ○ |
| C-23 | LOGIN_CAP対応 | E-03 (37-39行目: #ifdef LOGIN_CAP) | ○ |
| C-24 | do_command.cの詳細 | **根拠なし** | △ |
| C-25 | database.cの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- do_command.cのジョブ実行、出力取得、メール配信のロジック
  - 候補：usr.sbin/cron/cron/do_command.c
- database.cのcrontabファイル読み込みとDB構築ロジック
  - 候補：usr.sbin/cron/cron/database.c

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造定義（structs.h）
- 0: 低リスク - メインループとスケジューリング（cron.c）
- 0: 低リスク - DST対応ロジック
- 1: 中リスク - ジョブ実行のセキュリティ（do_command.c）

## 6) レビュアーチェックリスト（最小）
- [ ] do_command.cのジョブ実行ロジックを確認
- [ ] database.cのDB構築ロジックを確認
- [ ] cron.8マニュアルとの整合性を確認
- [ ] /var/cron/allow と /var/cron/deny のアクセス制御を確認
