---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：71-syslogd

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **TCP転送サポート**：コードではUDP転送のみ明示的に確認、TCP転送の実装詳細は要確認
  2. **RFC 5424完全準拠**：output_format列挙型にFORMAT_RFC5424は存在するが詳細実装の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `usr.sbin/syslogd/syslogd.c`（メインソースコード）
- E-02: `usr.sbin/syslogd/syslogd.h`（ヘッダファイル、データ構造定義）
- E-03: `usr.sbin/syslogd/syslogd_cap.c`（Capsicumサービス定義）
- E-04: `usr.sbin/syslogd/pathnames.h`（パス定義）
- E-05: `usr.sbin/syslogd/syslogd.8`（manページ）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | syslogdはUNIXドメインソケット/var/run/logでメッセージを受信する | E-01, E-04 | ○ |
| C-02 | UDP/TCPソケット経由でリモートメッセージを受信する | E-01 | △ |
| C-03 | syslog.confに基づくファシリティ/プライオリティフィルタリング | E-02 (f_pmask配列) | ○ |
| C-04 | プロパティベースフィルタリングをサポート | E-02 (prop_filter構造体) | ○ |
| C-05 | F_FILE, F_TTY, F_CONSOLE, F_FORW, F_USERS, F_WALL, F_PIPEの7種類の出力先 | E-02 (f_type列挙型) | ○ |
| C-06 | RFC 3164およびRFC 5424形式をサポート | E-01 (output_format列挙型) | ○ |
| C-07 | SIGHUP受信時に設定ファイルを再読み込みする | E-01 (sigcatch配列にSIGHUP) | ○ |
| C-08 | メッセージ重複圧縮機能がある | E-01 (repeatinterval配列, BACKOFF) | ○ |
| C-09 | Capsicumケイパビリティモードによるサンドボックス化 | E-03 (CREATE_SERVICE) | ○ |
| C-10 | デフォルトプライオリティはLOG_USER|LOG_NOTICE | E-01 (DEFUPRI定義、79行目) | ○ |
| C-11 | 最大行長は8192バイト | E-02 (MAXLINE定義、81行目) | ○ |
| C-12 | 受信バッファ最小サイズは80KB | E-01 (RCVBUF_MINSIZE、83行目) | ○ |
| C-13 | マーク間隔デフォルトは20分 | E-01 (MarkInterval = 20 * 60、298行目) | ○ |
| C-14 | kqueue(2)によるイベント駆動型処理 | E-01 (kq変数、330行目, sys/event.hインクルード) | ○ |
| C-15 | SecureModeによるリモート受信制限 | E-01 (SecureMode変数、301行目) | ○ |
| C-16 | allowedpeer機構によるアクセス制御 | E-01 (allowedpeer構造体) | ○ |
| C-17 | C1文字マスキングがデフォルト有効 | E-01 (mask_C1 = 1、308行目) | ○ |
| C-18 | includeディレクティブをサポート | E-01 (include_str, include_ext定数、135-136行目) | ○ |
| C-19 | 重複メッセージ間隔は30秒/120秒/600秒 | E-01 (repeatinterval配列、252行目) | ○ |
| C-20 | TTYメッセージ送信タイムアウトは1秒 | E-01 (TTYMSGTIME定義、82行目) | ○ |
| C-21 | deadqueueによるパイププロセス管理 | E-01 (deadq_entry構造体、DQ_TIMO_INIT) | ○ |
| C-22 | peer/socklistによるソケット管理 | E-01 (peer構造体、socklist構造体) | ○ |
| C-23 | IPv4/IPv6デュアルスタック対応 | E-01 (family変数、PF_UNSPEC) | ○ |
| C-24 | TCP転送の詳細実装 | **根拠不足** | △ |
| C-25 | RFC 5424フォーマットの完全な実装詳細 | E-01 (FORMAT_RFC5424列挙値は存在) | ○ |

## 4) 不足情報（Unknown / Missing）
- TCP転送の実装詳細について、ソースコードの全体を確認する必要がある。syslogd.cのソケット処理部分でTCP対応コードが存在するかの完全な確認が未了。
  - 候補：syslogd.cのaddsock関数 / F_FORW処理部分 / manページの確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張はソースコードから直接確認可能
- 1: 中リスク - TCP転送サポートの詳細は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] syslogd.cのaddsock/fprintlog_write関数でTCP転送が実装されているか確認
- [ ] RFC 5424フォーマット出力の完全な実装を確認
- [ ] Capsicumサンドボックスが全プラットフォームで有効か確認
- [ ] syslog.confのincludeディレクティブの動作を実機で検証
