---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：72-shutdown_reboot

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **die_you_gravy_sucking_pig_dog()の実装詳細**：関数の完全な実装は未読了

## 2) 参照した情報（Evidence一覧）
- E-01: `sbin/shutdown/shutdown.c`（shutdownソースコード）
- E-02: `sbin/reboot/reboot.c`（rebootソースコード）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | root権限が必要（euid==0チェック） | E-01 (110行目) | ○ |
| C-02 | poweroffはargv[0]判定で動作切替 | E-01 (122-137行目) | ○ |
| C-03 | -c/-h/-k/-p/-rは排他オプション | E-01 (181行目) | ○ |
| C-04 | tlist配列による警告間隔定義 | E-01 (62-77行目) | ○ |
| C-05 | NOLOG_TIME=5*60（5分前にnologin作成） | E-01 (61行目) | ○ |
| C-06 | fork()によるデーモン化 | E-01 (249-253行目) | ○ |
| C-07 | noshutdownファイルチェック | E-01 (225-228行目) | ○ |
| C-08 | rebootはhalt/nextbootとプログラム名で分岐 | E-02 (271-284行目) | ○ |
| C-09 | initへのシグナルマッピング | E-02 (237-242行目) | ○ |
| C-10 | nextboot.confへのアトミック書き込み | E-02 (115-197行目) | ○ |
| C-11 | ZFS環境でzfsbootcfg連携 | E-02 (74-113行目) | ○ |
| C-12 | write_nextbootでmkstemp+rename方式 | E-02 (151, 187行目) | ○ |
| C-13 | fsyncによる書き込み保証 | E-02 (185行目) | ○ |
| C-14 | howtoフラグにRB_DUMP等を設定 | E-02 (298行目) | ○ |
| C-15 | syslog(LOG_AUTH)でログ記録 | E-01 (257行目) | ○ |
| C-16 | BOOTTRACEマクロによるトレース記録 | E-01 (232行目), E-02 (245行目) | ○ |
| C-17 | loop関数での警告スケジュール処理 | E-01 (263-299行目) | ○ |
| C-18 | fastboot/fasthaltのプレフィックス対応 | E-02 (271-273行目) | ○ |
| C-19 | PATH_NEXTBOOT="/boot/nextboot.conf" | E-02 (57行目) | ○ |
| C-20 | die_you_gravy_sucking_pig_dog()の完全な実装 | **根拠不足（関数の後半未読了）** | △ |

## 4) 不足情報（Unknown / Missing）
- shutdown.cのdie_you_gravy_sucking_pig_dog()関数の完全な実装は、読み込み範囲外のため詳細確認が未了
  - 候補：shutdown.cの該当関数全体の読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドの動作は明確でコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] die_you_gravy_sucking_pig_dog()関数の完全な実装を確認
- [ ] rebootの-rオプション（reroot）の動作詳細を確認
- [ ] noshutdownファイルの作成者・管理方法を確認
