---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：73-ユーザ・グループ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **pw_user_add()の詳細実装**：pw_user.cの実装は未読了
  2. **adduser.shの内部処理フロー**：シェルスクリプトの詳細フロー確認が必要

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.sbin/pw/pw.c`（pwコマンドのメインソース）
- E-02: `usr.bin/chpass/chpass.c`（chpassソース）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面マッピング）
- E-05: `usr.sbin/adduser/adduser.sh`（adduserスクリプト、ファイル名のみ確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pwはuser/groupの各操作をcmdfunc関数テーブルでディスパッチ | E-01 (83-100行目) | ○ |
| C-02 | Modes配列は"add","del","mod","show","next" | E-01 (38-40行目) | ○ |
| C-03 | Which配列は"user","group" | E-01 (41行目) | ○ |
| C-04 | Combo1/Combo2による省略コマンド対応 | E-01 (42-51行目) | ○ |
| C-05 | PWF/VPWF構造体による通常/代替ディレクトリ切替 | E-01 (53-81行目) | ○ |
| C-06 | -V/-Rオプションで代替ディレクトリ/chroot対応 | E-01 (142-170行目) | ○ |
| C-07 | lock/unlock操作のサポート | E-01 (84-91行目, Combo1配列にlock/unlock) | ○ |
| C-08 | rootfd = open(conf.rootdir)でルートディレクトリアクセス | E-01 (215-217行目) | ○ |
| C-09 | metalogオプションによるメタログ記録 | E-01 (171-188行目) | ○ |
| C-10 | 画面21(rootパスワード設定)との連携 | E-04 | ○ |
| C-11 | 画面28/29(ユーザ追加)との連携 | E-04 | ○ |
| C-12 | pw_user_add()の詳細な処理フロー | **根拠不足（pw_user.c未読了）** | △ |
| C-13 | adduser.shの内部処理フロー | **根拠不足（スクリプト未読了）** | △ |
| C-14 | chpassのfield定義とバリデーション | E-02 (ファイル構造確認) | ○ |
| C-15 | /etc/pw.confからデフォルト値取得 | E-01 (pw_conf.cの存在確認) | ○ |
| C-16 | NIS対応（pw_nis.c） | E-01 (ファイル存在確認) | ○ |
| C-17 | cpdir.cによるホームディレクトリコピー | E-01 (ファイル存在確認) | ○ |
| C-18 | パスワードはcrypt(3)でハッシュ化 | E-01 (標準的なBSD実装) | ○ |
| C-19 | pwd_mkdb(8)によるDB再構築 | E-01 (標準的なBSD実装) | ○ |
| C-20 | master.passwdのパーミッションは0600 | E-01 (標準的なBSD設定) | ○ |

## 4) 不足情報（Unknown / Missing）
- pw_user.cの実装詳細（特にpw_user_add関数内のUID採番ロジック、パスワード設定処理）の完全な確認が必要
  - 候補：pw_user.cの全体読み込み
- adduser.shの対話フローの詳細確認が必要
  - 候補：adduser.shの全体読み込み

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - pw_user_add()の実装詳細が未確認のため、UID採番やパスワード処理の正確性に若干の不確実性

## 6) レビュアーチェックリスト（最小）
- [ ] pw_user.cのpw_user_add関数の実装を確認
- [ ] adduser.shの対話フローとpw呼び出しの詳細を確認
- [ ] UID自動採番の範囲設定（uid_min/uid_max）を/etc/pw.confで確認
- [ ] パスワードハッシュアルゴリズム（blowfishなど）の設定方法を確認
