---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：76-コアダンプ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ネットダンプの完全な処理フロー**：dumpon.cのネットダンプ設定処理の詳細は部分的に確認

## 2) 参照した情報（Evidence一覧）
- E-01: `sbin/dumpon/dumpon.c`（dumponソースコード）
- E-02: `sbin/savecore/savecore.c`（savecoreソースコード）
- E-03: `sbin/decryptcore/decryptcore.c`（decryptcoreソースコード）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | dumponのusage（ディスク/ネットワーク/off/list） | E-01 (76-83行目) | ○ |
| C-02 | find_gateway関数でネットダンプゲートウェイ検索 | E-01 (88-99行目) | ○ |
| C-03 | HAVE_CRYPTOによるRSA暗号化条件コンパイル | E-01 (64-69行目) | ○ |
| C-04 | BUFFERSIZE = 1024*1024 (1MB) | E-02 (98行目) | ○ |
| C-05 | STATUS_BAD定数の定義 | E-02 (100行目) | ○ |
| C-06 | zlib/zstdのインクルード | E-02 (88-89行目) | ○ |
| C-07 | Capsicumサンドボックス化（capsicum_helpers.h） | E-02 (72行目) | ○ |
| C-08 | libcasperのcap_fileargs/cap_syslog使用 | E-02 (91-93行目) | ○ |
| C-09 | libxo出力対応 | E-02 (95行目) | ○ |
| C-10 | DECRYPTCORE_CRASHDIR = "/var/crash" | E-03 (49行目) | ○ |
| C-11 | OpenSSL API使用（EVP, PEM, RSA, engine） | E-03 (41-45行目) | ○ |
| C-12 | read_key関数でkerneldumpkey読み込み | E-03 (76-80行目) | ○ |
| C-13 | wait_for_process関数で子プロセス待機 | E-03 (60-74行目) | ○ |
| C-14 | kerneldump.hインクルード | E-01, E-02, E-03 | ○ |
| C-15 | 画面25（サービス選択）でdumpdev設定 | E-05 | ○ |
| C-16 | ネットダンプ用netdump.hインクルード | E-01 (62行目) | ○ |
| C-17 | savecoreのsyslog使用 | E-02 (84行目) | ○ |
| C-18 | ネットダンプの完全な処理フロー | **根拠不足（dumpon.cの後半未読了）** | △ |

## 4) 不足情報（Unknown / Missing）
- dumpon.cのネットダンプ設定処理（-s/-cオプション）の完全な実装フロー確認が必要
  - 候補：dumpon.cのmain関数以降の読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コアダンプ管理の基本構造は明確

## 6) レビュアーチェックリスト（最小）
- [ ] dumpon.cのネットダンプ設定処理を確認
- [ ] savecore.cのダンプヘッダ検証ロジックを確認
- [ ] kerneldumpheader構造体の全フィールドを確認
