---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：78-電源管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **acpiconfの実装詳細**：acpiconf/ディレクトリの実装は未読了
  2. **apmdのイベントループ詳細**：apmd.cのmain関数以降は未読了

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.sbin/apm/apm.c`（apmソースコード）
- E-02: `usr.sbin/apmd/`（apmdディレクトリ構造）
- E-03: `usr.sbin/acpi/`（acpiディレクトリ構造）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APMDEV = "/dev/apm" | E-01 (31行目) | ○ |
| C-02 | APM_UNKNOWN = 255 | E-01 (33行目) | ○ |
| C-03 | is_true関数のboolean解析 | E-01 (54-77行目) | ○ |
| C-04 | int2bcd/bcd2int関数 | E-01 (79-100行目) | ○ |
| C-05 | cmos_wall変数 | E-01 (39行目) | ○ |
| C-06 | apmdparse.yによるyacc文法パーサ | E-02 (ファイル存在確認) | ○ |
| C-07 | apmdlex.lによるlex字句解析 | E-02 (ファイル存在確認) | ○ |
| C-08 | apmd.conf設定ファイル | E-02 (ファイル存在確認) | ○ |
| C-09 | acpiconf/acpidump/iaslの存在 | E-03 (ディレクトリ構造確認) | ○ |
| C-10 | 画面25(サービス選択)でpowerd設定 | E-05 | ○ |
| C-11 | usage文字列から-ablstzZdehrオプション確認 | E-01 (44-46行目) | ○ |
| C-12 | acpiconfのACPIスリープ状態(S1-S5)制御 | **根拠不足（acpiconf未読了）** | △ |
| C-13 | apmdのイベントループ処理の詳細 | **根拠不足（apmd.c未読了）** | △ |
| C-14 | apmd.hの型定義 | E-02 (ファイル存在確認) | ○ |
| C-15 | README存在 | E-02 (ファイル存在確認) | ○ |
| C-16 | machine/apm_bios.hインクルード | E-01 (22行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- acpiconfの具体的なACPIスリープ状態制御の実装確認が必要
  - 候補：usr.sbin/acpi/acpiconf/のソースコード読み込み
- apmd.cのmain関数およびイベントループの完全な実装確認が必要
  - 候補：usr.sbin/apmd/apmd.cの全体読み込み

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - ACPI関連の実装詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] acpiconfのACPIスリープ状態制御コードを確認
- [ ] apmd.cのイベントループ実装を確認
- [ ] machine/apm_bios.hのioctl定義を確認
- [ ] powerd(8)との連携方法を確認
