---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：8-DTrace動的トレーシング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **有効プローブのオーバーヘッド数値**: 数百ナノ秒〜数マイクロ秒の根拠

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/kern/kern_dtrace.c` - DTraceカーネルフック
- E-02: `sys/cddl/contrib/opensolaris/uts/common/dtrace/dtrace.c` - DTraceコアエンジン
- E-03: `sys/cddl/contrib/opensolaris/uts/common/dtrace/fasttrap.c` - fasttrapプロバイダ
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KDTRACE_PROC_SIZE=64は43行目で定義 | E-01 | ○ |
| C-02 | KDTRACE_THREAD_SIZE=256は44行目で定義 | E-01 | ○ |
| C-03 | FEATURE(kdtrace_hooks)は46-47行目で宣言 | E-01 | ○ |
| C-04 | M_KDTRACEは49行目で定義 | E-01 | ○ |
| C-05 | dtrace_trap_funcは52行目で宣言 | E-01 | ○ |
| C-06 | dtrace_doubletrap_funcは53行目で宣言 | E-01 | ○ |
| C-07 | dtrace_pid_probe_ptrは54行目で宣言 | E-01 | ○ |
| C-08 | dtrace_return_probe_ptrは55行目で宣言 | E-01 | ○ |
| C-09 | systrace_enabledは57行目で__read_frequently付きで宣言 | E-01 | ○ |
| C-10 | systrace_probe_funcは58行目で宣言 | E-01 | ○ |
| C-11 | DTraceはCDDLライセンス | E-02 | ○ |
| C-12 | フックアーキテクチャによるライセンス分離 | E-01 | ○ |
| C-13 | 無効プローブのオーバーヘッドはほぼゼロ | E-01 | ○ |
| C-14 | dtrace.cがcddlディレクトリに存在 | E-02 | ○ |
| C-15 | fasttrap.cがcddlディレクトリに存在 | E-03 | ○ |
| C-16 | 画面26でDTrace破壊モード無効化設定 | E-05 | ○ |
| C-17 | DTrace使用にroot権限必要 | E-01 | ○ |
| C-18 | 有効プローブのオーバーヘッドが数百ns〜数us | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- DTraceプローブ発火時のオーバーヘッド実測データ
  - 候補：DTrace性能ベンチマーク / FreeBSD DTraceドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - kern_dtrace.cの行番号・変数名対応
- 0: 低リスク - ライセンス構造の記述
- 1: 中リスク - パフォーマンス数値

## 6) レビュアーチェックリスト（最小）
- [ ] フック変数の宣言が最新ソースと一致するか
- [ ] SDTプローブマクロの使用方法が正確か
- [ ] CDDLライセンスとBSDライセンスの分離が正しく記述されているか
- [ ] DTrace破壊モードの制御方法が正確か
