---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：82-プロセス管理コマンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **pkill/pgrepのargv[0]切替動作**：pkill.cの直接確認が必要
  2. **pwaitの詳細実装**：pwait.cの直接確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `bin/ps/ps.c` - psメインプログラム
- E-02: `bin/ps/ps.h` - psデータ構造定義（101行）
- E-03: `bin/ps/extern.h` - ps外部関数宣言
- E-04: `bin/kill/kill.c` - killコマンド実装
- E-05: `usr.bin/pkill/pkill.c` - pkillファイル存在確認
- E-06: `usr.bin/pwait/pwait.c` - pwaitファイル存在確認
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | psはkvm_getprocs()でプロセス情報取得 | E-01 (ps.c:kvm.hインクルード) | ○ |
| C-02 | psはlibxoで構造化出力対応 | E-01 (ps.c:67行目 libxo/xo.hインクルード) | ○ |
| C-03 | KINFO構造体はkinfo_procのラッパー | E-02 (ps.h:43-55行目) | ○ |
| C-04 | VAR構造体はoproc関数ポインタを持つ | E-02 (ps.h:89行目) | ○ |
| C-05 | killデフォルトシグナルはSIGTERM | E-04 (kill.c:65行目) | ○ |
| C-06 | kill -lでシグナル名一覧表示 | E-04 (kill.c:68行目) | ○ |
| C-07 | kill.cはSHELLマクロでビルトイン対応 | E-04 (kill.c:44-46行目) | ○ |
| C-08 | シグナル番号>=128は-128して解釈 | E-04 (kill.c:78行目) | ○ |
| C-09 | psは端末関連定義_PATH_PTSを使用 | E-01 (ps.c:71行目) | ○ |
| C-10 | psのリスト区切りはW_SEPとT_SEP | E-01 (ps.c:73-74行目) | ○ |
| C-11 | ki_pcpuはdouble型でCPU使用率を格納 | E-02 (ps.h:48行目) | ○ |
| C-12 | ki_memsizeはsegsz_t型 | E-02 (ps.h:49行目) | ○ |
| C-13 | pkill.cが存在する | E-05 | ○ |
| C-14 | pwait.cが存在する | E-06 | ○ |
| C-15 | pkill/pgrepはargv[0]で動作切替 | **根拠不足** | △ |
| C-16 | pwaitの詳細な待機メカニズム | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- pkill.cの直接読解によるargv[0]判定ロジックの確認
  - 候補：usr.bin/pkill/pkill.c のmain()関数
- pwaitのプロセス待機メカニズム（kqueue/waitpid/procctl等）の確認
  - 候補：usr.bin/pwait/pwait.c のmain()関数

## 5) リスクフラグ（レビュー観点）
- 0: psのデータ構造とkvm連携（ソースコードで確認済み）
- 0: killのシグナル処理（ソースコードで確認済み）
- 1: pkill/pgrepの動作切替メカニズム（間接的な推定）
- 1: pwaitの実装詳細（ファイル存在のみ確認）

## 6) レビュアーチェックリスト（最小）
- [ ] psのgetopt文字列と設計書のオプション一覧が一致しているか確認
- [ ] pkill.cを読んでargv[0]による動作切替を検証
- [ ] pwait.cを読んでプロセス待機メカニズムを確認
- [ ] jail環境でのプロセス表示制限の正確性を確認
