---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 12
  claims_without_evidence: 3
confidence_derived: 0.80
---

# 根拠レポート：85-エディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：12 / 15、根拠なし：3
- 優先レビュー（高）
  1. **nviの内部アーキテクチャ詳細**：exディレクトリ内のソースコード確認が必要
  2. **eeの実装詳細**：ee.cの直接確認が必要
  3. **viのスワップファイルメカニズム**：nviのリカバリ実装の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `bin/ed/main.c` - edメインプログラム（60行目まで読解）
- E-02: `bin/ed/ed.h` - edヘッダ（存在確認）
- E-03: `bin/ed/` ディレクトリ一覧 - 14ファイル
- E-04: `usr.bin/vi/` ディレクトリ一覧 - ヘッダファイル群
- E-05: `usr.bin/ee/` ディレクトリ一覧 - Makefile + nls/
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | edはsetjmp/longjmpでエラー回復 | E-01 (main.c:53-57行目) | ○ |
| C-02 | edのstdinbuf[1]バッファ | E-01 (main.c:59-60行目) | ○ |
| C-03 | edはKernighan-Plaugerアルゴリズム | E-01 (main.c:33-34行目コメント) | ○ |
| C-04 | edのバッファリングはRodney Ruddock考案 | E-01 (main.c:36-37行目コメント) | ○ |
| C-05 | edのソースは14ファイル構成 | E-03 | ○ |
| C-06 | viのconfig.h存在 | E-04 | ○ |
| C-07 | viのex_def.h存在 | E-04 | ○ |
| C-08 | viのoptions_def.h存在 | E-04 | ○ |
| C-09 | viのvi_extern.h/ex_extern.h/common_extern.h存在 | E-04 | ○ |
| C-10 | eeのNLS対応 | E-05 (nls/ディレクトリ存在) | ○ |
| C-11 | eeはMakefile + nlsの構成 | E-05 | ○ |
| C-12 | viはnvi実装 | E-04 (version.h存在) | ○ |
| C-13 | nviの3層構造（ex/vi/common） | **根拠不足** | △ |
| C-14 | viのスワップファイルリカバリ | **根拠不足** | △ |
| C-15 | eeはcurses/termcapベース | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- nviのex/ディレクトリ内ソースコードの直接確認
  - 候補：contrib/nvi/ または usr.bin/vi/ex/ の構造確認
- eeのee.c実装の確認（contrib/eeまたは別の場所に存在する可能性）
  - 候補：contrib/ee/ ディレクトリ
- viのスワップファイル実装の確認
  - 候補：nviのrecover関連ソースコード

## 5) リスクフラグ（レビュー観点）
- 0: edの基本構造とアルゴリズム（ソースコードとコメントで確認済み）
- 1: nviの内部アーキテクチャ（ヘッダファイルから推定）
- 1: eeの実装詳細（ディレクトリ構成から推定）
- 2: viのリカバリメカニズム（未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] nviのソースディレクトリ構造（contrib/nvi/）を確認
- [ ] eeのメインソースファイル（ee.c）の所在を確認
- [ ] viのスワップファイル・リカバリ機構を確認
- [ ] vi/ex/viewのargv[0]による動作切替を確認
