---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：89-libpthread（スレッドライブラリ）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **thr_private.hのstruct pthread定義**：ヘッダファイルの直接確認が必要
  2. **umtxカーネル連携の詳細**：thr_umtx.cの実装確認

## 2) 参照した情報（Evidence一覧）

- E-01: `lib/libthr/thread/thr_init.c` - ライブラリ初期化（80行目まで読解）
- E-02: `lib/libthr/thread/thr_create.c` - スレッド生成（60行目まで読解）
- E-03: `lib/libthr/thread/thr_mutex.c` - ミューテックス実装（60行目まで読解）
- E-04: `lib/libthr/thread/` ディレクトリ一覧 - 60ファイル確認
- E-05: `lib/libthr/` ディレクトリ一覧 - Makefile/pthread.map/plockstat.d等
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | _thr_initialがメインスレッド | E-01 (thr_init.c:65行目) | ○ |
| C-02 | _thread_listはTAILQで管理 | E-01 (thr_init.c:69行目) | ○ |
| C-03 | _thread_gc_listが存在 | E-01 (thr_init.c:70行目) | ○ |
| C-04 | _thread_active_threads初期値1 | E-01 (thr_init.c:71行目) | ○ |
| C-05 | _thr_priorities[3]で3ポリシー | E-01 (thr_init.c:75-79行目) | ○ |
| C-06 | OTHERのデフォルト優先度63 | E-01 (thr_init.c:77行目) | ○ |
| C-07 | _pthread_createの弱参照 | E-02 (thr_create.c:55行目) | ○ |
| C-08 | __thr_new_flags = THR_C_RUNTIME | E-02 (thr_create.c:53行目) | ○ |
| C-09 | create_stack/thread_start関数宣言 | E-02 (thr_create.c:50-51行目) | ○ |
| C-10 | MUTEX_ADAPTIVE_SPINS = 2000 | E-03 (thr_mutex.c:60行目) | ○ |
| C-11 | pthread_mutexサイズ静的アサート | E-03 (thr_mutex.c:53-54行目) | ○ |
| C-12 | threadディレクトリに60ファイル | E-04 | ○ |
| C-13 | pthread.mapが存在 | E-05 | ○ |
| C-14 | plockstat.dが存在 | E-05 | ○ |
| C-15 | _thr_atfork_listが存在 | E-01 (thr_init.c:72行目) | ○ |
| C-16 | _usrstack変数が存在 | E-01 (thr_init.c:64行目) | ○ |
| C-17 | thr_private.hのstruct pthread詳細 | **根拠不足** | △ |
| C-18 | umtxカーネル連携の詳細仕様 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- thr_private.h内のstruct pthread定義の直接確認
  - 候補：lib/libthr/thread/thr_private.hの読解
- umtxシステムコールの詳細な操作モード
  - 候補：lib/libthr/thread/thr_umtx.c / sys/kern/kern_umtx.c

## 5) リスクフラグ（レビュー観点）
- 0: ライブラリ初期化とグローバル変数（ソースコードで確認済み）
- 0: スレッド生成の基本フロー（ソースコードで確認済み）
- 0: ミューテックスの適応的スピン（ソースコードで確認済み）
- 1: struct pthreadの完全な定義（ヘッダ未読解）
- 1: umtxの内部実装詳細（カーネル側未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] thr_private.hのstruct pthread定義を確認
- [ ] thr_umtx.cのumtx操作モードを確認
- [ ] thr_syscalls.cのキャンセルポイント実装を確認
- [ ] pthread.mapのシンボルバージョニングを確認
