---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：90-libc++（C++標準ライブラリ）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **__config_siteの具体的設定内容**：FreeBSD固有設定の確認が必要
  2. **libc++.ldscriptの内容**：リンカスクリプトの詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `lib/libc++/Makefile` - ビルド設定（全129行読解）
- E-02: `lib/libc++/` ディレクトリ一覧 - 6ファイル確認
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ソースはcontrib/llvm-project/libcxx/src/ | E-01 (Makefile:8行目 SRCDIR) | ○ |
| C-02 | ヘッダはcontrib/llvm-project/libcxx/include/ | E-01 (Makefile:7行目 HDRDIR) | ○ |
| C-03 | libcxxrtはcontrib/libcxxrt/ | E-01 (Makefile:6行目 _LIBCXXRTDIR) | ○ |
| C-04 | SHLIB_MAJOR=1 (libc++.so.1) | E-01 (Makefile:14行目) | ○ |
| C-05 | CXXSTD=c++23がデフォルト | E-01 (Makefile:114行目) | ○ |
| C-06 | gcc 12ではc++20にフォールバック | E-01 (Makefile:108-115行目) | ○ |
| C-07 | SRCSに55+ファイル（17-72行目） | E-01 | ○ |
| C-08 | CXXRT_SRCSに9ファイル（74-82行目） | E-01 | ○ |
| C-09 | -fvisibility=hidden設定 | E-01 (Makefile:106行目) | ○ |
| C-10 | -D_LIBCPP_BUILDING_LIBRARY定義 | E-01 (Makefile:98行目) | ○ |
| C-11 | -DLIBCXXRT定義 | E-01 (Makefile:101行目) | ○ |
| C-12 | filesystem/サブディレクトリのファイル群 | E-01 (Makefile:30-36行目) | ○ |
| C-13 | ryu/サブディレクトリのファイル群 | E-01 (Makefile:59-61行目) | ○ |
| C-14 | LIBADD+=cxxrt（libcxxrt依存） | E-01 (Makefile:117行目) | ○ |
| C-15 | __config_siteの具体的設定内容 | **根拠不足** | △ |
| C-16 | libc++.ldscriptの詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- __config_siteのFreeBSD固有設定値
  - 候補：lib/libc++/__config_site の直接読解
- libc++.ldscriptの内容（GROUP/INPUTディレクティブ等）
  - 候補：lib/libc++/libc++.ldscript の直接読解

## 5) リスクフラグ（レビュー観点）
- 0: ビルド構成とソースファイル一覧（Makefileから確認済み）
- 0: libcxxrt連携構成（Makefileから確認済み）
- 0: C++標準バージョンとフォールバック（Makefileから確認済み）
- 1: FreeBSD固有設定（__config_site未読解）
- 0: ビルドフラグ（Makefileから確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] __config_siteのFreeBSD固有設定を確認
- [ ] libc++.ldscriptの内容を確認
- [ ] contrib/llvm-project/libcxx/のバージョンを確認
- [ ] contrib/libcxxrt/のバージョン・構成を確認
