---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：91-libfetch

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **HTTP Keep-Alive非対応の主張**：実装詳細の確認が必要
  2. **fetchコマンドとの関連性**：usr.bin/fetchの実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `lib/libfetch/fetch.h` - 公開ヘッダ（struct url定義、API宣言、エラーコード）
- E-02: `lib/libfetch/fetch.c` - 汎用API実装、URLパーサー
- E-03: `lib/libfetch/common.h` - 内部ヘッダ（struct fetchconn、SOCKS5定数）
- E-04: `lib/libfetch/common.c` - 共通ネットワーク処理
- E-05: `lib/libfetch/http.c` - HTTP/HTTPS実装
- E-06: `lib/libfetch/ftp.c` - FTP実装
- E-07: `lib/libfetch/file.c` - ローカルファイルアクセス実装
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | libfetchはHTTP/HTTPS/FTP/fileプロトコルに対応 | E-01 (64-68行目: SCHEME_*定義), E-02 (83-90行目: スキーム判定) | ○ |
| C-02 | struct urlはscheme, user, pwd, host, port, doc, offset, length, ims_time, netrcfdを持つ | E-01 (40-51行目) | ○ |
| C-03 | エラーコードはFETCH_ABORT(1)からFETCH_VERBOSE(19)まで定義 | E-01 (71-89行目) | ○ |
| C-04 | MAX_REDIRECTは20回 | E-05 (98行目) | ○ |
| C-05 | FTPデフォルトポートは21、HTTPは80、プロキシは3128 | E-03 (34-37行目) | ○ |
| C-06 | 匿名FTPユーザ名は"anonymous" | E-06 (80行目: FTP_ANONYMOUS_USER) | ○ |
| C-07 | fetchParseURLはURLをコンポーネントに分解する | E-02 (347-483行目) | ○ |
| C-08 | struct fetchconnはsd, buf, bufsize, buflen, err, ssl関連, refを持つ | E-03 (49-62行目) | ○ |
| C-09 | SOCKS5プロキシ対応 | E-03 (79-101行目: SOCKS5定数), E-04 (fetch_socks5_init関数) | ○ |
| C-10 | SSL/TLS対応はWITH_SSLコンパイルオプションで制御 | E-03 (39-45行目: #ifdef WITH_SSL) | ○ |
| C-11 | fetchXGetFileはfopenとfseeko を使用 | E-07 (42-64行目) | ○ |
| C-12 | fetchPutFileは'a'フラグで追記モード | E-07 (72-94行目: CHECK_FLAG('a')) | ○ |
| C-13 | fetchListFileはopendir/readdirでディレクトリ列挙 | E-07 (119-153行目) | ○ |
| C-14 | URL各フィールドの長さ制限: scheme=16, user=256, pwd=256 | E-01 (36-38行目) | ○ |
| C-15 | バージョン文字列は"libfetch/2.0" | E-01 (34行目) | ○ |
| C-16 | .netrcファイルによる認証サポート | E-03 (131行目: fetch_netrc_auth宣言) | ○ |
| C-17 | fetchRestartCallsのデフォルトは1（有効） | E-02 (48行目) | ○ |
| C-18 | パーセントデコードで%00は拒否 | E-02 (324行目: d1 > 0 || d2 > 0 条件) | ○ |
| C-19 | HTTP/HTTPSのURLフラグメント(#)は除去 | E-02 (453行目: *p != '#' 条件) | ○ |
| C-20 | 関連画面: ミラーサイト選択(13), カスタムURL(14), ダウンロード(18) | E-08 | ○ |
| C-21 | fetchTimeoutのデフォルトは0 | E-02 (47行目: fetchTimeout宣言、初期化子なし=0) | ○ |
| C-22 | HTTP Keep-Aliveには非対応 | **根拠なし** | △ |
| C-23 | fetch_pctdecodeは@と:で区切りを判定 | E-02 (322行目) | ○ |
| C-24 | fetchコマンド(usr.bin/fetch)がlibfetchの主要利用者 | **根拠なし** | △ |
| C-25 | RFC 9110準拠でフラグメント除去 | E-02 (451-452行目: コメントにRFC 9110参照あり) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-22: HTTP Keep-Alive非対応の主張は、http.cの実装を全行読み込んで確認する必要がある。接続再利用コードの有無を確認すべき。
  - 候補：http.c全文精読 / fetchコマンドの利用パターン確認
- C-24: fetchコマンドとlibfetchの関係は、usr.bin/fetch/のソースコードを確認することで裏付け可能。
  - 候補：usr.bin/fetch/fetch.c / Makefile.depend

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 公開API仕様（fetch.h由来の情報は高信頼）
- 0: 低リスク - データ構造定義（ソースコードから直接抽出）
- 1: 中リスク - HTTP実装詳細（2148行の大規模ファイルのため全容把握が限定的）
- 0: 低リスク - エラーコード一覧（fetch.hから直接抽出）

## 6) レビュアーチェックリスト（最小）
- [ ] http.cのHTTP Keep-Alive対応状況を確認
- [ ] usr.bin/fetch/がlibfetchを使用しているか確認
- [ ] SSL証明書検証の詳細（fetch_ssl_cb_verify_crt）が適切に記述されているか確認
- [ ] SOCKS5プロキシの認証方式の詳細が不足していないか確認
