---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 17
  claims_without_evidence: 3
confidence_derived: 0.85
---

# 根拠レポート：92-libarchive

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：17 / 20、根拠なし：3
- 優先レビュー（高）
  1. **ARCHIVE_EXTRACT_*フラグの詳細**：セキュリティ関連フラグの正確な名称確認が必要
  2. **対応アーカイブ形式の網羅性**：全対応形式のリストアップが不完全の可能性
  3. **パフォーマンス特性**：ストリーミングAPIのメモリ使用量に関する詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `contrib/libarchive/libarchive/archive.h` - 公開ヘッダ
- E-02: `lib/libarchive/config_freebsd.h` - FreeBSD設定
- E-03: `lib/libarchive/Makefile` - ビルド設定
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | libarchiveはtar, zip, cpio, ISO 9660, 7-Zip等に対応 | E-01 (フォーマットサポートAPI宣言) | ○ |
| C-02 | バージョン3.8.5（ARCHIVE_VERSION_NUMBER = 3008005） | E-01 (38行目) | ○ |
| C-03 | バージョン文字列は"libarchive 3.8.5" | E-01 (ARCHIVE_VERSION_ONLY_STRING) | ○ |
| C-04 | エラーコード: OK=0, EOF=1, RETRY=-10, WARN=-20, FAILED=-25, FATAL=-30 | E-01 | ○ |
| C-05 | ストリーミングAPIで大容量対応 | E-01 (API設計から推定) | ○ |
| C-06 | gzip, bzip2, xz, lz4, zstd圧縮対応 | E-01 (archive_*_filter_*宣言) | ○ |
| C-07 | 関連画面: 配布ファイル展開画面(20) | E-04 | ○ |
| C-08 | archive_zlib_version, archive_liblzma_version等の依存ライブラリ確認API | E-01 | ○ |
| C-09 | __LA_DECLはFreeBSD環境では空文字列 | E-01 (140行目付近: #define __LA_DECL) | ○ |
| C-10 | la_int64_tはint64_tのtypedef | E-01 (75行目付近) | ○ |
| C-11 | マジック値による検証を行う | E-01 (archive_check_magic.cの存在) | ○ |
| C-12 | contrib/libarchive/以下にアップストリームソースが配置 | E-01 (ファイルパス) | ○ |
| C-13 | クロスプラットフォームライブラリ | E-01 (Windows対応コード) | ○ |
| C-14 | FreeBSD固有設定はconfig_freebsd.hで管理 | E-02 | ○ |
| C-15 | パストラバーサル攻撃対策あり | **根拠なし** | △ |
| C-16 | ARCHIVE_EXTRACT_SECURE_SYMLINKSフラグの存在 | **根拠なし** | △ |
| C-17 | ARCHIVE_EXTRACT_OWNERフラグの存在 | **根拠なし** | △ |
| C-18 | バージョン番号算出式: printf("%d%03d%03d", major, minor, patch) | E-01 (32-36行目コメント) | ○ |
| C-19 | bsdinstallで配布ファイル展開に使用 | E-04, E-05 | ○ |
| C-20 | ACL・拡張属性のサポート | E-01 (archive_entry_acl関連ファイルの存在) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-15, C-16, C-17: セキュリティ関連フラグの正確な名称と動作はarchive.hの該当定数定義を全文確認する必要がある
  - 候補: archive.h全文精読 / archive_write_disk_set_options()のドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バージョン情報、基本API構造
- 1: 中リスク - セキュリティフラグの正確な名称（archive.h全文未確認）
- 1: 中リスク - 対応フォーマットの完全リスト（contrib配下の全ファイル未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] archive.hのARCHIVE_EXTRACT_*フラグ一覧を確認
- [ ] 対応アーカイブ形式の完全リストを確認
- [ ] archive_write_disk関連のセキュリティ機能を確認
