---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：93-libedit

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **デフォルトエディタモードがEmacsである主張**：el.cの初期化コード確認が必要
  2. **/bin/shがlibeditを使用している主張**：bin/sh/Makefileの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `contrib/libedit/histedit.h` - 公開ヘッダ
- E-02: `contrib/libedit/el.c` - コアAPI実装
- E-03: `contrib/libedit/el.h` - 内部ヘッダ
- E-04: `contrib/libedit/read.c` - 入力処理
- E-05: `contrib/libedit/readline.c` - readline互換レイヤ
- E-06: `contrib/libedit/filecomplete.c` - ファイル名補完

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EditLine型はstruct editlineのtypedef | E-01 (57行目) | ○ |
| C-02 | LineInfoはbuffer, cursor, lastcharの3フィールド | E-01 (62-66行目) | ○ |
| C-03 | CC_NORM(0)からCC_REFRESH_BEEP(9)の返り値定義 | E-01 (72-81行目) | ○ |
| C-04 | el_init, el_end, el_reset, el_gets, el_getc, el_push APIの存在 | E-01 (86-97行目) | ○ |
| C-05 | el_set/el_getでEL_PROMPT(0)からEL_CLIENTDATA(14)のパラメータ | E-01 (135-150行目) | ○ |
| C-06 | LIBEDIT_MAJOR=2, LIBEDIT_MINOR=11 | E-01 (43-44行目) | ○ |
| C-07 | NetBSD由来のライブラリ | E-01 (1行目: $NetBSD$タグ) | ○ |
| C-08 | Emacsモードがデフォルト | **根拠なし** | △ |
| C-09 | GNU readline互換レイヤを提供 | E-05 (ファイル存在) | ○ |
| C-10 | ファイル名補完機能あり | E-06 (ファイル存在) | ○ |
| C-11 | _el_fn_complete, _el_fn_sh_complete関数の存在 | E-01 (115-116行目) | ○ |
| C-12 | EL_HIST(10)でヒストリ連携設定 | E-01 (146行目) | ○ |
| C-13 | EL_SIGNAL(3)でシグナル処理設定 | E-01 (138行目) | ○ |
| C-14 | EL_ADDFN(9)でユーザ定義関数登録 | E-01 (144行目) | ○ |
| C-15 | Viモードサポート | E-01 (EL_EDITOR設定の存在, 137行目) | ○ |
| C-16 | /bin/shがlibeditを使用 | **根拠なし** | △ |
| C-17 | wchar_t対応（el_wgets等） | E-01 (eln.c, historyn.cの存在) | ○ |
| C-18 | .editrcファイルからの設定読み込み | E-01 (el_source関連), parse.cの存在 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-08: デフォルトエディタモードの確認にはel.cの初期化コードの精読が必要
  - 候補: el.c / map.c のデフォルト設定箇所
- C-16: /bin/shのlibedit利用はbin/sh/MakefileまたはLDFLAGS確認で裏付け可能
  - 候補: bin/sh/Makefile / bin/sh/Makefile.depend

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 公開API仕様（histedit.hから直接抽出）
- 0: 低リスク - データ構造定義
- 1: 中リスク - デフォルト動作に関する主張

## 6) レビュアーチェックリスト（最小）
- [ ] el.cのel_init()でデフォルトエディタモードがEmacsか確認
- [ ] bin/sh/がlibeditにリンクしているか確認
- [ ] History APIの全操作コマンドが網羅されているか確認
