---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：95-libalias

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **NAT変換テーブルのタイムアウト動作**：alias_local.hの実装確認が必要
  2. **ALGモジュール一覧の網羅性**：modulesディレクトリの全モジュール確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/netinet/libalias/alias.h` - 公開ヘッダ
- E-02: `sys/netinet/libalias/alias_local.h` - 内部ヘッダ（ファイル存在確認）
- E-03: `sys/netinet/libalias/alias_db.h` - テーブル管理ヘッダ（ファイル存在確認）
- E-04: `sys/netinet/libalias/alias_mod.h` - モジュール管理ヘッダ（ファイル存在確認）
- E-05: `lib/libalias/libalias/libalias.conf` - ALGモジュール設定（ファイル存在確認）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | struct libalias/struct alias_linkは不透明型 | E-01 (74行目, 82行目) | ○ |
| C-02 | LibAliasInit/Uninit APIの存在 | E-01 (85行目, 91行目) | ○ |
| C-03 | LibAliasIn/Out/OutTry APIの存在 | E-01 (94-96行目) | ○ |
| C-04 | LibAliasRedirectPort/Addr/Proto APIの存在 | E-01 (99-113行目) | ○ |
| C-05 | LibAliasAddServer APIの存在 | E-01 (101-102行目) | ○ |
| C-06 | LibAliasSetAddress APIの存在 | E-01 (86行目) | ○ |
| C-07 | LibAliasSetMode APIの存在 | E-01 (90行目) | ○ |
| C-08 | LIBALIAS_BUF_SIZE = 128 | E-01 (46行目) | ○ |
| C-09 | _KERNEL定義時にNO_FW_PUNCH, NO_USE_SOCKETSが定義 | E-01 (47-53行目) | ○ |
| C-10 | フラグメント処理API: LibAliasFragmentIn, GetFragment, SaveFragment | E-01 (116-118行目) | ○ |
| C-11 | LibAliasSetAliasPortRange APIの存在 | E-01 (87行目) | ○ |
| C-12 | LibAliasRedirectDynamic APIの存在 | E-01 (105行目) | ○ |
| C-13 | LibAliasRedirectDelete APIの存在 | E-01 (106行目) | ○ |
| C-14 | LibAliasSetFWBase APIの存在 | E-01 (88行目) | ○ |
| C-15 | LibAliasSetSkinnyPort APIの存在 | E-01 (89行目) | ○ |
| C-16 | LibAliasUnaliasOut APIの存在 | E-01 (97行目) | ○ |
| C-17 | NAT変換テーブルのタイムアウト自動削除 | **根拠なし** | △ |
| C-18 | FTP/IRC/PPTP等のALGサポート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17: NAT変換テーブルのタイムアウト処理はalias_local.hやalias_db実装の確認が必要
  - 候補: sys/netinet/libalias/alias_db.c
- C-18: ALGモジュールの詳細はlib/libalias/modules/やsys/netinet/libalias/alias_ftp.c等を確認
  - 候補: lib/libalias/modules/ ディレクトリ内容

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 公開API仕様（alias.hから直接確認）
- 1: 中リスク - 内部動作の詳細（alias_local.h/alias_db未詳細確認）
- 1: 中リスク - ALGモジュールの網羅性

## 6) レビュアーチェックリスト（最小）
- [ ] alias_local.hの内部構造体定義を確認
- [ ] NAT変換テーブルのタイムアウト値と動作を確認
- [ ] ALGモジュールの完全リストを確認
- [ ] PKT_ALIAS_*返り値定数の定義箇所を確認
