---
generated_at: 2026-02-01 10:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：96-DHCPクライアント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **指数バックオフの詳細**：再送アルゴリズムの具体的なパラメータ確認
  2. **dhclient-scriptの全処理内容**：スクリプト内容の完全確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/dhclient/dhcp.h` - DHCPプロトコル定義
- E-02: `sbin/dhclient/dhcpd.h` - 内部構造体
- E-03: `sbin/dhclient/dhclient.c` - メインプログラム
- E-04: `sbin/dhclient/privsep.h` - 権限分離
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | struct dhcp_packetはop,htype,hlen,hops,xid等を持つ | E-01 (59-77行目) | ○ |
| C-02 | DHCP_UDP_OVERHEAD = 14+20+8 = 42 | E-01 (45-47行目) | ○ |
| C-03 | DHCP_SNAME_LEN=64, DHCP_FILE_LEN=128 | E-01 (48-49行目) | ○ |
| C-04 | BOOTP_MIN_LEN=300, DHCP_MIN_LEN=548 | E-01 (56-57行目) | ○ |
| C-05 | DHCP_MTU_MAX=1500 | E-01 (53行目) | ○ |
| C-06 | DHCPマジッククッキー: \143\202\123\143 | E-01 (93行目) | ○ |
| C-07 | LOCAL_PORT=68, REMOTE_PORT=67 | E-02 (82-83行目) | ○ |
| C-08 | struct option_dataはlen, dataを持つ | E-02 (85-88行目) | ○ |
| C-09 | struct iaddrはlen, iabuf[16]を持つ | E-02 (95-98行目) | ○ |
| C-10 | default_lease_time = 43200（12時間） | E-03 (95行目) | ○ |
| C-11 | Capsicum統合（sys/capsicum.h, capsicum_helpers.h） | E-03 (62-65行目) | ○ |
| C-12 | Casper cap_syslog統合 | E-02 (77行目: casper/cap_syslog.h) | ○ |
| C-13 | OpenBSD由来 | E-03 (1行目: $OpenBSD$タグ) | ○ |
| C-14 | CLIENT_PATH = "PATH=/usr/bin:/usr/sbin:/bin:/sbin" | E-03 (89行目) | ○ |
| C-15 | _PATH_VAREMPTY = "/var/empty" | E-03 (72行目) | ○ |
| C-16 | ホスト名検証マクロ（borderchar, middlechar, domainchar） | E-03 (80-87行目) | ○ |
| C-17 | net80211統合（ieee80211_freebsd.h） | E-03 (68行目) | ○ |
| C-18 | cap_channel_t *capsyslog グローバル変数 | E-03 (91行目) | ○ |
| C-19 | log_perror = 1（デフォルト） | E-03 (100行目) | ○ |
| C-20 | 関連画面: IPv4設定確認画面(8) | E-05 | ○ |
| C-21 | 指数バックオフ再送 | **根拠なし** | △ |
| C-22 | T1=リース期間の1/2, T2=7/8 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-21: 指数バックオフの詳細パラメータはdhclient.cのsend_discover/send_request関数内の確認が必要
  - 候補: dhclient.c全文精読
- C-22: T1/T2タイマーの計算はRFC 2131準拠だが、dhclient.c内の具体的な実装確認が必要
  - 候補: dhclient.c内のstate_bound/state_renewing関数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プロトコル構造体定義（ソースから直接確認）
- 0: 低リスク - 定数値・ポート番号
- 1: 中リスク - DHCPステートマシンの遷移詳細
- 0: 低リスク - セキュリティ機能（Capsicum/Casper統合）

## 6) レビュアーチェックリスト（最小）
- [ ] DHCPステートマシンの遷移条件を詳細確認
- [ ] 指数バックオフの具体的パラメータを確認
- [ ] dhclient-scriptの全処理内容を確認
- [ ] リースファイルの形式を確認
