---
generated_at: 2026-02-01 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：97-DNS解決

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **排他的DNS設定の動作詳細**：resolvconf.inの完全読解が必要
  2. **RESTARTCMD実行の詳細**：サービス再起動の具体的な実装確認

## 2) 参照した情報（Evidence一覧）

- E-01: `contrib/openresolv/resolvconf.in` - メインスクリプト
- E-02: `contrib/openresolv/resolvconf.conf` - 設定ファイル
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OPENRESOLV_VERSION="3.9.2" | E-01 (28行目) | ○ |
| C-02 | local_nameservers = "127.* 0.0.0.0 255.255.255.255 ::1" | E-01 (45行目) | ○ |
| C-03 | dynamic_order = "tap[0-9]* tun[0-9]* vpn ..." | E-01 (47行目) | ○ |
| C-04 | interface_order = "lo lo[0-9]*" | E-01 (48行目) | ○ |
| C-05 | name_server_blacklist = "0.0.0.0" | E-01 (49行目) | ○ |
| C-06 | resolvconf.confから設定を読み込む | E-01 (53-55行目) | ○ |
| C-07 | IFACEDIR, METRICDIR, PRIVATEDIR, EXCLUSIVEDIR, LOCKDIRの変数定義 | E-01 (62-67行目) | ○ |
| C-08 | -a, -d, -u, -l, -iコマンドのサポート | E-01 (82-99行目: usage) | ○ |
| C-09 | --versionオプションのサポート | E-01 (35-39行目) | ○ |
| C-10 | openresolvプロジェクト由来 | E-01 (28行目: OPENRESOLV_VERSION) | ○ |
| C-11 | contrib/openresolv/以下にソース配置 | E-01 (ファイルパス) | ○ |
| C-12 | @SYSCONFDIR@等のプレースホルダ | E-01 (29-33行目) | ○ |
| C-13 | 関連画面: DNS設定画面(12) | E-03 | ○ |
| C-14 | warn/error_exit関数の定義 | E-01 (69-78行目) | ○ |
| C-15 | 排他的DNS設定（-xフラグ）の動作 | **根拠なし** | △ |
| C-16 | RESTARTCMD実行の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: -xフラグの動作詳細はresolvconf.inの後半部分（コマンド処理ロジック）の確認が必要
  - 候補: resolvconf.in全文精読
- C-16: RESTARTCMD変数の設定とサービス再起動の実装詳細
  - 候補: resolvconf.conf / resolvconf.in内のRESRATCMD参照箇所

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バージョン情報、変数定義（ソースから直接確認）
- 0: 低リスク - コマンドオプション（usage関数から確認）
- 1: 中リスク - DNS統合ロジックの詳細
- 1: 中リスク - プライベート/排他的設定の動作

## 6) レビュアーチェックリスト（最小）
- [ ] resolvconf.inの-a/-d/-uコマンド処理部分を全文確認
- [ ] 排他的DNS設定（-xフラグ）の動作を確認
- [ ] RESTARTCMD変数の設定方法と実行タイミングを確認
- [ ] FreeBSD固有のパス設定(@置換)を確認
