---
generated_at: 2026-02-01 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 14
  claims_without_evidence: 4
confidence_derived: 0.78
---

# 根拠レポート：98-NTPデーモン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.78**
  - 根拠あり：14 / 18、根拠なし：4
- 優先レビュー（高）
  1. **ステップ/スルー閾値（128ms）の正確性**：ntpd.cの定数確認が必要
  2. **パニック閾値（1000秒）の正確性**：ntpd.cの定数確認が必要
  3. **ポーリング間隔の範囲（64-1024秒）**：ntp.hの定数確認が必要
  4. **NTPオフセット計算式の正確性**：プロトコル処理コードの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `contrib/ntp/ntpd/ntpd.c` - メインプログラム（存在確認、1898行）
- E-02: `contrib/ntp/ntpd/ntp_config.c` - 設定ファイル解析（存在確認）
- E-03: `contrib/ntp/ntpd/ntp_control.c` - 制御メッセージ（存在確認）
- E-04: `contrib/ntp/ntpd/ntp_clockdev.c` - クロックデバイス（存在確認）
- E-05: `contrib/ntp/ntpd/ntp_crypto.c` - 暗号処理（存在確認）
- E-06: `usr.sbin/ntpd/config.h` - FreeBSD設定（存在確認）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ntpdはRFC 5905のNTPv4を実装 | E-01 (NTP Reference Implementation) | ○ |
| C-02 | contrib/ntp/以下にソース配置 | E-01 (ファイルパス) | ○ |
| C-03 | ntpd.cは1898行 | E-01 (wc -l確認) | ○ |
| C-04 | ntp_config.c, ntp_control.c等の存在 | E-02, E-03 (ファイル存在確認) | ○ |
| C-05 | ntp_clockdev.c, ntp_crypto.cの存在 | E-04, E-05 (ファイル存在確認) | ○ |
| C-06 | usr.sbin/ntpd/config.hの存在 | E-06 (ファイル存在確認) | ○ |
| C-07 | 関連画面: サービス選択画面(25) | E-07 | ○ |
| C-08 | sntpコマンドの存在 | contrib/ntp/sntp/ディレクトリ存在 | ○ |
| C-09 | ntpq/ntpdcの存在 | contrib/ntp/ntpq/, ntpdc/ディレクトリ存在 | ○ |
| C-10 | ntpdateの存在 | contrib/ntp/ntpdate/ディレクトリ存在 | ○ |
| C-11 | keyword-gen.cの存在 | E-01関連ディレクトリ | ○ |
| C-12 | NTPポート123 | NTP標準（RFC 5905） | ○ |
| C-13 | l_fp型（64bit固定小数点）の使用 | NTP標準仕様に基づく推定 | ○ |
| C-14 | NTPエポックは1900年1月1日 | NTP標準仕様に基づく推定 | ○ |
| C-15 | ステップ/スルー閾値が128ms | **根拠なし** | △ |
| C-16 | パニック閾値が1000秒 | **根拠なし** | △ |
| C-17 | ポーリング間隔が64-1024秒 | **根拠なし** | △ |
| C-18 | NTPオフセット計算式 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15, C-16: 閾値はntpd.cまたはntp.hの定数定義を確認する必要がある
  - 候補: contrib/ntp/include/ntp.h / ntpd.c内の定数定義
- C-17: ポーリング間隔の範囲はntp.hのMINPOLL/MAXPOLL定数を確認する必要がある
  - 候補: contrib/ntp/include/ntp.h
- C-18: NTPオフセット計算式はRFC 5905に基づく標準的な計算であるが、実装コードでの確認が必要
  - 候補: contrib/ntp/ntpd/ 内のプロトコル処理コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイル存在・ディレクトリ構造
- 2: 高リスク - NTPアルゴリズムの閾値・パラメータ（ソースコード未精読）
- 1: 中リスク - NTP認証の詳細
- 0: 低リスク - 関連画面情報

## 6) レビュアーチェックリスト（最小）
- [ ] ntp.hのステップ/スルー閾値定数を確認
- [ ] パニック閾値の定数を確認
- [ ] MINPOLL/MAXPOLL定数を確認
- [ ] NTPオフセット計算の実装コードを確認
- [ ] NTP認証方式の詳細を確認
