---
generated_at: 2026-02-01 00:00:00
metrics:
  claims_total: 33
  claims_with_evidence: 31
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：画面一覧.csv / 画面遷移図.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：31 / 33、根拠なし：2
- 優先レビュー（高）
  1. **C-19 チェックサム検証画面**：スクリプトの内容を詳細確認できていない（bsddialog呼び出しの有無）
  2. **C-16 ZFSブート設定画面**：スクリプトが非常に長く先頭80行のみ確認。全画面要素の網羅性に不安
  3. **C-22 タイムゾーン選択画面**：tzsetup外部コマンドの画面構成は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `usr.sbin/bsdinstall/scripts/auto` - メインインストールフロースクリプト
- E-02: `usr.sbin/bsdinstall/bsdinstall` - bsdinstallメインエントリポイント
- E-03: `usr.sbin/bsdinstall/scripts/keymap` - キーマップ選択スクリプト
- E-04: `usr.sbin/bsdinstall/scripts/hostname` - ホスト名設定スクリプト
- E-05: `usr.sbin/bsdinstall/scripts/netconfig` - ネットワーク設定スクリプト
- E-06: `usr.sbin/bsdinstall/scripts/netconfig_ipv4` - IPv4設定スクリプト
- E-07: `usr.sbin/bsdinstall/scripts/netconfig_ipv6` - IPv6設定スクリプト
- E-08: `usr.sbin/bsdinstall/scripts/wlanconfig` - 無線LAN設定スクリプト
- E-09: `usr.sbin/bsdinstall/scripts/mirrorselect` - ミラー選択スクリプト
- E-10: `usr.sbin/bsdinstall/scripts/rootpass` - rootパスワード設定スクリプト
- E-11: `usr.sbin/bsdinstall/scripts/time` - 日時設定スクリプト
- E-12: `usr.sbin/bsdinstall/scripts/services` - サービス選択スクリプト
- E-13: `usr.sbin/bsdinstall/scripts/hardening` - セキュリティ強化スクリプト
- E-14: `usr.sbin/bsdinstall/scripts/adduser` - ユーザ追加スクリプト
- E-15: `usr.sbin/bsdinstall/scripts/finalconfig` - 最終設定メニュースクリプト
- E-16: `usr.sbin/bsdinstall/scripts/zfsboot` - ZFSブート設定スクリプト（先頭80行）
- E-17: `usr.sbin/bsdinstall/scripts/firmware` - ファームウェアインストールスクリプト
- E-18: `usr.sbin/bsdinstall/scripts/docsinstall` - ドキュメントインストールスクリプト
- E-19: `usr.sbin/bsdinstall/distextract/distextract.c` - 配布ファイル展開プログラム（先頭60行）
- E-20: `usr.sbin/bsdinstall/distfetch/distfetch.c` - 配布ファイルダウンロードプログラム（先頭60行）
- E-21: `usr.sbin/bsdinstall/partedit/partedit.c` - パーティション編集プログラム（先頭60行）
- E-22: `usr.sbin/bsdinstall/scripts/checksum` - チェックサム検証スクリプト（ファイル存在確認のみ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | キーマップ選択画面がインストール最初のステップ | E-01, E-03 | ○ |
| C-02 | ホスト名設定画面 | E-01, E-04 | ○ |
| C-03 | インストール種別選択画面（Distribution Sets/Packages） | E-01 | ○ |
| C-04 | ネットワーク/オフラインインストール選択画面 | E-01 | ○ |
| C-05 | 配布セット選択画面（チェックリスト） | E-01 | ○ |
| C-06 | ネットワークインターフェース選択画面 | E-05 | ○ |
| C-07 | 無線LAN設定画面（WPA-PSK/EAP/WEP/Open対応） | E-08 | ○ |
| C-08 | IPv4設定確認画面 | E-06 | ○ |
| C-09 | IPv4スタティック設定画面（IP/Mask/Router） | E-06 | ○ |
| C-10 | IPv6設定確認画面 | E-07 | ○ |
| C-11 | IPv6スタティック設定画面 | E-07 | ○ |
| C-12 | DNS設定画面（mixedform） | E-05 | ○ |
| C-13 | ミラーサイト選択画面 | E-09 | ○ |
| C-14 | カスタムミラーURL入力画面 | E-09 | ○ |
| C-15 | パーティションモード選択画面（ZFS/UFS/Manual/Shell） | E-01 | ○ |
| C-16 | ZFSブート設定画面 | E-16 | ○ |
| C-17 | 手動パーティション編集画面 | E-21 | ○ |
| C-18 | 配布ファイルダウンロード画面（プログレスバー付き） | E-20 | ○ |
| C-19 | チェックサム検証画面 | E-22 | △ |
| C-20 | 配布ファイル展開画面（プログレスバー付き） | E-19 | ○ |
| C-21 | rootパスワード設定画面（パスワード確認付き） | E-10 | ○ |
| C-22 | タイムゾーン選択画面（tzsetup使用） | E-11 | △ |
| C-23 | 日付設定画面（カレンダーUI） | E-11 | ○ |
| C-24 | 時刻設定画面（タイムボックスUI） | E-11 | ○ |
| C-25 | サービス選択画面（チェックリスト） | E-12 | ○ |
| C-26 | セキュリティ強化設定画面（チェックリスト） | E-13 | ○ |
| C-27 | ファームウェアインストール画面 | E-17 | ○ |
| C-28 | ユーザ追加確認画面（Yes/No） | E-01 | ○ |
| C-29 | ユーザ追加画面（adduser CLI） | E-14 | ○ |
| C-30 | 最終設定メニュー画面（10項目） | E-15 | ○ |
| C-31 | ドキュメントインストール画面 | E-18 | ○ |
| C-32 | 手動設定確認画面（chroot shell） | E-01 | ○ |
| C-33 | インストール中断エラー画面 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-19: `scripts/checksum`スクリプトの中身を詳細に読んでいないため、bsddialogベースのUIがあるかどうか不明。ファイルの存在は確認済みだが、画面表示内容の詳細は未検証。
  - 候補：`usr.sbin/bsdinstall/scripts/checksum` の全文読み込み
- C-22: `tzsetup`は外部コマンド（`usr.sbin/tzsetup`）であり、bsdinstallのスクリプトからchroot経由で呼び出されている。tzsetup自体のTUI画面構成はbsdinstallコードベース外であるため、詳細な画面説明の根拠が不足。
  - 候補：`usr.sbin/tzsetup/tzsetup.c` の確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本プロジェクトはOS（FreeBSD）のソースコードであり、「画面」はbsdinstallインストーラのTUI（テキストベースUI）画面に限定される。Webアプリケーションのような画面は存在しない。
- 0: 低リスク - 各画面の根拠はソースコード（シェルスクリプトおよびC言語ソース）から直接確認しており、推測は最小限。
- 1: 中リスク - ZFSブート設定画面（zfsboot）は700行以上の大規模スクリプトであり、先頭80行のみ確認。複数のサブ画面が存在する可能性がある。
- 1: 中リスク - bsdconfigユーティリティ（usr.sbin/bsdconfig）にもTUI画面が多数存在するが、bsdinstallとは独立したツールであるため本一覧からは除外している。スコープの判断がレビュー対象。

## 6) レビュアーチェックリスト（最小）
- [ ] bsdinstallインストーラのTUI画面を「画面」とする定義が妥当か確認
- [ ] bsdconfig（別のTUIシステム設定ツール）を画面一覧に含めるべきか判断
- [ ] ZFSブート設定画面（zfsboot）の全スクリプトを確認し、サブ画面の漏れがないか検証
- [ ] checksum スクリプトの画面表示内容を確認
- [ ] tzsetup の画面構成を確認し、タイムゾーン選択画面の説明が正確か検証
- [ ] 画面遷移図がautoスクリプトの条件分岐と一致しているか確認
- [ ] BSDINSTALL_SKIP_* 環境変数による画面スキップ条件が備考欄に正しく記載されているか確認
