# 画面遷移図

本ドキュメントは、FreeBSD bsdinstall インストーラの画面遷移を mermaid 形式で記述したものである。

## メインインストールフロー

```mermaid
flowchart TD
    START([bsdinstall 起動]) --> KEYMAP[キーマップ選択画面]
    KEYMAP --> HOSTNAME[ホスト名設定画面]
    HOSTNAME --> INSTALLTYPE{インストール種別選択画面}

    INSTALLTYPE -->|Distribution Sets| DISTSELECT[配布セット選択画面]
    INSTALLTYPE -->|Packages pkgbase| PKGBASE_CHECK{ローカルパッケージ有無}

    PKGBASE_CHECK -->|あり| NET_OR_OFFLINE[ネットワーク/オフライン選択画面]
    PKGBASE_CHECK -->|なし| NETCONFIG_MSG[ネットワークインストール案内]

    NET_OR_OFFLINE -->|Network| NETCONFIG1[ネットワーク設定]
    NET_OR_OFFLINE -->|Offline| PARTMODE[パーティションモード選択画面]
    NETCONFIG_MSG --> NETCONFIG1
    NETCONFIG1 --> PARTMODE

    DISTSELECT --> FETCH_CHECK{未取得配布ファイル有無}
    FETCH_CHECK -->|あり| NETCONFIG_DIST[ネットワーク設定]
    FETCH_CHECK -->|なし| PARTMODE
    NETCONFIG_DIST --> PARTMODE

    PARTMODE --> |Auto ZFS| ZFSBOOT[ZFSブート設定画面]
    PARTMODE --> |Auto UFS| AUTOPART[UFS自動パーティション]
    PARTMODE --> |Manual| PARTEDIT[手動パーティション編集画面]
    PARTMODE --> |Shell| SHELL_PART[シェル パーティション手動設定]

    ZFSBOOT --> MOUNT[マウント処理]
    AUTOPART --> MOUNT
    PARTEDIT --> MOUNT
    SHELL_PART --> MOUNT_AUX[補助ファイルシステムマウント]

    MOUNT --> INSTALL_EXEC
    MOUNT_AUX --> INSTALL_EXEC

    subgraph INSTALL_EXEC[インストール実行]
        direction TD
        DISTFETCH[配布ファイルダウンロード画面] --> CHECKSUM[チェックサム検証画面]
        CHECKSUM --> DISTEXTRACT[配布ファイル展開画面]
    end

    INSTALL_EXEC --> BOOTCONFIG[ブートローダ設定]
    BOOTCONFIG --> ROOTPASS[rootパスワード設定画面]

    ROOTPASS --> NETCONFIG2{ネットワーク未設定?}
    NETCONFIG2 -->|はい| NETCONFIG_POST[ネットワーク設定]
    NETCONFIG2 -->|いいえ| TIME
    NETCONFIG_POST --> TIME

    TIME[タイムゾーン・日付・時刻設定] --> SERVICES[サービス選択画面]
    SERVICES --> HARDENING[セキュリティ強化設定画面]
    HARDENING --> FIRMWARE[ファームウェアインストール画面]
    FIRMWARE --> ADDUSER_CONFIRM{ユーザ追加確認画面}

    ADDUSER_CONFIRM -->|Yes| ADDUSER[ユーザ追加画面]
    ADDUSER_CONFIRM -->|No| FINALCONFIG
    ADDUSER --> FINALCONFIG[最終設定メニュー画面]

    FINALCONFIG --> MANUAL_CONFIRM{手動設定確認画面}
    MANUAL_CONFIRM -->|Yes| MANUAL_SHELL[chroot シェル]
    MANUAL_CONFIRM -->|No| FINISH
    MANUAL_SHELL --> FINISH([インストール完了])
```

## ネットワーク設定サブフロー

```mermaid
flowchart TD
    NC_START([ネットワーク設定開始]) --> IF_SELECT[ネットワークインターフェース選択画面]
    IF_SELECT --> WIRELESS_CHECK{無線インターフェース?}

    WIRELESS_CHECK -->|はい| WLAN[無線LAN設定画面]
    WIRELESS_CHECK -->|いいえ| IPV4_CONFIRM

    WLAN --> IPV4_CONFIRM{IPv4設定確認画面}

    IPV4_CONFIRM -->|はい| IPV4_DHCP{DHCP使用?}
    IPV4_CONFIRM -->|いいえ| IPV6_CONFIRM

    IPV4_DHCP -->|はい| IPV4_DHCP_EXEC[DHCP取得処理]
    IPV4_DHCP -->|いいえ| IPV4_STATIC[IPv4スタティック設定画面]

    IPV4_DHCP_EXEC --> IPV6_CONFIRM
    IPV4_STATIC --> IPV6_CONFIRM

    IPV6_CONFIRM{IPv6設定確認画面} -->|はい| IPV6_SLAAC{SLAAC使用?}
    IPV6_CONFIRM -->|いいえ| DNS

    IPV6_SLAAC -->|はい| IPV6_SLAAC_EXEC[SLAAC取得処理]
    IPV6_SLAAC -->|いいえ| IPV6_STATIC[IPv6スタティック設定画面]

    IPV6_SLAAC_EXEC --> DNS
    IPV6_STATIC --> DNS

    DNS[DNS設定画面] --> NC_END([ネットワーク設定完了])
```

## 最終設定メニューサブフロー

```mermaid
flowchart TD
    FC_START([最終設定メニュー画面]) --> FC_SELECT{メニュー選択}

    FC_SELECT -->|Finish| FC_END([終了])
    FC_SELECT -->|Add User| FC_ADDUSER[ユーザ追加画面]
    FC_SELECT -->|Root Password| FC_ROOTPASS[rootパスワード設定画面]
    FC_SELECT -->|Hostname| FC_HOSTNAME[ホスト名設定画面]
    FC_SELECT -->|Network| FC_NETCONFIG[ネットワーク設定]
    FC_SELECT -->|Services| FC_SERVICES[サービス選択画面]
    FC_SELECT -->|System Hardening| FC_HARDENING[セキュリティ強化設定画面]
    FC_SELECT -->|Time Zone| FC_TIME[タイムゾーン・日時設定]
    FC_SELECT -->|Firmware| FC_FIRMWARE[ファームウェアインストール画面]
    FC_SELECT -->|Handbook| FC_DOCS[ドキュメントインストール画面]

    FC_ADDUSER --> FC_START
    FC_ROOTPASS --> FC_START
    FC_HOSTNAME --> FC_START
    FC_NETCONFIG --> FC_START
    FC_SERVICES --> FC_START
    FC_HARDENING --> FC_START
    FC_TIME --> FC_START
    FC_FIRMWARE --> FC_START
    FC_DOCS --> FC_START
```

## タイムゾーン・日時設定サブフロー

```mermaid
flowchart TD
    T_START([時刻設定開始]) --> TZSETUP[タイムゾーン選択画面]
    TZSETUP --> DATE[日付設定画面]
    DATE --> TIME_SET[時刻設定画面]
    TIME_SET --> T_END([時刻設定完了])
```

## エラー発生時の遷移

```mermaid
flowchart TD
    ERROR_OCCUR([インストールステップ中断]) --> ERROR_DIALOG[インストール中断エラー画面]
    ERROR_DIALOG -->|Restart| RESTART([インストーラ再起動])
    ERROR_DIALOG -->|Exit| EXIT([インストーラ終了])
```
