---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 66
  claims_with_evidence: 58
  claims_without_evidence: 8
confidence_derived: 0.88
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：58 / 66、根拠なし：8
- 優先レビュー（高）
  1. **画面18-配布ファイルダウンロード画面とlibfetchの関連**：C言語実装のため内部ライブラリ呼び出しの詳細確認が必要
  2. **画面20-配布ファイル展開画面とlibarchiveの関連**：C言語実装のため内部ライブラリ呼び出しの詳細確認が必要
  3. **画面27-ファームウェアインストール画面とdevdデバイスイベントの関連**：fwgetの内部動作の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（33画面）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（110機能）
- E-03: `usr.sbin/bsdinstall/scripts/auto` - メインインストールフロースクリプト
- E-04: `usr.sbin/bsdinstall/scripts/keymap` - キーマップ選択スクリプト
- E-05: `usr.sbin/bsdinstall/scripts/hostname` - ホスト名設定スクリプト
- E-06: `usr.sbin/bsdinstall/scripts/netconfig` - ネットワーク設定スクリプト
- E-07: `usr.sbin/bsdinstall/scripts/wlanconfig` - 無線LAN設定スクリプト
- E-08: `usr.sbin/bsdinstall/scripts/mirrorselect` - ミラー選択スクリプト
- E-09: `usr.sbin/bsdinstall/scripts/zfsboot` - ZFSブート設定スクリプト
- E-10: `usr.sbin/bsdinstall/partedit/partedit.c` - パーティション編集（C言語実装）
- E-11: `usr.sbin/bsdinstall/distfetch/distfetch.c` - 配布ファイルダウンロード（C言語実装）
- E-12: `usr.sbin/bsdinstall/distextract/distextract.c` - 配布ファイル展開（C言語実装）
- E-13: `usr.sbin/bsdinstall/scripts/rootpass` - rootパスワード設定スクリプト
- E-14: `usr.sbin/bsdinstall/scripts/time` - 時刻設定スクリプト
- E-15: `usr.sbin/bsdinstall/scripts/services` - サービス選択スクリプト
- E-16: `usr.sbin/bsdinstall/scripts/hardening` - セキュリティ強化スクリプト
- E-17: `usr.sbin/bsdinstall/scripts/firmware` - ファームウェアインストールスクリプト
- E-18: `usr.sbin/bsdinstall/scripts/adduser` - ユーザ追加スクリプト
- E-19: `usr.sbin/bsdinstall/scripts/finalconfig` - 最終設定メニュースクリプト
- E-20: `usr.sbin/bsdinstall/scripts/docsinstall` - ドキュメントインストールスクリプト
- E-21: `usr.sbin/bsdinstall/scripts/checksum` - チェックサム検証スクリプト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面1(キーマップ選択)はパッケージ管理支援(74)が主機能 | E-04, E-03 | ○ |
| C-02 | 画面1(キーマップ選択)は国際化・地域化(110)が補助機能 | E-04 | ○ |
| C-03 | 画面2(ホスト名設定)はパッケージ管理支援(74)が主機能 | E-05, E-03 | ○ |
| C-04 | 画面3(インストール種別選択)はパッケージ管理支援(74)が主機能 | E-03 | ○ |
| C-05 | 画面4(ネットワーク/オフライン選択)はパッケージ管理支援(74)が主機能 | E-03 | ○ |
| C-06 | 画面4はネットワークインタフェース管理(35)が遷移先機能 | E-03 | ○ |
| C-07 | 画面5(配布セット選択)はパッケージ管理支援(74)が主機能 | E-03 | ○ |
| C-08 | 画面6(NIF選択)はネットワークインタフェース管理(35)が主機能 | E-06 | ○ |
| C-09 | 画面6はTCP/IPプロトコルスタック(34)が補助機能 | E-06 | ○ |
| C-10 | 画面7(無線LAN設定)はネットワークインタフェース管理(35)が主機能 | E-07 | ○ |
| C-11 | 画面7はネットワークデバイスドライバ(55)が補助機能 | E-07 | ○ |
| C-12 | 画面7は国際化・地域化(110)が補助機能（規制ドメイン） | E-07 | ○ |
| C-13 | 画面8(IPv4設定確認)はTCP/IPプロトコルスタック(34)が主機能 | E-06 | ○ |
| C-14 | 画面8はDHCPクライアント(96)が遷移先機能 | E-06 | ○ |
| C-15 | 画面9(IPv4スタティック)はTCP/IPプロトコルスタック(34)が主機能 | E-06 | ○ |
| C-16 | 画面9はネットワークインタフェース管理(35)が補助機能 | E-06 | ○ |
| C-17 | 画面10(IPv6設定確認)はTCP/IPプロトコルスタック(34)が主機能 | E-06 | ○ |
| C-18 | 画面11(IPv6スタティック)はTCP/IPプロトコルスタック(34)が主機能 | E-06 | ○ |
| C-19 | 画面11はネットワークインタフェース管理(35)が補助機能 | E-06 | ○ |
| C-20 | 画面12(DNS設定)はDNS解決(97)が主機能 | E-06 | ○ |
| C-21 | 画面12はTCP/IPプロトコルスタック(34)が補助機能 | E-06 | ○ |
| C-22 | 画面13(ミラー選択)はlibfetch(91)が主機能 | E-08 | △ |
| C-23 | 画面13はパッケージ管理支援(74)が補助機能 | E-08 | ○ |
| C-24 | 画面14(カスタムURL)はlibfetch(91)が主機能 | E-08 | △ |
| C-25 | 画面15(パーティションモード)はGEOM(26)が主機能 | E-03 | ○ |
| C-26 | 画面15はZFS(12)が遷移先機能 | E-03 | ○ |
| C-27 | 画面15はUFS/FFS(11)が遷移先機能 | E-03 | ○ |
| C-28 | 画面16(ZFSブート設定)はZFS(12)が主機能 | E-09 | ○ |
| C-29 | 画面16はGEOM ELI(27)が補助機能 | E-09 | ○ |
| C-30 | 画面16はGEOM(26)が補助機能 | E-09 | ○ |
| C-31 | 画面16はスワップ管理(33)が補助機能 | E-09 | ○ |
| C-32 | 画面17(手動パーティション)はGEOM(26)が主機能 | E-10 | ○ |
| C-33 | 画面17はUFS/FFS(11)が補助機能 | E-10 | △ |
| C-34 | 画面17はZFS(12)が補助機能 | E-10 | △ |
| C-35 | 画面18(配布ダウンロード)はlibfetch(91)が主機能 | E-11 | △ |
| C-36 | 画面18はパッケージ管理支援(74)が補助機能 | E-03 | ○ |
| C-37 | 画面19(チェックサム検証)はパッケージ管理支援(74)が主機能 | E-21 | ○ |
| C-38 | 画面20(配布展開)はlibarchive(92)が主機能 | E-12 | △ |
| C-39 | 画面20はパッケージ管理支援(74)が補助機能 | E-03 | ○ |
| C-40 | 画面21(rootパスワード)はユーザ・グループ管理(73)が主機能 | E-13 | ○ |
| C-41 | 画面22(タイムゾーン選択)はタイマー・クロック管理(5)が主機能 | E-14 | ○ |
| C-42 | 画面23(日付設定)はタイマー・クロック管理(5)が主機能 | E-14 | ○ |
| C-43 | 画面24(時刻設定)はタイマー・クロック管理(5)が主機能 | E-14 | ○ |
| C-44 | 画面25(サービス選択)はinit/rc(69)が主機能 | E-15 | ○ |
| C-45 | 画面25はSSH(51)が補助機能 | E-15 | ○ |
| C-46 | 画面25はNTPデーモン(98)が補助機能 | E-15 | ○ |
| C-47 | 画面25は電源管理(78)が補助機能 | E-15 | ○ |
| C-48 | 画面25はコアダンプ管理(76)が補助機能 | E-15 | ○ |
| C-49 | 画面26(セキュリティ強化)はMAC(44)が主機能 | E-16 | ○ |
| C-50 | 画面26はsysctl管理(7)が補助機能 | E-16 | ○ |
| C-51 | 画面26はinit/rc(69)が補助機能 | E-16 | ○ |
| C-52 | 画面26はDTrace(8)が補助機能 | E-16 | ○ |
| C-53 | 画面27(ファームウェア)はdevdデバイスイベント(61)が主機能 | E-17 | △ |
| C-54 | 画面27はネットワークデバイスドライバ(55)が補助機能 | E-17 | ○ |
| C-55 | 画面28(ユーザ追加確認)はユーザ・グループ管理(73)が主機能 | E-03 | ○ |
| C-56 | 画面29(ユーザ追加)はユーザ・グループ管理(73)が主機能 | E-18 | ○ |
| C-57 | 画面30(最終設定メニュー)はパッケージ管理支援(74)が主機能 | E-19 | ○ |
| C-58 | 画面30はユーザ・グループ管理(73)が遷移先機能 | E-19 | ○ |
| C-59 | 画面30はネットワークインタフェース管理(35)が遷移先機能 | E-19 | ○ |
| C-60 | 画面30はinit/rc(69)が遷移先機能 | E-19 | ○ |
| C-61 | 画面30はタイマー・クロック管理(5)が遷移先機能 | E-19 | ○ |
| C-62 | 画面31(ドキュメントインストール)はパッケージ管理支援(74)が主機能 | E-20 | ○ |
| C-63 | 画面31はmanページ(109)が補助機能 | E-20 | △ |
| C-64 | 画面32(手動設定確認)はパッケージ管理支援(74)が主機能 | E-03 | ○ |
| C-65 | 画面32はシェル(79)が遷移先機能 | E-03 | ○ |
| C-66 | 画面33(エラー画面)はパッケージ管理支援(74)が主機能 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- C言語実装ファイル（distfetch.c, distextract.c, partedit.c）の内部ライブラリ呼び出し詳細を未確認
  - 候補：distfetch.c内のlibfetch API呼び出し / distextract.c内のlibarchive API呼び出し / partedit.c内のGEOM/UFS/ZFS操作
- ミラー選択画面（画面13, 14）とlibfetch(91)の直接的な関連はURL設定のみで、実際のfetch処理はdistfetch.cが担当
  - 候補：libfetch直接呼び出し確認 / fetchmissingdistsスクリプト確認
- ファームウェアインストール画面（画面27）のfwgetコマンドの内部動作詳細が未確認
  - 候補：usr.sbin/fwget/のソースコード確認 / devdとの連携確認
- ドキュメントインストール画面（画面31）とmanページ(109)の関連は間接的（pkgインストール内容として含まれる）
  - 候補：パッケージ内容の確認

## 5) リスクフラグ（レビュー観点）
- 0: 画面とスクリプトファイルの対応関係（画面一覧のテンプレートファイルパスとスクリプト内容は一致）
- 1: 主機能として「パッケージ管理支援(74)」を多数の画面に割り当てている点。bsdinstall自体がパッケージ管理支援の一部であるため妥当だが、より細分化された機能への割り当てが適切な場合がある
- 1: C言語実装の画面（画面17, 18, 20）は内部のライブラリ呼び出しを推測に基づいて割り当てている
- 0: シェルスクリプト実装の画面は直接コードを確認して割り当て済み

## 6) レビュアーチェックリスト（最小）
- [ ] 全33画面が漏れなくマッピングされているか確認
- [ ] 「主機能」の割り当てが各画面のメイン処理と整合しているか確認
- [ ] C言語実装の画面（画面17, 18, 20）のライブラリ依存関係が正確か確認
- [ ] 「パッケージ管理支援(74)」が主機能として割り当てられている画面で、より適切な機能がないか確認
- [ ] 遷移先機能の割り当てが画面遷移フローと整合しているか確認
- [ ] ファームウェアインストール画面のfwgetとdevdの関連が正確か確認
