# 画面設計書 1-キーマップ選択画面

## 概要

本ドキュメントは、FreeBSD bsdinstall インストーラにおける「キーマップ選択画面」の設計仕様を記述する。本画面はインストーラ起動直後に表示され、ユーザのキーボードレイアウトを選択する機能を提供する。

### 本画面の処理概要

本画面は、FreeBSDインストール時にキーボードレイアウト（キーマップ）を選択するためのTUI（テキストユーザインターフェース）画面である。bsdconfigフレームワークのkeymap.subrを使用して、システムに登録されているキーマップ一覧を表示し、ユーザが選択・テスト入力を行える。

**業務上の目的・背景**：FreeBSDは世界各国で使用されるOSであり、USキーボード以外のレイアウトを使用するユーザが多数存在する。インストール作業において正しいキーボードレイアウトが設定されていないと、パスワード入力やホスト名入力などの後続ステップで意図しない文字が入力される問題が生じる。本画面はインストーラの最初のステップとして、キーボードの正しいレイアウトを選択させることで、後続のすべての入力操作の正確性を担保する。

**画面へのアクセス方法**：bsdinstallインストーラ起動後、自動的に最初の画面として表示される。環境変数`BSDINSTALL_SKIP_KEYMAP`が設定されている場合は本画面がスキップされる。autoスクリプトの195行目で`bsdinstall keymap`が呼び出されることにより表示される。

**主要な操作・処理内容**：
1. キーマップ一覧の表示：bsdconfigのkeymap.subrで定義されたKEYMAPS変数から全キーマップを読み込み、メニューリストとして表示する
2. キーマップの選択：ユーザがメニューから任意のキーマップを選択すると、該当キーマップにラジオボタン(*)が付与される
3. キーマップのテスト：「Test keymap」メニュー項目を選択すると、inputboxが表示され、選択したキーマップで実際にキー入力をテストできる（dialog_keymap_test関数、70-110行目）
4. 選択の確定：「Continue with keymap」メニュー項目を選択すると、キーマップがKEYMAPFILEに保存され、kbdcontrolで適用される

**画面遷移**：
- 遷移元：bsdinstall起動（autoスクリプト）
- 遷移先：ホスト名設定画面（正常終了時）
- Cancelボタン押下時：KEYMAPFILEを削除し、bsdinstallが再起動する

**権限による表示制御**：特になし。本画面はインストーラコンテキストでrootとして実行されるため、権限による制御は行われない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | パッケージ管理支援 | 主機能 | bsdinstallフレームワークによるキーボードレイアウト選択・テスト入力の主処理 |
| 110 | 国際化・地域化 | 補助機能 | キーマップ定義ファイルの参照によるキーボードレイアウト一覧の生成 |

## 画面種別

選択（メニュー形式のキーマップ選択画面）

## URL/ルーティング

TUIベースのインストーラのため、URLは存在しない。bsdinstallコマンド体系で`bsdinstall keymap`として呼び出される。実体は`usr.sbin/bsdinstall/scripts/keymap`シェルスクリプトである。

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 | 初期値 | 必須 |
|--------|----------|-----|------|--------|------|
| keymap | 入力/出力 | 文字列 | 選択されたキーマップ識別子 | rc.confのkeymap値、未設定時は空（USデフォルト） | いいえ |
| KEYMAPFILE | 出力 | ファイルパス | キーマップ設定の保存先 | $BSDINSTALL_TMPETC/rc.conf.keymap | - |
| テスト入力テキスト | 入力 | 文字列 | テスト入力時のユーザ入力文字列 | 空 | いいえ |

## 表示項目

| 項目名 | 説明 | 表示形式 |
|--------|------|----------|
| タイトル | "Keymap Selection" | ダイアログタイトル |
| バックタイトル | "$OSNAME Installer" | ダイアログバックタイトル |
| プロンプト | USキーマップがデフォルトである旨の説明文 | テキスト |
| Continue with keymap | 現在選択中のキーマップで続行するメニュー項目 | メニュー先頭項目(>>>) |
| Test keymap | 現在のキーマップをテストするメニュー項目 | メニュー項目(->-) |
| キーマップ一覧 | 利用可能なキーマップのリスト | ラジオボタン付きメニュー項目 |

## イベント仕様

### 1-キーマップ選択

ユーザがメニューからキーマップ項目を選択すると、そのキーマップが内部変数`keymap`に設定され、KEYMAPFILEに`keymap="選択値"`として書き込まれる（224行目）。メニューの該当項目にラジオマーク(*)が付与される。

### 2-テスト入力

「Test keymap」項目を選択すると、`dialog_keymap_test`関数が呼び出される（210行目）。選択中のキーマップが`f_keymap_kbdcontrol`で一時的に適用され（81行目）、inputboxダイアログが表示される。ユーザはキー入力を試すことができ、Enterで終了する。

### 3-選択確定（Continue）

「Continue with keymap」項目を選択すると（207行目）、whileループを抜け、`f_keymap_kbdcontrol`で最終的にキーマップが適用され（227行目）、`exit $SUCCESS`でスクリプトが正常終了する。

### 4-キャンセル

Cancelボタンを押下すると（200-203行目）、KEYMAPFILEが削除され、`exit $FAILURE`でスクリプトが異常終了する。これによりbsdinstallが再起動する。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースを使用しない。代わりにファイルベースで設定を保存する。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| キーマップ選択 | $BSDINSTALL_TMPETC/rc.conf.keymap | WRITE | `keymap="選択値"`を書き込み |
| キャンセル | $BSDINSTALL_TMPETC/rc.conf.keymap | DELETE | ファイルを削除 |

### テーブル別更新項目詳細

#### $BSDINSTALL_TMPETC/rc.conf.keymap

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| WRITE | keymap | ユーザが選択したキーマップ識別子 | 例: `keymap="jp.kbd"` |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| msg_keymap_menu_text | 説明 | "The system console driver for $OSNAME defaults to standard \"US\" keyboard map. Other keymaps can be chosen below." | 画面表示時に常時 |
| msg_continue_with_keymap | メニュー | "Continue with %s keymap" | 常時表示、%sは選択中キーマップ名 |
| msg_test_keymap | メニュー | "Test %s keymap" | 常時表示、%sは選択中キーマップ名 |
| msg_test_the_keymap_by_typing | 説明 | "Test the keymap by typing letters, numbers, and symbols..." | テスト入力ダイアログ表示時 |
| msg_error | エラー | "Error" | キーマップ適用失敗時のダイアログタイトル |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| kbdcontrolでのキーマップ適用失敗 | エラーダイアログを表示し、テスト入力を中断（dialog_keymap_test関数内、82-87行目） |
| Ctrl-C（SIGINT）受信 | KEYMAPFILEを削除し、exit $FAILUREで終了（126行目のtrap） |
| Cancel押下 | KEYMAPFILEを削除し、exit $FAILUREでbsdinstall再起動（200-203行目） |

## 備考

- 環境変数`BSDINSTALL_SKIP_KEYMAP`が設定されている場合、autoスクリプト195行目の条件分岐により本画面は表示されない
- キーマップの一覧はbsdconfigの`keymap.subr`により`/usr/share/bsdconfig/`配下のキーマップ定義から動的に生成される
- ダイアログにはbsdconfigのdialog.subrラッパーが使用され、XDialogとbsddialogの両方に対応する
- USキーボードの場合はデフォルト（空）のまま続行できる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、キーマップデータの構造とbsdconfigフレームワークの基本を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | keymap.subr | `/usr/share/bsdconfig/keymap.subr` | KEYMAPS変数の構造、keymap_XXX関数群（get keym/descメソッド）の仕組みを理解する |
| 1-2 | common.subr | `/usr/share/bsdconfig/common.subr` | f_dprintf、f_include、f_getvar等の汎用関数を理解する |
| 1-3 | dialog.subr | `/usr/share/bsdconfig/dialog.subr` | DIALOG変数、f_dialog_title、f_dialog_menu_with_help_size等のダイアログ関数を理解する |

**読解のコツ**: bsdconfigフレームワークはシェルスクリプトでオブジェクト指向的なパターンを実現している。`keymap_$k get keym keym`のような呼び出しは、keymap構造体のkメンバからkeymプロパティを取得して変数keymに格納する。

#### Step 2: エントリーポイントを理解する

処理の起点となるautoスクリプトからkeymapスクリプトへの呼び出しを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 195行目の`bsdinstall keymap`呼び出しが本画面のエントリーポイント |
| 2-2 | keymap | `usr.sbin/bsdinstall/scripts/keymap` | 117-228行目のMAINセクションが画面の主処理 |

**主要処理フロー**:
1. **117-118行目**: ダイアログタイトル・バックタイトルの設定
2. **129-133行目**: rc.confからの初期キーマップ値取得
3. **143-225行目**: メインループ - キーマップメニューの表示と選択処理
4. **147-153行目**: Continue/Testメニュー項目の構築
5. **160-175行目**: KEYMAPS変数からキーマップ一覧を構築
6. **187-203行目**: ダイアログ表示と選択結果の取得
7. **206-213行目**: 選択結果に応じた分岐（Continue/Test/キーマップ選択）
8. **227行目**: 選択確定後のkbdcontrolによるキーマップ適用

#### Step 3: テスト入力機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | keymap | `usr.sbin/bsdinstall/scripts/keymap` | 70-110行目のdialog_keymap_test関数 |

**主要処理フロー**:
- **79-88行目**: f_keymap_kbdcontrolでキーマップを一時適用、失敗時はエラーダイアログ
- **99-107行目**: inputboxダイアログでテスト入力を受け付け

### プログラム呼び出し階層図

```
auto (bsdinstall起動スクリプト)
    |
    +-- bsdinstall keymap
            |
            +-- common.subr (f_dprintf, f_include)
            +-- dialog.subr (DIALOG, f_dialog_title, f_dialog_menu_with_help_size)
            +-- keymap.subr (KEYMAPS, keymap_XXX get keym/desc)
            +-- sysrc.subr (f_sysrc_get)
            |
            +-- [メインループ]
            |      +-- f_dialog_menu_with_help_size (メニューサイズ計算)
            |      +-- $DIALOG --menu (メニュー表示)
            |      +-- dialog_keymap_test (テスト入力)
            |      |      +-- f_keymap_kbdcontrol (キーマップ適用)
            |      |      +-- $DIALOG --inputbox (入力テスト)
            |      +-- keymap_$k get keym (キーマップ値取得)
            |      +-- echo > KEYMAPFILE (設定保存)
            |
            +-- f_keymap_kbdcontrol (最終キーマップ適用)
```

### データフロー図

```
[入力]                        [処理]                              [出力]

rc.conf (keymap値)  ------>  keymap スクリプト初期化  -------->  初期選択状態
keymap.subr         ------>  KEYMAPS一覧構築         -------->  メニューリスト
    (KEYMAPS変数)

ユーザ選択          ------>  メニュー選択処理         -------->  keymap変数更新
                                                               KEYMAPFILE書き込み

テスト入力          ------>  dialog_keymap_test       -------->  kbdcontrol適用
                              f_keymap_kbdcontrol               (一時的)

確定操作            ------>  f_keymap_kbdcontrol      -------->  kbdcontrol適用
                                                               (永続的)
                                                               $BSDINSTALL_TMPETC/
                                                               rc.conf.keymap
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| keymap | `usr.sbin/bsdinstall/scripts/keymap` | ソース | 本画面の主スクリプト |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | インストーラメインスクリプト（呼び出し元） |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数群 |
| dialog.subr | `/usr/share/bsdconfig/dialog.subr` | ライブラリ | ダイアログ表示関数群 |
| keymap.subr | `/usr/share/bsdconfig/keymap.subr` | ライブラリ | キーマップデータ・操作関数群 |
| sysrc.subr | `/usr/share/bsdconfig/sysrc.subr` | ライブラリ | rc.conf読み書き関数群 |
| rc.conf.keymap | `$BSDINSTALL_TMPETC/rc.conf.keymap` | 設定 | キーマップ設定保存先一時ファイル |
