# 画面設計書 10-IPv6設定確認画面

## 概要

本ドキュメントは、FreeBSD bsdinstall インストーラにおける「IPv6設定確認画面」の設計仕様を記述する。本画面はIPv6を使用するか確認し、SLAAC又はスタティック設定を行う。

### 本画面の処理概要

本画面は、選択されたネットワークインターフェースに対してIPv6ネットワーク設定を行うためのTUI画面である。IPv6使用の有無確認、SLAAC（Stateless Address Autoconfiguration）/スタティック選択、およびSLAACによるアドレス自動設定を処理する。

**業務上の目的・背景**：IPv6はインターネットの次世代プロトコルであり、IPv4アドレス枯渇への対応として多くのネットワークで使用されている。本画面はSLAACによる自動設定と手動（スタティック）設定の両方に対応する。SLAACはルータアドバタイズメントに基づいてアドレスを自動設定する仕組みであり、DHCPv6はFreeBSDの標準インストールに含まれていないため、現在はサポートされていない（ソースコードの47行目にTODOコメントあり）。

**画面へのアクセス方法**：netconfigスクリプトの150行目で`bsdinstall netconfig_ipv6 ${INTERFACE} $AUTO`として呼び出される。kern.features.inet6のsysctlでIPv6サポートが確認された場合にのみ呼び出される。Manualモード時はIPv6使用確認のYes/Noダイアログがnetconfigの142-148行目で表示される。

**主要な操作・処理内容**：
1. IPv6使用確認（Manualモード時）：「Would you like to configure IPv6 for this interface?」のYes/Noダイアログ（netconfigスクリプト143-147行目）
2. SLAAC使用確認：「Would you like to try stateless address autoconfiguration (SLAAC)?」のYes/Noダイアログ（73-80行目）
3. SLAACアドレス設定：rtsol（Router Solicitation）によるIPv6アドレスの自動設定（82-99行目）
4. スタティック設定画面への遷移：SLAAC不使用時はIPv6スタティック設定画面（画面No.11に相当する部分）に進む（104-167行目）

**画面遷移**：
- 遷移元：IPv4設定確認画面/IPv4スタティック設定画面
- 遷移先（SLAAC選択時）：DNS設定画面
- 遷移先（スタティック選択時）：IPv6スタティック設定画面（同スクリプト内のフォーム部分）
- IPv6不使用選択時：DNS設定画面
- SLAAC失敗時：再度SLAAC確認ダイアログを表示

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | TCP/IPプロトコルスタック | 主機能 | IPv6使用有無の確認およびSLAAC/スタティック設定モード選択 |

## 画面種別

確認・設定（Yes/Noダイアログ + SLAAC設定画面）

## URL/ルーティング

TUIベースのインストーラのため、URLは存在しない。`bsdinstall netconfig_ipv6`として呼び出される。実体は`usr.sbin/bsdinstall/scripts/netconfig_ipv6`シェルスクリプトである。

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 | 初期値 | 必須 |
|--------|----------|-----|------|--------|------|
| INTERFACE | 入力 | 文字列 | ネットワークインターフェース名 | 引数$1 | はい |
| AUTO | 入力 | 文字列 | "auto"またはブランク | 引数$2 | いいえ |
| SLAAC | 内部 | 整数 | SLAAC使用フラグ（1/0） | Autoモード時は1 | - |

## 表示項目

| 項目名 | 説明 | 表示形式 |
|--------|------|----------|
| タイトル | "Network Configuration" | ダイアログタイトル |
| SLAAC確認プロンプト | "Would you like to try stateless address autoconfiguration (SLAAC)?" | Yes/Noダイアログ |
| Router Solicitation中メッセージ | "Sending Router Solicitation ..." | infobox |

## イベント仕様

### 1-SLAAC選択

Autoモード時はSLAAC=1が自動設定される（71行目）。Manualモード時はYes/Noダイアログでユーザに確認される（73-80行目）。SLAAC=1の場合、BSDINSTALL_CONFIGCURRENT設定時にrtsol（Router Solicitation）が実行される（82-97行目）。成功時、`ifconfig_${INTERFACE}_ipv6="inet6 accept_rtadv"`がrc.conf.netに書き込まれる（98行目）。

### 2-スタティック選択

SLAAC不使用の場合（SLAAC=0）、whileループのbreakによりスタティック設定処理に移行する（101行目）。IPv6アドレスとデフォルトルータの入力フォームが表示される（105-136行目）。

### 3-SLAAC失敗

SLAAC取得が失敗した場合、Autoモード時はexit 1（91行目）、Manualモード時はエラーメッセージ表示後にwhile continueでSLAAC確認を再表示する（93-95行目）。AGAINフラグにより「again」が追加されたプロンプトが表示される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| SLAAC選択 | $BSDINSTALL_TMPETC/._rc.conf.net | WRITE | ifconfig_${IF}_ipv6="inet6 accept_rtadv"を設定 |
| スタティック設定 | $BSDINSTALL_TMPETC/._rc.conf.net | APPEND | ifconfig_${IF}_ipv6、ipv6_defaultrouterを追記 |

### テーブル別更新項目詳細

#### $BSDINSTALL_TMPETC/._rc.conf.net

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| WRITE | ifconfig_${IF}_ipv6 | "inet6 accept_rtadv" | SLAAC選択時 |
| WRITE | ifconfig_${IF}_ipv6 | "inet6 $ADDR" | スタティック時 |
| WRITE | ipv6_defaultrouter | ユーザ入力値 | スタティック時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | 確認 | "Would you like to try stateless address autoconfiguration (SLAAC)?" | Manualモード初回 |
| - | 確認 | "Would you like to try stateless address autoconfiguration (SLAAC) again?" | SLAAC失敗後の再確認 |
| - | 情報 | "Sending Router Solicitation ..." | SLAAC実行中 |
| - | エラー | "SLAAC failed." | SLAAC失敗時（Manualモード） |
| - | エラー | "No interface specified for IPv6 configuration." | INTERFACEが空の場合 |
| - | エラー | "Bad auto option '$AUTO'." | AUTO引数が不正な場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| INTERFACEが未指定 | エラーメッセージ表示後exit 1（53-56行目） |
| AUTO引数が不正 | エラーメッセージ表示後exit 1（61-65行目） |
| SLAAC失敗（Autoモード） | exit 1で終了（91行目） |
| SLAAC失敗（Manualモード） | エラーメッセージ表示後、SLAAC確認を再表示（93-95行目） |
| フォームキャンセル | exit 1で終了（137行目） |

## 備考

- DHCPv6はFreeBSD標準に含まれていないため、現在はサポートされていない（47行目のTODOコメント）
- SLAACにはrtsol（Router Solicitation）コマンドが使用される。`-F`フラグでフラッシュ後にSolicitationが送信される
- SLAAC前に`ifconfig ${INTERFACE} inet6 -ifdisabled accept_rtadv up`でインターフェースが設定される（86行目）
- スタティック設定時、IPv6アドレスにプレフィックス長が含まれない場合は自動的に`/64`が付与される（163-165行目）
- Autoモード時はSLAACが自動選択され、ユーザへの確認ダイアログは表示されない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | netconfig_ipv6 | `usr.sbin/bsdinstall/scripts/netconfig_ipv6` | 50-51行目の引数受け取り（INTERFACE、AUTO） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | 142-158行目のIPv6設定呼び出し部分 |
| 2-2 | netconfig_ipv6 | `usr.sbin/bsdinstall/scripts/netconfig_ipv6` | 42-180行目のMAINセクション |

**主要処理フロー**:
1. **50-66行目**: 引数バリデーション
2. **69-103行目**: SLAAC処理whileループ（Auto時は自動、Manual時はYes/No確認）
3. **82-97行目**: SLAAC実行（ifconfig設定、rtsol実行）
4. **98行目**: sysrcでrc.conf.net書き込み
5. **105-130行目**: スタティック設定（現在値取得、フォーム表示）
6. **140-167行目**: awk処理でrc.conf生成
7. **170-178行目**: CONFIGCURRENT時の即時適用

#### Step 3: スタティック設定フォーム構築を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | netconfig_ipv6 | `usr.sbin/bsdinstall/scripts/netconfig_ipv6` | 105-130行目のADDRS変数構築（awkによるmixedform引数生成） |

**主要処理フロー**:
- **105行目**: netstat -Wrn -f inet6でIPv6デフォルトルータ取得
- **106-130行目**: ifconfig ${INTERFACE} inet6でIPv6アドレス取得、awkでbsddialogのmixedform引数を構築
- **132-136行目**: bsddialog --mixedformでフォーム表示

### プログラム呼び出し階層図

```
netconfig (ネットワーク設定スクリプト)
    |
    +-- bsdinstall netconfig_ipv6 $INTERFACE $AUTO
            |
            +-- 引数バリデーション (50-66行目)
            |
            +-- [SLAAC処理ループ]
            |      +-- [Autoモード] -> SLAAC=1
            |      +-- [Manualモード] -> bsddialog --yesno
            |      |
            |      +-- [SLAAC=1]
            |      |      +-- ifconfig inet6 -ifdisabled accept_rtadv up
            |      |      +-- rtsol -F $INTERFACE
            |      |      +-- sysrc ifconfig_${IF}_ipv6="inet6 accept_rtadv"
            |      |
            |      +-- [SLAAC=0] -> break -> スタティック設定
            |
            +-- [スタティック設定]
                   +-- netstat -Wrn -f inet6 (デフォルトルータ取得)
                   +-- ifconfig $IF inet6 (現在アドレス取得)
                   +-- awk (mixedform引数構築)
                   +-- bsddialog --mixedform (フォーム表示)
                   +-- awk (rc.conf生成)
                   +-- [CONFIGCURRENT時]
                          +-- ifconfig (適用)
                          +-- route add -inet6 default (適用)
```

### データフロー図

```
[入力]                          [処理]                          [出力]

INTERFACE, AUTO          -----> 引数解析               -------> SLAAC判定

[SLAAC=1]
rtsol -F $IF             -----> Router Solicitation    -------> IPv6アドレス設定
                                sysrc                  -------> ._rc.conf.net
                                                               (accept_rtadv)

[SLAAC=0]
ifconfig $IF inet6       -----> awk抽出                -------> ADDRS
netstat -Wrn -f inet6    -----> awk抽出                -------> ROUTER6

ユーザ入力               -----> bsddialog --mixedform  ------> IF_CONFIG
  (IPv6 Addr, Router)

IF_CONFIG                -----> awk生成                -------> ._rc.conf.net
                                                               (ifconfig_${IF}_ipv6,
                                                                ipv6_defaultrouter)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| netconfig_ipv6 | `usr.sbin/bsdinstall/scripts/netconfig_ipv6` | ソース | 本画面の主スクリプト |
| netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | ソース | 呼び出し元スクリプト |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数群 |
| dialog.subr | `/usr/share/bsdconfig/dialog.subr` | ライブラリ | ダイアログ表示関数群 |
| ._rc.conf.net | `$BSDINSTALL_TMPETC/._rc.conf.net` | 設定 | ネットワーク設定一時ファイル |
