# 画面設計書 11-IPv6スタティック設定画面

## 概要

本ドキュメントは、FreeBSD bsdinstallインストーラにおけるIPv6スタティック設定画面の設計書である。ネットワーク設定フローの一部として、IPv6アドレスおよびデフォルトルータを手動で入力・設定する画面について記述する。

### 本画面の処理概要

この画面では、SLAAC（Stateless Address Autoconfiguration）を使用しない場合に、IPv6アドレスとデフォルトルータを手動入力するためのフォームを提供する。

**業務上の目的・背景**：FreeBSDのインストール時にIPv6ネットワーク接続が必要な場合、SLAACに対応していないネットワーク環境や、固定IPv6アドレスを割り当てたいケースに対応するために本画面が存在する。ネットワークインストールやpkgbaseによるインストールでは、配布ファイルのダウンロードにネットワーク接続が必須であり、IPv6のみの環境ではこの画面が重要な役割を果たす。

**画面へのアクセス方法**：ネットワーク設定フロー内で、IPv6設定確認画面（No.10）にてIPv6を使用すると回答し、かつSLAACを使用しないと選択した場合に遷移する。具体的には `netconfig_ipv6` スクリプトのSLAAC確認ダイアログで「No」を選択した場合である。

**主要な操作・処理内容**：
1. 現在のインターフェースに設定されているIPv6アドレス（fe80リンクローカル除外）とデフォルトルータの既存値を取得し、フォームに初期値として表示する
2. ユーザがIPv6アドレス（プレフィックス長付き）を入力する
3. ユーザがデフォルトルータのIPv6アドレスを入力する
4. 入力値をバリデーションし、`rc.conf.net` に `ifconfig_{INTERFACE}_ipv6` および `ipv6_defaultrouter` として保存する
5. BSDINSTALL_CONFIGCURRENT が設定されている場合、即座にインターフェースにアドレスを適用しルートを設定する

**画面遷移**：
- 遷移元：IPv6設定確認画面（No.10）でSLAACを使用しないと選択した場合
- 遷移先：DNS設定画面（No.12）へ進む（netconfigスクリプトの制御フロー内）
- キャンセル時：ネットワーク設定の最初（netconfigスクリプト）に戻る

**権限による表示制御**：権限による表示制御はない。インストーラはroot権限で動作する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | TCP/IPプロトコルスタック | 主機能 | IPv6アドレス・デフォルトルータの手動入力・設定処理 |
| 35 | ネットワークインタフェース管理 | 補助機能 | ifconfigによるインターフェースへのIPv6アドレス適用 |

## 画面種別

入力フォーム（mixedform）

## URL/ルーティング

TUIベースのbsddialogインターフェース。URLは存在しない。
- 呼び出し：`bsdinstall netconfig_ipv6 ${INTERFACE}`
- 実体スクリプト：`usr.sbin/bsdinstall/scripts/netconfig_ipv6`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 初期値 | 説明 |
|--------|--------|------|------|--------|------|
| IPv6 Address | 入力 | テキスト | はい | 現在のインターフェースのIPv6アドレス/プレフィックス長 | IPv6アドレスをCIDR表記で入力（例：2001:db8::1/64） |
| Default Router | 入力 | テキスト | いいえ | 現在のデフォルトルータアドレス | IPv6デフォルトルータのアドレス |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| バックタイトル | 画面上部 | "$OSNAME Installer" |
| タイトル | ダイアログタイトル | "Network Configuration" |
| フォームタイトル | フォーム内 | "Static IPv6 Network Interface Configuration" |
| IPv6 Address ラベル | フォーム行1 | IPv6アドレス入力フィールドのラベル |
| Default Router ラベル | フォーム行2 | デフォルトルータ入力フィールドのラベル |

## イベント仕様

### 1-OK（確定）ボタン押下

入力された値をパースし、以下の処理を行う：
1. IPv6アドレスにプレフィックス長が含まれない場合、自動的に `/64` を付与する（行163-165）
2. `$BSDINSTALL_TMPETC/._rc.conf.net` に `ifconfig_{INTERFACE}_ipv6="inet6 {アドレス}"` を追記する
3. デフォルトルータが入力されている場合、`ipv6_defaultrouter="{アドレス}"` を追記する
4. `BSDINSTALL_CONFIGCURRENT` が設定されている場合、ifconfigとrouteコマンドで即座に反映する
5. DNS設定画面へ遷移する

### 2-Cancel（キャンセル）ボタン押下

netconfig_ipv6スクリプトが終了コード1で終了し、呼び出し元のnetconfigスクリプトがネットワーク設定の最初から再実行される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| OK押下 | $BSDINSTALL_TMPETC/._rc.conf.net | WRITE | ifconfig_*_ipv6とipv6_defaultrouterの書き込み |

### テーブル別更新項目詳細

#### ._rc.conf.net（一時ネットワーク設定ファイル）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| APPEND | ifconfig_{INTERFACE}_ipv6 | "inet6 {入力されたIPv6アドレス/プレフィックス}" | awkで生成 |
| APPEND | ipv6_defaultrouter | "{入力されたデフォルトルータ}" | 入力があった場合のみ |

## メッセージ仕様

| 種別 | 条件 | メッセージ |
|------|------|-----------|
| エラー | インターフェース未指定 | "No interface specified for IPv6 configuration." |
| エラー | 不正なAUTOオプション | "Bad auto option '{値}'." |
| 情報 | SLAAC実行中 | "Sending Router Solicitation ..." |
| エラー | SLAAC失敗 | "SLAAC failed." |

## 例外処理

| 条件 | 動作 |
|------|------|
| インターフェース引数が空 | エラーメッセージを表示し終了コード1で終了 |
| 不正なAUTOオプション | エラーメッセージを表示し終了コード1で終了 |
| SLAAC失敗（autoモード） | 終了コード1で終了 |
| SLAAC失敗（手動モード） | エラーメッセージを表示し再度SLAAC確認から繰り返し |
| Cancelボタン押下 | 終了コード1で終了 |
| ルート設定失敗 | 終了コードを返して終了 |

## 備考

- DHCPv6はFreeBSDに同梱されていないため、SLAACとスタティック設定のみ対応している（ソースコード行47のTODOコメント参照）
- プレフィックス長が指定されない場合、デフォルトで/64が自動付与される
- fe80で始まるリンクローカルアドレスはフォームの初期値から自動的に除外される
- 複数のIPv6アドレスが存在する場合、最初のアドレスのみが表示・設定対象となる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面で扱うデータは主にシェル変数と一時設定ファイルである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | netconfig_ipv6 | `usr.sbin/bsdinstall/scripts/netconfig_ipv6` | 環境変数INTERFACE、AUTO、BSDINSTALL_TMPETC、BSDINSTALL_CONFIGCURRENTの役割を理解する |

**読解のコツ**: bsdinstallスクリプトではBSDINSTALL_*環境変数が設定パスや動作モードを制御する。bsddialogコマンドの戻り値（BSDDIALOG_OK=0, BSDDIALOG_CANCEL=1）でユーザ操作を判定する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | netconfig_ipv6 | `usr.sbin/bsdinstall/scripts/netconfig_ipv6` | スクリプト全体がエントリーポイント。引数 $1 がインターフェース名、$2 がAUTOモード指定 |

**主要処理フロー**:
1. **行50-66**: 引数バリデーション（INTERFACE, AUTO）
2. **行69-103**: SLAACの確認と実行のループ。SLAACを選択しない場合breakでスタティック設定へ
3. **行105-130**: 現在のIPv6アドレスとデフォルトルータの取得（netstat, ifconfig, awk使用）
4. **行132-138**: bsddialog mixedformによるスタティック設定入力フォームの表示
5. **行140-167**: 入力値のパースとrc.conf.netへの書き込み（awkスクリプト）
6. **行170-178**: BSDINSTALL_CONFIGCURRENT時の即時適用（ifconfig, route）

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | 行149-158でnetconfig_ipv6が呼び出される。IPv6対応確認後、autoモードかmanualモードで呼び出し |

**主要処理フロー**:
- **行142-148**: IPv6対応確認のyesnoダイアログ表示
- **行149-158**: `bsdinstall netconfig_ipv6 ${INTERFACE} $AUTO` の呼び出し

### プログラム呼び出し階層図

```
bsdinstall auto (usr.sbin/bsdinstall/scripts/auto)
    |
    +-- bsdinstall netconfig (usr.sbin/bsdinstall/scripts/netconfig)
           |
           +-- bsdinstall netconfig_ipv6 ${INTERFACE} [auto]
                  |
                  +-- bsddialog --yesno (SLAAC確認)
                  +-- ifconfig / rtsol (SLAAC実行、選択時)
                  +-- netstat -Wrn (既存ルータ取得)
                  +-- ifconfig ${INTERFACE} inet6 (既存アドレス取得)
                  +-- bsddialog --mixedform (スタティック入力フォーム)
                  +-- awk (入力値パース・rc.conf.net書き込み)
                  +-- sysrc (SLAAC時のrc.conf.net書き込み)
                  +-- ifconfig / route (即時適用)
```

### データフロー図

```
[入力]                       [処理]                          [出力]

ユーザ入力
  IPv6アドレス ---------> bsddialog mixedform ---------> awk パーサ
  デフォルトルータ ---->                                      |
                                                              v
既存設定                                          $BSDINSTALL_TMPETC/
  ifconfig出力 ---------> awk (初期値生成) ------->  ._rc.conf.net
  netstat出力 ---------->                                     |
                                                              v
                                                    ifconfig / route
                                                    (即時適用、条件付き)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| netconfig_ipv6 | `usr.sbin/bsdinstall/scripts/netconfig_ipv6` | ソース | IPv6設定のメインスクリプト（SLAAC確認+スタティック設定） |
| netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | ソース | ネットワーク設定の親スクリプト。netconfig_ipv6を呼び出す |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | インストーラメインスクリプト。netconfigを呼び出す |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfigフレームワークの共通サブルーチン |
| dialog.subr | `/usr/share/bsdconfig/dialog.subr` | ライブラリ | ダイアログ関連のサブルーチン |
