# 画面設計書 12-DNS設定画面

## 概要

本ドキュメントは、FreeBSD bsdinstallインストーラにおけるDNS設定画面の設計書である。ネットワーク設定フローの最終段階として、DNSサーチドメインとネームサーバ（IPv4/IPv6）を設定するフォーム画面について記述する。

### 本画面の処理概要

この画面では、DNS解決に必要なサーチドメインとネームサーバのIPアドレスを設定する。IPv4/IPv6の対応状況に応じて入力フィールドが動的に構成される。

**業務上の目的・背景**：FreeBSDインストール時にネットワーク経由で配布ファイルをダウンロードしたり、pkgbaseでパッケージを取得するためには、DNS名前解決が正しく設定されている必要がある。DHCP/SLAACで自動取得できなかったDNS情報を手動で補完・修正するために本画面が存在する。Autoモードかつネームサーバが既に取得済みの場合はこの画面を省略し、resolv.confに自動書き込みが行われる。

**画面へのアクセス方法**：ネットワーク設定フロー（netconfigスクリプト）において、IPv4およびIPv6の設定完了後に自動的に表示される。ただしAutoモードでネームサーバが既に取得済みの場合はスキップされる。

**主要な操作・処理内容**：
1. 既存の `resolv.conf` からサーチドメインとネームサーバ（IPv4/IPv6）の現在値を読み取る
2. IPv4/IPv6の利用可否に応じてフォームフィールドを動的に構成する
3. ユーザがサーチドメインとネームサーバアドレスを入力・編集する
4. 入力値をawkでパースし、`resolv.conf` 形式に変換して `$BSDINSTALL_TMPETC/resolv.conf` に書き込む
5. 一時ネットワーク設定ファイル `._rc.conf.net` を `rc.conf.net` にリネームして確定する

**画面遷移**：
- 遷移元：IPv6スタティック設定画面（No.11）またはIPv4/IPv6設定完了後
- 遷移先：ネットワーク設定完了（呼び出し元のautoスクリプトに戻る）
- キャンセル時：netconfigスクリプトの最初に戻る（exec $0で再実行）

**権限による表示制御**：権限による表示制御はない。インストーラはroot権限で動作する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 97 | DNS解決 | 主機能 | DNSサーチドメインおよびネームサーバ（IPv4/IPv6）のresolv.conf設定処理 |
| 34 | TCP/IPプロトコルスタック | 補助機能 | IPv4/IPv6ネームサーバの区別・設定 |

## 画面種別

入力フォーム（mixedform）

## URL/ルーティング

TUIベースのbsddialogインターフェース。URLは存在しない。
- 呼び出し：`bsdinstall netconfig`（内部処理の一部）
- 実体スクリプト：`usr.sbin/bsdinstall/scripts/netconfig`（行190-233）

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 初期値 | 説明 |
|--------|--------|------|------|--------|------|
| Search | 入力 | テキスト | いいえ | 既存resolv.confのsearch値 | DNSサーチドメイン |
| IPv6 DNS #1 | 入力 | テキスト | いいえ | 既存resolv.confの最初のIPv6ネームサーバ | IPv6ネームサーバ1（IPv6有効時のみ表示） |
| IPv6 DNS #2 | 入力 | テキスト | いいえ | 既存resolv.confの2番目のIPv6ネームサーバ | IPv6ネームサーバ2（IPv6有効時のみ表示） |
| IPv4 DNS #1 | 入力 | テキスト | いいえ | 既存resolv.confの最初のIPv4ネームサーバ | IPv4ネームサーバ1（IPv4有効時のみ表示） |
| IPv4 DNS #2 | 入力 | テキスト | いいえ | 既存resolv.confの2番目のIPv4ネームサーバ | IPv4ネームサーバ2（IPv4有効時のみ表示） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| バックタイトル | 画面上部 | "$OSNAME Installer" |
| タイトル | ダイアログタイトル | "Network Configuration" |
| フォームタイトル | フォーム内 | "Resolver Configuration" |

## イベント仕様

### 1-OK（確定）ボタン押下

1. 入力値をawkでパースする（行235-259）
2. サーチドメインを `search {ドメイン}` 形式で出力する
3. ネームサーバを `nameserver {アドレス}` 形式で出力する
4. パース結果を `$BSDINSTALL_TMPETC/resolv.conf` に書き込む
5. `$BSDINSTALL_TMPETC/._rc.conf.net` を `$BSDINSTALL_TMPETC/rc.conf.net` にリネームして設定を確定する（行261）

### 2-Cancel（キャンセル）ボタン押下

netconfigスクリプトが `exec $0` で自身を再実行し、ネットワーク設定の最初（インターフェース選択）からやり直す。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| OK押下 | $BSDINSTALL_TMPETC/resolv.conf | WRITE | DNSサーチドメインとネームサーバの書き込み |
| OK押下 | $BSDINSTALL_TMPETC/rc.conf.net | RENAME | ._rc.conf.netからrc.conf.netへリネーム |

### テーブル別更新項目詳細

#### resolv.conf

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| WRITE | search | 入力されたサーチドメイン | 空の場合は出力されない |
| WRITE | nameserver | 入力されたネームサーバアドレス（各行1つ） | IPv4/IPv6混在可 |

## メッセージ仕様

| 種別 | 条件 | メッセージ |
|------|------|-----------|
| エラー | Auto設定失敗 | "Failed to automatically configure interface (tried {失敗項目})." |

## 例外処理

| 条件 | 動作 |
|------|------|
| IPv4もIPv6も利用不可 | AUTO_FAILが設定されていればエラーメッセージを表示しnetconfigを再実行。未設定なら正常終了 |
| Cancelボタン押下 | exec $0でnetconfigを再実行 |
| Autoモードでネームサーバ取得済み | ダイアログを表示せず自動的にresolv.confを生成 |

## 備考

- フォームの構成はIPv4/IPv6の利用状況により3パターンある（両方有効/IPv6のみ/IPv4のみ）
- Autoモードかつネームサーバが既に取得されている場合、ダイアログは表示されずresolv.confが自動生成される（行222-223）
- 「Nameserver」という隠し読み取り専用フィールドがサーチドメインとネームサーバの区切りマーカとして使用される
- resolv.confの読み込み時、IPv4アドレス（ドット区切り）とIPv6アドレス（コロン区切り）を正規表現で自動判別する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | 行160-188のresolv.conf読み取り処理。SEARCH, IP4_1, IP4_2, IP6_1, IP6_2変数の構造を理解する |

**読解のコツ**: resolv.confのパースではIPv4（ドット4区切り）とIPv6（コロン含む16進）を正規表現で分離している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | DNS設定画面のロジックはnetconfigスクリプト内の行160-261に統合されている |

**主要処理フロー**:
1. **行160-188**: 既存resolv.confの読み取りとIPv4/IPv6ネームサーバの分類
2. **行190-218**: IPv4/IPv6対応状況に応じたbsddialog mixedformの引数構築
3. **行220-233**: Autoモード判定とダイアログ表示/スキップ
4. **行235-259**: awk による入力値パースとresolv.conf生成
5. **行261**: ._rc.conf.net を rc.conf.net にリネーム

#### Step 3: awk パーサの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | 行236-259のawkスクリプト。search変数で状態遷移し、Nameserverマーカ以前をsearch行、以後をnameserver行として出力する |

### プログラム呼び出し階層図

```
bsdinstall auto (usr.sbin/bsdinstall/scripts/auto)
    |
    +-- bsdinstall netconfig (usr.sbin/bsdinstall/scripts/netconfig)
           |
           +-- [IPv4/IPv6設定処理...]
           |
           +-- resolv.conf読み取り (行160-188)
           +-- bsddialog --mixedform "Resolver Configuration" (行226-232)
           +-- awk パーサ (行236-259) --> resolv.conf書き込み
           +-- mv ._rc.conf.net rc.conf.net (行261)
```

### データフロー図

```
[入力]                       [処理]                          [出力]

$BSDINSTALL_TMPETC/
  resolv.conf (既存) -----> シェル while read -----> SEARCH, IP4_*, IP6_*
                                                          |
                                                          v
                                                    RESOLV変数構築
                                                    (IPv4/IPv6対応)
                                                          |
                                                          v
ユーザ入力 --------------> bsddialog mixedform           |
  Search domain                  |                        |
  DNS #1, #2                     v                        |
                            awk パーサ ---------> $BSDINSTALL_TMPETC/
                                                    resolv.conf (新規)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | ソース | ネットワーク設定メインスクリプト（DNS設定画面含む） |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | インストーラメインスクリプト。netconfigを呼び出す |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfigフレームワークの共通サブルーチン |
| resolv.conf | `$BSDINSTALL_TMPETC/resolv.conf` | 設定 | DNS設定の入出力対象ファイル |
| rc.conf.net | `$BSDINSTALL_TMPETC/rc.conf.net` | 設定 | ネットワーク設定の確定ファイル |
