# 画面設計書 13-ミラーサイト選択画面

## 概要

本ドキュメントは、FreeBSD bsdinstallインストーラにおけるミラーサイト選択画面の設計書である。配布ファイルをダウンロードするミラーサイトを世界各国のサーバ一覧から選択する画面について記述する。

### 本画面の処理概要

この画面では、FreeBSDの配布ファイル（base.txz、kernel.txz等）をダウンロードするためのミラーサイトを選択する。Main Site（GeoDNS）をはじめ、世界各国のCommunityミラーがリスト表示され、ユーザは最適なサイトを選択できる。

**業務上の目的・背景**：ネットワークインストールでは配布ファイルのダウンロードが必要であり、ユーザの地理的位置に近いミラーサイトを選択することでダウンロード速度を最適化できる。Main SiteはGeoDNSにより自動的に最寄りのミラーへ誘導されるが、特定のミラーを指定したい場合やGeoDNSが正しく機能しない環境のために個別ミラー選択が可能である。

**画面へのアクセス方法**：autoスクリプトの`fetchmissingdists`から呼び出される。配布ファイルがローカルに存在せずネットワークからの取得が必要な場合に表示される。

**主要な操作・処理内容**：
1. 世界各国のミラーサイト一覧をメニュー形式で表示する（約47サイト）
2. ユーザがミラーサイトを選択する、または「Other」ボタンでカスタムURL入力画面へ遷移する
3. 選択されたミラーURLとFreeBSDのリリースバージョン・アーキテクチャからダウンロードURLを構築する
4. 構築されたURLを `BSDINSTALL_DISTSITE` 環境変数にエクスポートする

**画面遷移**：
- 遷移元：autoスクリプトのfetchmissingdists処理
- 遷移先（OK）：配布ファイルダウンロード画面（No.18）へ進む
- 遷移先（Other）：カスタムミラーURL入力画面（No.14）へ遷移する
- キャンセル時：終了コード1で終了

**権限による表示制御**：権限による表示制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 91 | libfetch | 主機能 | 配布ファイルダウンロード先ミラーサイトURLの選択・BSDINSTALL_DISTSITE設定 |
| 74 | パッケージ管理支援 | 補助機能 | リリースバージョンに基づくダウンロードURL生成 |

## 画面種別

メニュー選択

## URL/ルーティング

TUIベースのbsddialogインターフェース。URLは存在しない。
- 呼び出し：`bsdinstall mirrorselect`
- 実体スクリプト：`usr.sbin/bsdinstall/scripts/mirrorselect`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 初期値 | 説明 |
|--------|--------|------|------|--------|------|
| ミラーサイト | 入力（選択） | メニュー選択 | はい | なし | ミラーサイトURLを選択 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| バックタイトル | 画面上部 | "$OSNAME Installer" |
| タイトル | ダイアログタイトル | "Mirror Selection" |
| 説明文 | メニュー上部 | ミラーサイト選択の説明。Main SiteのGeoDNS説明とCommunity Mirrorの注意事項 |
| ミラーURL | メニュー項目左側 | 各ミラーサイトのURL（http:// または ftp://） |
| ミラー説明 | メニュー項目右側 | 国名・番号・IPv6対応状況等 |

主なミラーサイト：
- http://ftp.freebsd.org - Main Site (GeoDNS, HTTP)
- ftp://ftp.freebsd.org - Main Site (GeoDNS, FTP)
- 各国ミラー（Australia, Austria, Brazil, Bulgaria, Czech Republic, Denmark, Finland, France, Germany, Greece, Japan, Korea, Latvia, Netherlands, New Zealand, Norway, Poland, Russia, Slovenia, South Africa, Sweden, Taiwan, UK, Ukraine, USA）

## イベント仕様

### 1-OK（確定）ボタン押下

1. 選択されたミラーURLを取得する
2. `uname -r` からリリースバージョンを取得し、`-p*` サフィックスを除去する（行94-95）
3. バージョンに応じてリリースディレクトリを決定する：ALPHA/CURRENT/STABLE/PRERELEASEなら`snapshots`、それ以外は`releases`（行97-104）
4. `{ミラーURL}/pub/FreeBSD/{reldir}/{uname -m}/{uname -p}/{バージョン}` 形式でBSDINSTALL_DISTSITEを構築する（行106）
5. BSDINSTALL_DISTSITEをエクスポートし、stderrに出力する（行126-127）

### 2-Other（Extraボタン）押下

カスタムミラーURL入力画面（No.14）のダイアログを表示する。デフォルト値として構築済みのBSDINSTALL_DISTSITEがプリセットされる。

### 3-Cancel/ESCボタン押下

終了コード1で終了する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| OK/Other確定 | 環境変数BSDINSTALL_DISTSITE | SET | ダウンロードURLの設定 |

### テーブル別更新項目詳細

ファイルへの永続的な書き込みは行わない。環境変数のエクスポートのみ。

## メッセージ仕様

| 種別 | 条件 | メッセージ |
|------|------|-----------|
| 情報 | メニュー表示時 | ミラーサイト選択の説明文（Main SiteのGeoDNS説明、Community Mirrorの注意） |

## 例外処理

| 条件 | 動作 |
|------|------|
| Cancel/ESC押下 | 終了コード1で終了 |
| bsddialogエラー | 終了コード1で終了 |

## 備考

- Main SiteはGeoDNSを使用しており、HTTP/FTPの2種類が提供される
- GeoDNSにより自動的に最寄りのミラーへ誘導されるため、通常はMain Siteの選択が推奨される
- Community Mirrorはbase distribution kits以上を提供していない場合がある
- リリースバージョンに応じてダウンロードパスが `releases` または `snapshots` に自動切替される
- メニューは最大16行表示（行42のbsddialog引数）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mirrorselect | `usr.sbin/bsdinstall/scripts/mirrorselect` | MIRROR変数（選択URL）、_UNAME_R変数（リリースバージョン）、BSDINSTALL_DISTSITE変数（最終URL）の関係を理解する |

**読解のコツ**: bsddialogの`--menu`コマンドは `キー "説明"` のペアでメニュー項目を指定する。`--extra-button`で「Other」ボタンが追加される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mirrorselect | `usr.sbin/bsdinstall/scripts/mirrorselect` | スクリプト全体がエントリーポイント |

**主要処理フロー**:
1. **行38-92**: bsddialog menuによるミラーサイト選択ダイアログの表示。約47のミラーサイトをリスト表示
2. **行94-95**: uname -rからリリースバージョンを取得し、パッチレベルサフィックスを除去
3. **行97-104**: バージョン文字列に基づくリリースディレクトリの決定（releases/snapshots）
4. **行106**: BSDINSTALL_DISTSITEのURL構築
5. **行108-124**: ボタン押下結果に応じた分岐処理（OK/Other/Cancel）
6. **行115-123**: Other選択時のカスタムURL入力ダイアログ表示

### プログラム呼び出し階層図

```
bsdinstall auto (usr.sbin/bsdinstall/scripts/auto)
    |
    +-- fetchmissingdists
           |
           +-- bsdinstall mirrorselect (usr.sbin/bsdinstall/scripts/mirrorselect)
                  |
                  +-- bsddialog --menu (ミラー選択)
                  +-- bsddialog --inputbox (Other選択時)
                  +-- uname -r / uname -m / uname -p (URL構築)
```

### データフロー図

```
[入力]                       [処理]                          [出力]

ユーザ選択
  ミラーサイト ----------> bsddialog menu ---------> MIRROR変数
                                                          |
uname -r ----------------> バージョン判定 ---------> RELDIR (releases/snapshots)
uname -m ----+                                            |
uname -p ----+-----------> URL構築 -----------------> BSDINSTALL_DISTSITE
                                                          |
                                                          v
                                                    export + stderr出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mirrorselect | `usr.sbin/bsdinstall/scripts/mirrorselect` | ソース | ミラーサイト選択・カスタムURL入力のメインスクリプト |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | fetchmissingdists経由でmirrorselectを呼び出す |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfigフレームワークの共通サブルーチン |
