# 画面設計書 14-カスタムミラーURL入力画面

## 概要

本ドキュメントは、FreeBSD bsdinstallインストーラにおけるカスタムミラーURL入力画面の設計書である。ミラーサイト選択画面で「Other」を選択した場合に表示される、任意のダウンロードURLを手動入力する画面について記述する。

### 本画面の処理概要

この画面では、ミラーサイト選択画面のプリセット一覧にないカスタムURLを手動で入力する。社内ミラーやローカルリポジトリ等、標準リストに含まれないダウンロード元を指定できる。

**業務上の目的・背景**：プリセットのミラーサイト一覧にない独自のミラーサーバやローカルリポジトリを使用したい場合に、カスタムURLを指定するための画面である。企業内ネットワークでの閉域インストールや、テスト用ビルドサーバからの配布ファイル取得などのユースケースに対応する。

**画面へのアクセス方法**：ミラーサイト選択画面（No.13）で「Other」ボタン（Extra Button）を押下した場合に遷移する。

**主要な操作・処理内容**：
1. デフォルト値としてリリースバージョン・アーキテクチャに基づく標準URLがプリセットされる
2. ユーザがURLを編集または完全に書き換える
3. 確定されたURLが `BSDINSTALL_DISTSITE` にセットされる

**画面遷移**：
- 遷移元：ミラーサイト選択画面（No.13）の「Other」ボタン
- 遷移先（OK）：配布ファイルダウンロード画面（No.18）へ進む
- キャンセル時：ミラーサイト選択画面（No.13）に戻る（exec $0で再実行）

**権限による表示制御**：権限による表示制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 91 | libfetch | 主機能 | カスタムミラーサイトURLの手動入力・設定処理 |

## 画面種別

入力ダイアログ（inputbox）

## URL/ルーティング

TUIベースのbsddialogインターフェース。URLは存在しない。
- 呼び出し：ミラーサイト選択画面内の分岐処理
- 実体スクリプト：`usr.sbin/bsdinstall/scripts/mirrorselect`（行114-123）

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 初期値 | 説明 |
|--------|--------|------|------|--------|------|
| ミラーURL | 入力 | テキスト | はい | 自動構築された標準URL | ダウンロード元の完全URL |

初期値の形式：`{最初に選択されたミラー}/pub/FreeBSD/{releases|snapshots}/{arch}/{cpu}/{version}`

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| バックタイトル | 画面上部 | "$OSNAME Installer" |
| タイトル | ダイアログタイトル | "Mirror Selection" |
| プロンプト | 入力フィールド上 | "Please enter the URL to an alternate $OSNAME mirror:" |
| URLフィールド | 入力フィールド | 幅74文字のテキスト入力 |

## イベント仕様

### 1-OK（確定）ボタン押下

1. 入力されたURLがBSDINSTALL_DISTSITEに設定される
2. 環境変数としてエクスポートされ、stderrに出力される
3. 配布ファイルのダウンロード処理へ進む

### 2-Cancel（キャンセル）ボタン押下

mirrorselectスクリプトが `exec $0 $@` で自身を再実行し、ミラーサイト選択画面に戻る（行122）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| OK押下 | 環境変数BSDINSTALL_DISTSITE | SET | カスタムURLの設定 |

### テーブル別更新項目詳細

ファイルへの永続的な書き込みは行わない。環境変数のエクスポートのみ。

## メッセージ仕様

| 種別 | 条件 | メッセージ |
|------|------|-----------|
| プロンプト | ダイアログ表示時 | "Please enter the URL to an alternate $OSNAME mirror:" |

## 例外処理

| 条件 | 動作 |
|------|------|
| Cancel押下 | exec $0でmirrorselectスクリプトを再実行 |

## 備考

- 入力フィールドの幅は74文字に設定されている（行119）
- デフォルト値は直前のミラー選択で構築されたBSDINSTALL_DISTSITEが使用される
- URLの妥当性チェックはこの画面では行われない（ダウンロード時にlibfetchがエラーを返す）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mirrorselect | `usr.sbin/bsdinstall/scripts/mirrorselect` | BSDINSTALL_DISTSITE変数がデフォルト値として使用される仕組みを理解する |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mirrorselect | `usr.sbin/bsdinstall/scripts/mirrorselect` | 行114-123がカスタムURL入力の処理。BSDDIALOG_EXTRAの分岐内で実行される |

**主要処理フロー**:
1. **行114**: BSDDIALOG_EXTRAケースに入る（Other選択時）
2. **行115-121**: bsddialog --inputboxでURL入力ダイアログを表示
3. **行119**: デフォルト値として"$BSDINSTALL_DISTSITE"がプリセットされる
4. **行122**: Cancelの場合exec $0で再実行

### プログラム呼び出し階層図

```
bsdinstall mirrorselect (usr.sbin/bsdinstall/scripts/mirrorselect)
    |
    +-- bsddialog --menu (ミラー選択、No.13)
    |      |
    |      +-- [Other押下]
    |             |
    |             +-- bsddialog --inputbox (カスタムURL入力、本画面)
    |
    +-- export BSDINSTALL_DISTSITE
```

### データフロー図

```
[入力]                       [処理]                          [出力]

BSDINSTALL_DISTSITE
  (デフォルト値) ---------> bsddialog inputbox -------> BSDINSTALL_DISTSITE
                                 ^                        (更新値)
ユーザ入力 ---------------------|                             |
  カスタムURL                                                 v
                                                        export + stderr
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mirrorselect | `usr.sbin/bsdinstall/scripts/mirrorselect` | ソース | ミラー選択・カスタムURL入力の統合スクリプト |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | fetchmissingdists経由での呼び出し元 |
