# 画面設計書 15-パーティションモード選択画面

## 概要

本ドキュメントは、FreeBSD bsdinstallインストーラにおけるパーティションモード選択画面の設計書である。インストール先ディスクのパーティション方式（Auto ZFS / Auto UFS / Manual / Shell）を選択する画面について記述する。

### 本画面の処理概要

この画面では、ディスクパーティションの設定方式を4つ（アーキテクチャによっては3つ）の選択肢から選ぶ。選択結果に応じて後続の詳細設定画面が異なる。

**業務上の目的・背景**：FreeBSDのインストールにおいてディスクパーティションはシステムの基盤となる重要な設定項目である。ZFS（高機能ファイルシステム）、UFS（伝統的ファイルシステム）、手動設定（上級者向け）、シェル（完全手動）の4つの方式を提供することで、初心者から上級者まで幅広いユーザのニーズに対応する。ZFSオプションはamd64/arm64/i386/riscvアーキテクチャでのみ表示される。

**画面へのアクセス方法**：autoスクリプトのメインフロー内で、ネットワーク設定および配布セット選択の完了後に自動的に表示される。`$PATH_FSTAB`ファイルの初期化後に実行される。

**主要な操作・処理内容**：
1. 現在のアーキテクチャ（uname -m）を判定し、ZFSブート対応アーキテクチャであればZFSオプションを追加する
2. 既知のハードウェア互換性問題（Lenovo ThinkPad、Dell Latitude等）を検出し、ワークアラウンドの適用を確認する
3. メニューからパーティション方式を選択する
4. 選択結果に応じて後続処理（zfsboot/autopart/partedit/sh）を呼び出す

**画面遷移**：
- 遷移元：ネットワーク/オフラインインストール選択画面（No.4）または配布セット選択画面（No.5）
- 遷移先（Auto ZFS）：ZFSブート設定画面（No.16）
- 遷移先（Auto UFS）：UFS自動パーティション処理
- 遷移先（Manual）：手動パーティション編集画面（No.17）
- 遷移先（Shell）：シェルによる手動パーティション設定
- キャンセル時：exit 1でインストーラが終了

**権限による表示制御**：ZFSオプションはamd64/arm64/i386/riscvアーキテクチャでのみ表示される。その他のアーキテクチャではAuto UFS/Manual/Shellの3択となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | GEOMストレージフレームワーク | 主機能 | Auto(ZFS)/Auto(UFS)/Manual/Shellの4方式からパーティションモードを選択する処理 |
| 12 | ZFS | 遷移先機能 | ZFS選択時のzfsboot画面への遷移 |
| 11 | UFS/FFS | 遷移先機能 | UFS選択時のautopart処理への遷移 |

## 画面種別

メニュー選択

## URL/ルーティング

TUIベースのbsddialogインターフェース。URLは存在しない。
- 呼び出し：autoスクリプト内（行387-393）
- 実体スクリプト：`usr.sbin/bsdinstall/scripts/auto`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 初期値 | 説明 |
|--------|--------|------|------|--------|------|
| パーティションモード | 入力（選択） | メニュー選択 | はい | なし | パーティション方式の選択 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| バックタイトル | 画面上部 | "$OSNAME Installer" |
| タイトル | ダイアログタイトル | "Partitioning" |
| メニュー説明 | メニュー上部 | "How would you like to partition your disk?" |
| Auto (ZFS) | メニュー項目 | "Guided Root-on-ZFS"（amd64/arm64/i386/riscvのみ） |
| Auto (UFS) | メニュー項目 | "Guided UFS Disk Setup" |
| Manual | メニュー項目 | "Manual Disk Setup (experts)" |
| Shell | メニュー項目 | "Open a shell and partition by hand" |

各メニュー項目にはitem-helpが付与されており、選択時に追加のヘルプテキストが表示される。

## イベント仕様

### 1-Auto (ZFS) 選択

1. `bsdinstall zfsboot` を実行し、ZFSブート設定画面（No.16）へ遷移する（行397）
2. 失敗時は `error "ZFS setup failed"` でエラーダイアログを表示
3. 成功後に `bsdinstall mount` でファイルシステムをマウントする（行398）

### 2-Auto (UFS) 選択

1. `bsdinstall autopart` を実行し、UFS自動パーティション処理を行う（行401）
2. 失敗時は `error "Partitioning error"` でエラーダイアログを表示
3. 成功後に `bsdinstall mount` でファイルシステムをマウントする（行402）

### 3-Manual 選択

1. `bsdinstall partedit` を実行し、手動パーティション編集画面（No.17）へ遷移する（行411-416）
2. デバッグログファイルがある場合はBSDINSTALL_LOG環境変数を設定して渡す
3. 成功後に `bsdinstall mount` でファイルシステムをマウントする（行417）

### 4-Shell 選択

1. 画面をクリアし、パーティション手動設定の案内メッセージを表示する（行405-406）
2. シェル（sh）を起動する（行407）
3. ユーザがexitした後、`bsdinstall mount_aux` で補助ファイルシステムをマウントする（行408）

### 5-Cancel/ESC

exit 1でインストーラが終了する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示前 | $PATH_FSTAB | TRUNCATE | fstabファイルの初期化（行271-272） |
| 画面表示前 | bsdinstall-esps | TRUNCATE | ESPリストの初期化（行182） |

### テーブル別更新項目詳細

本画面自体はデータベースやファイルへの書き込みを行わない。後続のパーティション設定画面が書き込みを行う。

## メッセージ仕様

| 種別 | 条件 | メッセージ |
|------|------|-----------|
| エラー | ZFS設定失敗 | "ZFS setup failed" |
| エラー | パーティション設定失敗 | "Partitioning error" |
| エラー | マウント失敗 | "Failed to mount filesystem" |
| エラー | 補助FSマウント失敗 | "Failed to mount auxiliary filesystems" |
| エラー | 不明モード選択 | "Unknown partitioning mode" |
| 情報 | Shell選択時 | パーティション手動設定の案内（BSDINSTALL_CHROOT、PATH_FSTAB等のパス情報） |

## 例外処理

| 条件 | 動作 |
|------|------|
| Cancel/ESC押下 | exit 1でインストーラ終了 |
| パーティション設定失敗 | error関数によるリスタート/終了選択ダイアログ表示 |
| マウント失敗 | error関数によるリスタート/終了選択ダイアログ表示 |

## 備考

- ZFSオプションはamd64/arm64/i386/riscvアーキテクチャでのみメニューに追加される（行376-385）
- 画面表示前に既知のハードウェア互換性問題の検出が行われる：Lenovo ThinkPad X220/T420/T520/W520/X1、Dell Latitude E6330/E7440/E7240/Precision Tower 5810、HP ProBook 4330s、Intel DP965LT/D510MO、Acer Veriton M6630G
- ワークアラウンドはZFSBOOT_PARTITION_SCHEMEとWORKAROUND_*環境変数で制御される
- item-helpオプションにより、各メニュー項目を選択すると追加の説明テキストが表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行47-69のメッセージ定数（msg_auto_zfs, msg_auto_ufs, msg_manual, msg_shell）を理解する |

**読解のコツ**: PMODESシェル変数にメニュー項目が文字列として構築される。アーキテクチャ判定によりZFSオプションが先頭に挿入される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行369-422がパーティションモード選択の処理ブロック |

**主要処理フロー**:
1. **行271-272**: PATH_FSTABの初期化
2. **行280-367**: ハードウェアワークアラウンド検出（SMBIOS情報に基づく）
3. **行369-385**: PMODESメニュー項目の構築（アーキテクチャ判定付き）
4. **行387-393**: bsddialog menuによるパーティションモード選択ダイアログ表示
5. **行395-422**: 選択結果に応じたcase分岐と後続処理の呼び出し

#### Step 3: ハードウェアワークアラウンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行280-367のworkround処理。kenv経由でSMBIOS情報を取得し、既知のハードウェア問題に対するワークアラウンドを適用する |

### プログラム呼び出し階層図

```
bsdinstall auto (usr.sbin/bsdinstall/scripts/auto)
    |
    +-- [ハードウェアワークアラウンド検出] (行280-367)
    |
    +-- bsddialog --menu "Partitioning" (行387-393)
           |
           +-- [Auto ZFS] --> bsdinstall zfsboot --> bsdinstall mount
           +-- [Auto UFS] --> bsdinstall autopart --> bsdinstall mount
           +-- [Manual]   --> bsdinstall partedit --> bsdinstall mount
           +-- [Shell]    --> sh --> bsdinstall mount_aux
```

### データフロー図

```
[入力]                       [処理]                          [出力]

uname -m -----------------> アーキテクチャ判定 -------> PMODES構築
                                                          |
kenv smbios.* -----------> ハードウェア検出 --------> WORKAROUND_*変数
                                                          |
ユーザ選択 --------------> bsddialog menu ----------> PARTMODE変数
                                                          |
                                                          v
                                                    後続処理呼び出し
                                                    (zfsboot/autopart/
                                                     partedit/sh)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | インストーラメインスクリプト（パーティション選択含む） |
| zfsboot | `usr.sbin/bsdinstall/scripts/zfsboot` | ソース | ZFSブート設定（Auto ZFS選択時の遷移先） |
| partedit.c | `usr.sbin/bsdinstall/partedit/partedit.c` | ソース | 手動パーティション編集（Manual選択時の遷移先） |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfigフレームワークの共通サブルーチン |
| dialog.subr | `/usr/share/bsdconfig/dialog.subr` | ライブラリ | ダイアログ関連のサブルーチン |
