# 画面設計書 19-チェックサム検証画面

## 概要

本ドキュメントは、FreeBSD bsdinstallインストーラにおけるチェックサム検証画面の設計書である。ダウンロードした配布ファイルのSHA256チェックサムをMANIFESTファイルと照合し、整合性を検証する画面について記述する。

### 本画面の処理概要

この画面では、ダウンロード済みの配布ファイル（base.txz、kernel.txz等）のSHA256チェックサムを計算し、MANIFESTファイルに記録されたチェックサムと比較する。検証はバックグラウンドで順次実行され、mixedgaugeプログレスバーで進捗を表示する。

**業務上の目的・背景**：ネットワーク経由でダウンロードした配布ファイルが破損や改竄されていないことを保証するために、チェックサム検証が必要である。本画面はダウンロード直後に自動実行され、インストール前にデータの整合性を確認する重要なステップである。

**画面へのアクセス方法**：autoスクリプトのインストール実行フロー内で、配布ファイルのダウンロード完了後に `bsdinstall checksum` コマンドで自動的に呼び出される。MANIFESTファイルが存在しない場合はスキップされる（行28）。

**主要な操作・処理内容**：
1. MANIFESTファイルの存在を確認する（存在しない場合はスキップ）
2. DISTRIBUTIONS変数の各配布ファイルについて以下を繰り返す：
   a. mixedgaugeプログレスバーを更新し、現在処理中のファイルを「In Progress」に設定する
   b. sha256コマンドでファイルのチェックサムを計算する
   c. awkでMANIFESTファイルからの期待値と比較する
   d. 一致すれば「Done」、MANIFESTに不在なら「N/A」、不一致なら「Failed」に設定する
3. チェックサム不一致の場合はエラーダイアログを表示して終了する

**画面遷移**：
- 遷移元：配布ファイルダウンロード画面（No.18）完了後
- 遷移先（成功）：配布ファイル展開画面（No.20）
- 遷移先（失敗）：エラーメッセージ表示後、exit 1でインストーラエラーハンドリングへ

**権限による表示制御**：権限による表示制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | パッケージ管理支援 | 主機能 | sha256によるダウンロード済み配布ファイルのチェックサム検証処理 |

## 画面種別

進捗表示（mixedgauge）

## URL/ルーティング

TUIベースのbsddialogインターフェース。URLは存在しない。
- 呼び出し：`bsdinstall checksum`
- 実体スクリプト：`usr.sbin/bsdinstall/scripts/checksum`

## 入出力項目

本画面にユーザ入力項目はない。進捗表示のみ。

| 項目名 | 入出力 | 型 | 必須 | 初期値 | 説明 |
|--------|--------|------|------|--------|------|
| DISTRIBUTIONS | 入力（環境変数） | 文字列 | はい | - | 検証対象の配布ファイル一覧 |
| BSDINSTALL_DISTDIR | 入力（環境変数） | 文字列 | はい | - | 配布ファイルのディレクトリ |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| バックタイトル | 画面上部 | "$OSNAME Installer" |
| タイトル | ダイアログタイトル | "Checksum Verification" |
| メッセージ | mixedgauge内 | "Verifying checksums of selected distributions." |
| 全体進捗バー | mixedgauge | 全ファイルの検証進捗率 |
| 個別ファイル状態 | mixedgaugeミニバー | 各ファイルのステータス（Pending/In Progress/Done/Failed/N/A） |

## イベント仕様

### 1-チェックサム検証処理（自動実行）

1. DISTRIBUTIONS変数の各ファイルについてループする（行40）
2. 当該ファイルのステータスを「In Progress」（-8）に設定する（行42）
3. mixedgaugeプログレスバーを更新する（行48-50）
4. `sha256 -q` でチェックサムを計算する（行52）
5. awkでMANIFESTの該当行と比較する（行53-61）：
   - 一致（exit 0）：ステータスを「Done」（-3）に設定
   - ファイル不在（exit 1）：ステータスを「N/A」（-7）に設定
   - 不一致（exit 2）：ステータスを「Failed」（-2）に設定
6. 不一致の場合、バージョンに応じたエラーメッセージを表示して終了する

## データベース更新仕様

本画面はファイルの読み取りのみを行い、書き込みは行わない。

## メッセージ仕様

| 種別 | 条件 | メッセージ |
|------|------|-----------|
| 情報 | 検証中 | "Verifying checksums of selected distributions." |
| エラー | チェックサム不一致（開発版） | "The checksum for {dist} does not match. It may have become corrupted, or it may be from a newer version of $OSNAME. Please check for a newer snapshot." |
| エラー | チェックサム不一致（リリース版） | "The checksum for {dist} does not match. It may have become corrupted, and should be redownloaded." |

## 例外処理

| 条件 | 動作 |
|------|------|
| MANIFESTファイル不在 | 検証をスキップし正常終了（exit 0） |
| チェックサム不一致 | エラーメッセージ表示後exit 1 |
| MANIFESTにファイルが記載されていない | N/Aステータスで継続 |

## 備考

- MANIFESTファイルが存在しない場合、チェックサム検証は完全にスキップされる（行28）
- ALPHA/CURRENT/STABLE/PRERELEASEバージョンでは、チェックサム不一致時のエラーメッセージが異なる（新しいスナップショットの確認を促す）
- bsddialog mixedgaugeのステータス値：-8=In Progress、-3=Done、-7=N/A、-2=Failed、-11=Pending
- dist_to_statusvar関数でファイル名をシェル変数名に変換する（ドットやハイフンを安全な形式に変換）
- 進捗率は `100 / ファイル数` 刻みで更新される（bcコマンドで計算）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | checksum | `usr.sbin/bsdinstall/scripts/checksum` | dist_to_statusvar関数（行33-37）によるファイル名→変数名変換を理解する。ドット→_dot_、ハイフン→_dash_に変換される |

**読解のコツ**: bsddialog mixedgaugeはシェルスクリプトから呼ぶ場合、`--mixedgauge` に続いてメッセージ、高さ、幅、全体進捗率、そして `-- ラベル ステータス` のペアを渡す。ステータスの負数値は特別な意味を持つ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | checksum | `usr.sbin/bsdinstall/scripts/checksum` | スクリプト全体（88行）がエントリーポイント |

**主要処理フロー**:
1. **行28**: MANIFESTファイル存在チェック（不在なら即座にexit 0）
2. **行33-37**: dist_to_statusvar関数の定義
3. **行40-85**: 配布ファイルループ（DISTRIBUTIONS変数の各ファイル）
4. **行52**: sha256 -qでチェックサム計算
5. **行53-61**: awkでMANIFESTとの照合
6. **行63-84**: 結果判定とエラー処理

### プログラム呼び出し階層図

```
bsdinstall auto (usr.sbin/bsdinstall/scripts/auto)
    |
    +-- bsdinstall checksum (usr.sbin/bsdinstall/scripts/checksum)
           |
           +-- [MANIFESTチェック]
           +-- [配布ファイルループ]
                  +-- sha256 -q $BSDINSTALL_DISTDIR/$dist
                  +-- awk (MANIFEST照合)
                  +-- bsddialog --mixedgauge (進捗更新)
                  +-- [不一致時] bsddialog --msgbox (エラー表示)
```

### データフロー図

```
[入力]                       [処理]                          [出力]

$BSDINSTALL_DISTDIR/
  MANIFEST ----------------> awk (期待値取得) -----> チェックサム比較
  {dist} ファイル ---------> sha256 -q ----------->      |
                                                          v
                                                    ステータス判定
                                                    (Done/N/A/Failed)
                                                          |
                                                          v
                                                    bsddialog mixedgauge
                                                    (進捗表示)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| checksum | `usr.sbin/bsdinstall/scripts/checksum` | ソース | チェックサム検証のメインスクリプト（88行） |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | checksumの呼び出し元 |
| MANIFEST | `$BSDINSTALL_DISTDIR/MANIFEST` | データ | チェックサム期待値を含む配布マニフェストファイル |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfigフレームワークの共通サブルーチン |
