# 画面設計書 2-ホスト名設定画面

## 概要

本ドキュメントは、FreeBSD bsdinstall インストーラにおける「ホスト名設定画面」の設計仕様を記述する。本画面はキーマップ選択画面の次に表示され、インストール先マシンのホスト名を設定する。

### 本画面の処理概要

本画面は、FreeBSDインストール時にマシンのホスト名を入力するためのTUI画面である。inputboxダイアログを使用して、ユーザにホスト名の入力を求める。

**業務上の目的・背景**：ネットワーク上でマシンを一意に識別するためにホスト名が必要である。特に管理されたネットワーク環境では、ネットワーク管理者から割り当てられた適切なホスト名を設定する必要がある。インストール時にホスト名を設定することで、後続のネットワーク設定やシステム設定が正しく機能する基盤を構築する。

**画面へのアクセス方法**：キーマップ選択画面の次に自動的に表示される。autoスクリプト198行目で`bsdinstall hostname`として呼び出される。環境変数`BSDINSTALL_SKIP_HOSTNAME`が設定されている場合は省略される。

**主要な操作・処理内容**：
1. ホスト名の入力：inputboxダイアログにホスト名を入力する。初期値として現在のhostname値が表示される
2. 設定の保存：入力されたホスト名が`$BSDINSTALL_TMPETC/rc.conf.hostname`に`hostname="入力値"`として保存される
3. 即時適用：`BSDINSTALL_CONFIGCURRENT`が設定されている場合、`hostname -s`コマンドで即座にホスト名が変更される

**画面遷移**：
- 遷移元：キーマップ選択画面
- 遷移先：インストール種別選択画面（正常終了時）
- エラー時：error()関数によりリスタート/終了選択ダイアログが表示される

**権限による表示制御**：特になし。インストーラコンテキストでrootとして実行される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | パッケージ管理支援 | 主機能 | bsdinstallフレームワークによるホスト名入力・rc.confへの保存処理 |

## 画面種別

入力（ホスト名入力フォーム画面）

## URL/ルーティング

TUIベースのインストーラのため、URLは存在しない。`bsdinstall hostname`として呼び出される。実体は`usr.sbin/bsdinstall/scripts/hostname`シェルスクリプトである。

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 | 初期値 | 必須 |
|--------|----------|-----|------|--------|------|
| HOSTNAME | 入力/出力 | 文字列 | マシンのホスト名 | 現在のhostname値（41行目） | はい |
| HOSTNAMEFILE | 出力 | ファイルパス | ホスト名設定の保存先 | $BSDINSTALL_TMPETC/rc.conf.hostname | - |

## 表示項目

| 項目名 | 説明 | 表示形式 |
|--------|------|----------|
| タイトル | "Set Hostname" | ダイアログタイトル |
| バックタイトル | "$OSNAME Installer" | ダイアログバックタイトル |
| プロンプト | ホスト名入力を促すメッセージ（管理ネットワークの場合は管理者に確認するよう案内） | テキスト |
| ホスト名入力欄 | ホスト名入力フィールド | inputbox |

## イベント仕様

### 1-ホスト名入力確定（OK）

OKボタン押下時、入力されたホスト名がHOSTNAME変数に格納される（102行目）。f_eval_catch経由でHOSTNAMEFILEに`hostname="入力値"`が書き込まれる（108-109行目）。BSDINSTALL_CONFIGCURRENTが設定されている場合、`hostname -s`で即座に適用される（115-118行目）。

### 2-キャンセル

本画面にはCancelボタンがない（--no-cancel、85行目）。ただし、DIALOG_CANCELが返された場合は`exit 1`で終了する（103行目）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| OK押下 | $BSDINSTALL_TMPETC/rc.conf.hostname | WRITE | `hostname="入力値"`を書き込み |

### テーブル別更新項目詳細

#### $BSDINSTALL_TMPETC/rc.conf.hostname

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| WRITE | hostname | ユーザが入力したホスト名 | 例: `hostname="myhost"` |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| msg_please_choose_a_hostname | 説明 | "Please choose a hostname for this machine.\n\nIf you are running on a managed network, please ask\nyour network administrator for an appropriate name." | 画面表示時に常時 |
| msg_set_hostname | タイトル | "Set Hostname" | 画面タイトルとして常時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| hostnameスクリプトが異常終了 | autoスクリプト198行目のerror関数が呼ばれ、リスタート/終了ダイアログが表示される |
| HOSTNAMEFILE書き込み失敗 | f_eval_catchの戻り値が非ゼロとなり、そのまま終了コードとして返却される |

## 備考

- `BSDINSTALL_SKIP_HOSTNAME`が設定されている場合、autoスクリプト198行目の条件分岐で本画面は表示されない
- Cancelボタンは`--no-cancel`オプションにより無効化されているため、ユーザは必ずホスト名を入力して続行する必要がある
- 空のホスト名でもOKで進行可能（バリデーションは行われない）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | hostname | `usr.sbin/bsdinstall/scripts/hostname` | 41-46行目のデフォルト値設定（HOSTNAME、HOSTNAMEFILE変数）を理解する |

**読解のコツ**: `: ${VAR:=default}`はシェルのデフォルト値設定パターン。変数が未定義の場合のみdefaultが代入される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 198行目の`bsdinstall hostname`呼び出しと`error`関数によるエラーハンドリング |
| 2-2 | hostname | `usr.sbin/bsdinstall/scripts/hostname` | 91-120行目のMAINセクション |

**主要処理フロー**:
1. **96-97行目**: ダイアログタイトル・バックタイトルの初期化
2. **102行目**: dialog_hostname関数呼び出しでユーザ入力取得
3. **103行目**: キャンセル時のexit 1
4. **108-109行目**: f_eval_catchでHOSTNAMEFILEへの書き込み
5. **115-118行目**: BSDINSTALL_CONFIGCURRENT時の即時適用

#### Step 3: ダイアログ表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | hostname | `usr.sbin/bsdinstall/scripts/hostname` | 70-89行目のdialog_hostname関数 |

**主要処理フロー**:
- **77-78行目**: f_dialog_inputbox_sizeでダイアログサイズ計算
- **80-88行目**: $DIALOG --inputboxでホスト名入力ダイアログ表示

### プログラム呼び出し階層図

```
auto (bsdinstall起動スクリプト)
    |
    +-- bsdinstall hostname
            |
            +-- common.subr (f_dprintf, f_include)
            +-- dialog.subr (DIALOG, f_dialog_title, f_dialog_inputbox_size)
            |
            +-- dialog_hostname()
            |      +-- f_dialog_inputbox_size (サイズ計算)
            |      +-- $DIALOG --inputbox (入力ダイアログ)
            |
            +-- f_eval_catch (HOSTNAMEFILE書き込み)
            +-- hostname -s (即時適用、条件付き)
```

### データフロー図

```
[入力]                       [処理]                           [出力]

hostname コマンド   ------>  初期値設定 (41行目)    -------->  HOSTNAME変数
    (現在のホスト名)

ユーザ入力         ------>  dialog_hostname()       -------->  HOSTNAME変数更新
                              $DIALOG --inputbox

HOSTNAME変数       ------>  f_eval_catch            -------->  $BSDINSTALL_TMPETC/
                              echo > HOSTNAMEFILE              rc.conf.hostname

HOSTNAME変数       ------>  hostname -s             -------->  システムホスト名
                            (CONFIGCURRENT時のみ)              (即時反映)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| hostname | `usr.sbin/bsdinstall/scripts/hostname` | ソース | 本画面の主スクリプト |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | インストーラメインスクリプト（呼び出し元） |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数群 |
| dialog.subr | `/usr/share/bsdconfig/dialog.subr` | ライブラリ | ダイアログ表示関数群 |
| rc.conf.hostname | `$BSDINSTALL_TMPETC/rc.conf.hostname` | 設定 | ホスト名設定保存先一時ファイル |
