# 画面設計書 21-rootパスワード設定画面

## 概要

本ドキュメントは、FreeBSD bsdinstallインストーラにおける「rootパスワード設定画面」の画面設計書である。インストール後のシステム管理アカウント（root）のパスワードを設定するための画面仕様を定義する。

### 本画面の処理概要

本画面は、FreeBSDのインストールプロセスにおいて、システム管理者（root）のパスワードを設定するパスワード入力フォーム画面である。パスワードの入力と確認入力の2フィールドを持ち、一致確認を行った上でchroot環境内のpwコマンドを用いてrootパスワードを設定する。

**業務上の目的・背景**：FreeBSDシステムのセキュリティを確保するため、インストール直後にrootアカウントのパスワードを設定する必要がある。パスワード未設定のままシステムを運用することはセキュリティ上の重大なリスクとなるため、インストールフローの中で明示的にパスワード設定を促す。ただし、セキュリティポリシーによりSSH鍵認証のみを使用する場合などに備え、スキップも可能としている。

**画面へのアクセス方法**：配布ファイルの展開とブートローダ設定が完了した後、autoスクリプト（446行目）から `bsdinstall rootpass` として呼び出される。また、最終設定メニュー画面から「Root Password」を選択することで再度アクセスできる。

**主要な操作・処理内容**：
1. パスワード入力フォームの表示（bsddialogのpasswordformウィジェット使用）
2. パスワードと確認パスワードの入力
3. 入力されたパスワードの一致確認
4. chroot環境内のpwコマンドによるrootパスワード設定
5. エラー時のメッセージ表示とリトライ

**画面遷移**：
- 遷移元：ブートローダ設定完了後（autoスクリプト）、最終設定メニュー画面（Root Password選択時）
- 遷移先：ネットワーク設定（未設定の場合）またはタイムゾーン・日付・時刻設定画面

**権限による表示制御**：特になし。インストーラはroot権限で動作するため、常に同一の表示となる。環境変数 `ROOTPASS_ENC` または `ROOTPASS_PLAIN` が設定されている場合、ダイアログを表示せず自動設定を行う。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 73 | ユーザ・グループ管理 | 主機能 | pwコマンドによるrootユーザパスワードの設定処理 |

## 画面種別

設定（パスワード入力フォーム）

## URL/ルーティング

シェルスクリプトベースのTUIアプリケーションのため、URLルーティングは存在しない。`bsdinstall rootpass` コマンドにより起動される。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| Password | 入力 | パスワード文字列 | いいえ | 32文字 | rootパスワード |
| Repeat password | 入力 | パスワード文字列 | いいえ | 32文字 | rootパスワード確認入力 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| バックタイトル | 画面上部 | "$OSNAME Installer"（例: "FreeBSD Installer"） |
| タイトル | ダイアログタイトル | "Set root password" |
| プロンプトメッセージ | ダイアログ本文 | "Please select a password for the system management account (root)" |
| エラーメッセージ | プロンプト末尾 | パスワード設定失敗時のエラーメッセージ |
| Password | フォーム行0 | パスワード入力フィールド（マスク表示） |
| Repeat password | フォーム行1 | パスワード確認入力フィールド（マスク表示） |

## イベント仕様

### 1-OKボタン押下

OKボタン押下時、以下の処理が実行される：
1. パスワードフィールドとリピートフィールドの値を読み取る
2. 両方が空の場合、エラーコード62で「The password cannot be empty」を表示しリトライ
3. パスワードが一致しない場合、エラーコード63で「The passwords do not match」を表示しリトライ
4. パスワードが一致する場合、`chroot $BSDINSTALL_CHROOT /usr/sbin/pw usermod root -h 0` にパスワードをパイプで渡す
5. pwコマンドが成功（終了コード0）の場合、画面を終了
6. pwコマンドが失敗した場合、エラーコードに応じたメッセージを表示しリトライ

### 2-Skipボタン押下

Skipボタン（cancel-label）押下時、パスワードを設定せずに画面を終了する（終了コード0）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| OKボタン押下 | $BSDINSTALL_CHROOT/etc/master.passwd | UPDATE | pwコマンドによりrootユーザのパスワードハッシュを更新 |
| OKボタン押下 | $BSDINSTALL_CHROOT/etc/pwd.db | UPDATE | pwコマンドにより自動再生成 |
| OKボタン押下 | $BSDINSTALL_CHROOT/etc/spwd.db | UPDATE | pwコマンドにより自動再生成 |

### テーブル別更新項目詳細

#### master.passwd（rootエントリ）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| UPDATE | password hash | 入力されたパスワードのハッシュ値 | pw usermod root -h 0 により設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| ERR-62 | エラー | The password cannot be empty | パスワード・確認パスワードが両方空の場合 |
| ERR-63 | エラー | The passwords do not match | パスワードと確認パスワードが不一致の場合 |
| ERR-64 | エラー | Command used incorrectly | pwコマンド使用方法エラー（EX_USAGE） |
| ERR-65 | エラー | Incorrect input data | 入力データ不正（EX_DATAERR） |
| ERR-67 | エラー | User not found | ユーザが見つからない（EX_NOUSER） |
| ERR-70 | エラー | Internal software error | 内部ソフトウェアエラー（EX_SOFTWARE） |
| ERR-71 | エラー | Operating System error detected | OS エラー検出（EX_OSERR） |
| ERR-72 | エラー | Error in a system file | システムファイルエラー（EX_OSFILE） |
| ERR-74 | エラー | I/O error | I/Oエラー（EX_IOERR） |
| ERR-77 | エラー | Insufficient permissions | 権限不足（EX_NOPERM） |
| ERR-78 | エラー | Configuration error | 設定エラー（EX_CONFIG） |
| ERR-OTHER | エラー | An unknown error occurred (code X) | 上記以外のエラーコード |

## 例外処理

- **ROOTPASS_ENC環境変数設定済み**：ダイアログを表示せず、暗号化済みパスワードを `pw usermod root -H 0` で直接設定する（自動インストール用）
- **ROOTPASS_PLAIN環境変数設定済み**：ダイアログを表示せず、平文パスワードを `pw usermod root -h 0` で直接設定する（自動インストール用）
- **pwコマンド実行失敗**：error_get_message関数によりエラーコードに応じたメッセージを生成し、ダイアログに表示してリトライを促す
- **Skipによるパスワード未設定**：rootパスワードが空のままとなる。セキュリティリスクがあるが、ユーザの意思により許容される

## 備考

- bsddialogの `--insecure` オプションにより、パスワード入力時にアスタリスクによるマスク表示が行われる（`--insecure` はマスク文字を表示するオプションで、指定しない場合は何も表示されない）
- パスワードフィールドの表示幅は17カラム目から開始し、入力幅は32文字、最大長は32文字
- username変数は "root" に固定されている
- common.subr の読み込みにより、BSDCFG_SHAREの共通関数が利用可能となる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面ではデータ構造は単純で、パスワード文字列のみが扱われる。環境変数による自動設定パスを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | rootpass | `usr.sbin/bsdinstall/scripts/rootpass` | 32-38行目：ROOTPASS_ENC/ROOTPASS_PLAIN環境変数による自動設定パス |

**読解のコツ**: シェルスクリプトの `printf '%s\n' "$var" | pw ... -h 0` パターンは、pwコマンドの標準入力からパスワードを読み取るFreeBSD固有の手法である。`-h 0` はfd 0（標準入力）からパスワードを読む指定、`-H 0` は暗号化済みハッシュを読む指定。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 446行目：`bsdinstall rootpass` の呼び出し箇所 |
| 2-2 | rootpass | `usr.sbin/bsdinstall/scripts/rootpass` | 29-30行目：common.subr読み込みによる初期化 |

**主要処理フロー**:
1. **29-30行目**: BSDCFG_SHARE/common.subr の読み込み
2. **32-38行目**: 環境変数による自動設定の判定
3. **40行目**: BSDDIALOG_OKの初期化（デフォルト値0）
4. **90-116行目**: メインループ（パスワード入力・検証・設定）

#### Step 3: エラーハンドリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | rootpass | `usr.sbin/bsdinstall/scripts/rootpass` | 42-86行目：error_get_message関数によるエラーコードからメッセージへの変換 |

**主要処理フロー**:
- **42-86行目**: error_get_message関数 - sysexits.hのエラーコードに対応するメッセージを返す
- **62行目**: パスワード空チェック（独自エラーコード62）
- **63行目**: パスワード不一致チェック（独自エラーコード63）

#### Step 4: パスワード設定処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | rootpass | `usr.sbin/bsdinstall/scripts/rootpass` | 106-112行目：パスワード検証とpwコマンド実行 |

**主要処理フロー**:
- **92-101行目**: bsddialogによるパスワードフォーム表示
- **106-112行目**: サブシェル内でのパスワード検証とpw usermod実行
- **110-111行目**: `chroot $BSDINSTALL_CHROOT /usr/sbin/pw usermod "$username" -h 0` でパスワード設定

### プログラム呼び出し階層図

```
auto (446行目: bsdinstall rootpass)
    |
    +-- rootpass
            |
            +-- common.subr (共通関数読み込み)
            |
            +-- [自動設定パス] pw -R $BSDINSTALL_CHROOT usermod root -H/-h 0
            |
            +-- [対話パス] bsddialog --passwordform (パスワードフォーム表示)
            |       |
            |       +-- サブシェル: パスワード検証
            |               |
            |               +-- chroot $BSDINSTALL_CHROOT /usr/sbin/pw usermod root -h 0
            |
            +-- error_get_message() (エラーメッセージ生成)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

ROOTPASS_ENC ──────────────> pw usermod root -H 0 ──────────> master.passwd更新
                                                               pwd.db再生成
ROOTPASS_PLAIN ────────────> pw usermod root -h 0 ──────────> spwd.db再生成

bsddialog passwordform ──> パスワード一致確認 ──> chroot pw usermod root -h 0
    Password入力               |                       |
    Repeat password入力        +-- 不一致/空 ──> エラーメッセージ表示 ──> リトライ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| rootpass | `usr.sbin/bsdinstall/scripts/rootpass` | ソース | rootパスワード設定画面のメインスクリプト |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | インストーラメインフロー（rootpass呼び出し元） |
| finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | ソース | 最終設定メニュー（rootpass再呼び出し元） |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数ライブラリ |
| pw | `/usr/sbin/pw` | コマンド | FreeBSDユーザ管理コマンド |
| master.passwd | `$BSDINSTALL_CHROOT/etc/master.passwd` | 設定 | パスワードデータベースソースファイル |
