# 画面設計書 22-タイムゾーン選択画面

## 概要

本ドキュメントは、FreeBSD bsdinstallインストーラにおける「タイムゾーン選択画面」の画面設計書である。インストール対象システムのタイムゾーンをtzsetupコマンドにより対話的に設定する画面仕様を定義する。

### 本画面の処理概要

本画面は、FreeBSDのインストールプロセスにおいて、システムのタイムゾーンを設定する画面である。chroot環境内のtzsetupコマンドを呼び出し、地域・国・タイムゾーンの階層的選択により適切なタイムゾーンを設定する。

**業務上の目的・背景**：システムの時刻管理は、ログ記録、cron実行、証明書検証、NTP同期など多くのシステム機能に影響する。正確なタイムゾーン設定はシステム運用の基盤であり、インストール時に適切に設定する必要がある。tzsetupコマンドはFreeBSD標準のタイムゾーン設定ツールであり、/usr/share/zoneinfo配下のタイムゾーンデータベースを参照する。

**画面へのアクセス方法**：autoスクリプト（452行目）から `bsdinstall time` として呼び出される。timeスクリプトの最初の処理としてtzsetupが実行される。また、最終設定メニュー画面から「Time Zone」を選択することで再度アクセスできる。環境変数 `BSDINSTALL_SKIP_TIME` が設定されている場合は省略される。

**主要な操作・処理内容**：
1. chroot環境内でtzsetupコマンドの実行（-sオプション：skip UTC question をスキップ）
2. 大陸/海洋の選択
3. 国/地域の選択
4. タイムゾーンの選択（複数タイムゾーンがある国の場合）
5. /etc/localtimeシンボリックリンクの設定

**画面遷移**：
- 遷移元：rootパスワード設定後のネットワーク設定完了後（またはネットワーク未設定判定後）、最終設定メニュー画面（Time Zone選択時）
- 遷移先：日付設定画面（No.23）

**権限による表示制御**：特になし。インストーラはroot権限で動作する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | タイマー・クロック管理 | 主機能 | tzsetupによるタイムゾーンの選択・/etc/localtime設定 |

## 画面種別

設定（階層的選択メニュー）

## URL/ルーティング

シェルスクリプトベースのTUIアプリケーションのため、URLルーティングは存在しない。`bsdinstall time` コマンドにより起動され、その最初の処理としてtzsetupが呼ばれる。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 大陸/海洋選択 | 入力 | 選択リスト | はい | Africa/America/Antarctica/Arctic/Asia/Atlantic/Australia/Europe/Indian/Pacific/UTC |
| 国/地域選択 | 入力 | 選択リスト | はい | 選択した大陸配下の国リスト |
| タイムゾーン選択 | 入力 | 選択リスト | 条件付き | 複数タイムゾーンがある国の場合のみ |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| tzsetup TUI | 画面全体 | tzsetupコマンドの標準TUI画面 |

## イベント仕様

### 1-タイムゾーン選択完了

tzsetupにより選択が完了すると、/etc/localtimeが適切なzoneinfoファイルへのシンボリックリンクとして設定される。その後、timeスクリプトはTZ環境変数を一時的にchroot先の/etc/localtimeに切り替え、後続の日付・時刻設定で正しいタイムゾーンが反映されるようにする。

### 2-キャンセル

tzsetupでキャンセルした場合、タイムゾーンは変更されない。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| タイムゾーン選択完了 | $BSDINSTALL_CHROOT/etc/localtime | UPDATE | zoneinfoファイルへのシンボリックリンク作成 |

### テーブル別更新項目詳細

#### /etc/localtime

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| SYMLINK | localtime | /usr/share/zoneinfo/{選択したタイムゾーン} | tzsetupにより自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | - | tzsetupコマンドの標準メッセージ群 | tzsetupの内部メッセージに依存 |

## 例外処理

- **tzsetupコマンド不在**：chroot環境にtzsetupが存在しない場合、コマンドエラーとなる
- **zoneinfoデータ不在**：/usr/share/zoneinfoが存在しない場合、tzsetupがエラーとなる
- **BSDINSTALL_SKIP_TIME設定時**：timeスクリプト自体が呼び出されないため、本画面も表示されない

## 備考

- tzsetupの `-s` オプションは、UTC質問（「Is this machine's CMOS clock set to UTC?」）をスキップする
- timeスクリプトはタイムゾーン選択後、TZ環境変数を一時的に変更し、日付・時刻設定で正しいタイムゾーンが適用されるようにしている（35-37行目）
- 処理完了後はTZ環境変数を元に戻す（64-68行目）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

タイムゾーン設定は/usr/share/zoneinfoディレクトリ構造に基づく。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | time | `usr.sbin/bsdinstall/scripts/time` | 34-37行目：TZ環境変数の一時切替メカニズム |

**読解のコツ**: timeスクリプトはタイムゾーン選択（tzsetup）、日付設定（calendar）、時刻設定（timebox）の3つの処理を順次実行する単一スクリプトである。本画面設計書ではtzsetup部分のみを扱う。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 452行目：`bsdinstall time` の呼び出し条件（BSDINSTALL_SKIP_TIME未設定時） |
| 2-2 | time | `usr.sbin/bsdinstall/scripts/time` | 32行目：`chroot $BSDINSTALL_CHROOT tzsetup -s` の実行 |

**主要処理フロー**:
1. **32行目**: chroot環境内でtzsetup -sを実行
2. **35-37行目**: TZ環境変数をchroot先の/etc/localtimeに設定
3. **41-48行目**: 日付設定画面（次画面）
4. **53-60行目**: 時刻設定画面（次々画面）
5. **64-68行目**: TZ環境変数を元に戻す

#### Step 3: tzsetupコマンドの動作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tzsetup | `usr.sbin/tzsetup/` | tzsetupコマンドのソース（C言語実装） |

**主要処理フロー**:
- tzsetupは/usr/share/zoneinfoのデータを使用して階層的なメニューを表示する
- -sオプションによりUTC質問をスキップする

### プログラム呼び出し階層図

```
auto (452行目: bsdinstall time)
    |
    +-- time
            |
            +-- common.subr (共通関数読み込み)
            |
            +-- chroot $BSDINSTALL_CHROOT tzsetup -s
            |       |
            |       +-- /usr/share/zoneinfo/* (タイムゾーンデータ参照)
            |       +-- /etc/localtime (シンボリックリンク更新)
            |
            +-- TZ環境変数の一時切替
            |
            +-- bsddialog --calendar (日付設定: 次画面)
            +-- bsddialog --timebox (時刻設定: 次々画面)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

/usr/share/zoneinfo/* ────> tzsetup -s ──────────────────> /etc/localtime (symlink)
ユーザの地域選択                 |
                                +-- TZ環境変数設定 ──────> $TZ = chroot先/etc/localtime
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| time | `usr.sbin/bsdinstall/scripts/time` | ソース | タイムゾーン・日付・時刻設定のメインスクリプト |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | インストーラメインフロー（time呼び出し元） |
| finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | ソース | 最終設定メニュー（time再呼び出し元） |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数ライブラリ |
| tzsetup | `usr.sbin/tzsetup/` | コマンド | FreeBSDタイムゾーン設定コマンド |
| /etc/localtime | `$BSDINSTALL_CHROOT/etc/localtime` | 設定 | タイムゾーン設定シンボリックリンク |
| zoneinfo | `/usr/share/zoneinfo/` | データ | タイムゾーンデータベース |
