# 画面設計書 23-日付設定画面

## 概要

本ドキュメントは、FreeBSD bsdinstallインストーラにおける「日付設定画面」の画面設計書である。カレンダーUIを使用してシステムの日付を設定する画面仕様を定義する。

### 本画面の処理概要

本画面は、FreeBSDのインストールプロセスにおいて、bsddialogのcalendarウィジェットを使用してシステムの日付を設定する画面である。タイムゾーン設定直後に表示され、選択したタイムゾーンに基づいた日付設定を行う。

**業務上の目的・背景**：システム時刻の正確性は、ファイルシステムのタイムスタンプ、ログ管理、セキュリティ証明書の検証、cron処理の正確な実行など、多くのシステム機能に直接影響する。NTPによる自動同期が利用できない環境（オフラインインストール等）では、手動での日付設定が唯一の手段となる。

**画面へのアクセス方法**：timeスクリプト内で、タイムゾーン選択（tzsetup）の直後に自動的に表示される（41-48行目）。最終設定メニューから「Time Zone」を選択した場合も、tzsetupに続いて表示される。

**主要な操作・処理内容**：
1. bsddialogのcalendarウィジェットによるカレンダー表示
2. 年月日の選択
3. dateコマンドによるシステム日付の設定

**画面遷移**：
- 遷移元：タイムゾーン選択画面（No.22）
- 遷移先：時刻設定画面（No.24）

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | タイマー・クロック管理 | 主機能 | カレンダーUIによる日付選択・dateコマンドでのシステム日付設定 |

## 画面種別

設定（カレンダー選択ウィジェット）

## URL/ルーティング

シェルスクリプトベースのTUIアプリケーション。`bsdinstall time` コマンド内のtimeスクリプト41-48行目で実行される。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 日付選択 | 入力 | カレンダー | いいえ | カレンダーUIで年月日を選択。Skipボタンで省略可能 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| バックタイトル | 画面上部 | "$OSNAME Installer" |
| タイトル | ダイアログタイトル | "Time & Date" |
| カレンダーウィジェット | ダイアログ本文 | 年月日選択カレンダー。幅40カラム |
| Set Dateボタン | OKボタン | 日付設定を実行 |
| Skipボタン | Cancelボタン | 日付設定をスキップ |

## イベント仕様

### 1-Set Dateボタン押下

Set Dateボタン押下時、以下の処理が実行される：
1. bsddialogのcalendarウィジェットから日付を `%Y%m%d%H%M.%S` 形式で取得
2. `date $DATE` コマンドでシステム日付を設定
3. 時刻設定画面に遷移

### 2-Skipボタン押下

Skipボタン（cancel-label）押下時、日付を変更せずに時刻設定画面に遷移する。`--default-no` オプションにより、デフォルトではSkipボタンにフォーカスが当たっている。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| Set Dateボタン押下 | システムクロック | UPDATE | dateコマンドによりカーネルのシステム時刻を更新 |

### テーブル別更新項目詳細

#### システムクロック

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| UPDATE | システム日付 | カレンダーで選択した日付（%Y%m%d%H%M.%S形式） | dateコマンドで設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | - | bsddialogのcalendarウィジェット標準メッセージ | 常時 |

## 例外処理

- **dateコマンド失敗**：不正な日付を指定した場合、dateコマンドがエラーを返す可能性があるが、カレンダーウィジェットで選択しているため通常は発生しない
- **BSDINSTALL_SKIP_TIME設定時**：timeスクリプト自体が呼ばれないため、本画面も表示されない

## 備考

- `--default-no` オプションにより、デフォルトでSkipボタンにフォーカスが当たる。これは、多くの場合システムクロックが既に正しい日付を保持しているため
- カレンダーの日付フォーマットは `%Y%m%d%H%M.%S` であり、dateコマンドの入力形式に直接対応している
- カレンダーウィジェットの幅は40カラムに設定されている（47行目）
- タイムゾーン設定直後に表示されるため、選択したタイムゾーンが適用された状態で日付が表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | time | `usr.sbin/bsdinstall/scripts/time` | 46行目：日付フォーマット `%Y%m%d%H%M.%S` の意味 |

**読解のコツ**: bsddialogの `--date-format` オプションはstrftime互換のフォーマット文字列を受け付ける。出力された文字列はそのままdateコマンドの引数として使用される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | time | `usr.sbin/bsdinstall/scripts/time` | 40-48行目：カレンダーUI表示と日付設定 |

**主要処理フロー**:
1. **40行目**: `exec 5>&1` でファイルディスクリプタ5を標準出力に複製
2. **41-48行目**: bsddialog --calendar でカレンダー表示、結果をDATE変数に格納
3. **48行目**: `date $DATE` でシステム日付を設定（bsddialog成功時のみ）
4. **49行目**: `exec 5>&-` でファイルディスクリプタ5を閉じる

### プログラム呼び出し階層図

```
auto (452行目: bsdinstall time)
    |
    +-- time
            |
            +-- chroot tzsetup -s (タイムゾーン: 前画面)
            |
            +-- bsddialog --calendar (本画面: 日付設定)
            |       |
            |       +-- date $DATE (システム日付設定)
            |
            +-- bsddialog --timebox (時刻設定: 次画面)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

カレンダーUI選択 ──────────> bsddialog --calendar ──────────> DATE変数
                                --date-format '%Y%m%d%H%M.%S'    |
                                                                   v
                                                            date $DATE ──> システムクロック更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| time | `usr.sbin/bsdinstall/scripts/time` | ソース | タイムゾーン・日付・時刻設定のメインスクリプト |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | インストーラメインフロー（time呼び出し元） |
| finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | ソース | 最終設定メニュー（time再呼び出し元） |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数ライブラリ |
