# 画面設計書 24-時刻設定画面

## 概要

本ドキュメントは、FreeBSD bsdinstallインストーラにおける「時刻設定画面」の画面設計書である。時刻入力UIを使用してシステムの時刻を設定する画面仕様を定義する。

### 本画面の処理概要

本画面は、FreeBSDのインストールプロセスにおいて、bsddialogのtimeboxウィジェットを使用してシステムの時刻（時・分・秒）を設定する画面である。日付設定画面の直後に表示される。

**業務上の目的・背景**：日付設定と同様に、システム時刻の正確性はファイルシステムのタイムスタンプ、ログ管理、セキュリティ機能に直接影響する。NTPが利用できない環境では手動設定が必要であり、タイムゾーン選択後に正しいローカル時刻を設定することが重要である。

**画面へのアクセス方法**：timeスクリプト内で、日付設定（calendar）の直後に自動的に表示される（52-60行目）。最終設定メニューから「Time Zone」を選択した場合も、日付設定に続いて表示される。

**主要な操作・処理内容**：
1. bsddialogのtimeboxウィジェットによる時刻入力UI表示
2. 時・分・秒の入力
3. dateコマンドによるシステム時刻の設定

**画面遷移**：
- 遷移元：日付設定画面（No.23）
- 遷移先：サービス選択画面（No.25）

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | タイマー・クロック管理 | 主機能 | 時刻入力UIによる時刻選択・dateコマンドでのシステム時刻設定 |

## 画面種別

設定（時刻入力ウィジェット）

## URL/ルーティング

シェルスクリプトベースのTUIアプリケーション。`bsdinstall time` コマンド内のtimeスクリプト52-60行目で実行される。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 時刻入力 | 入力 | 時刻 | いいえ | timeboxウィジェットで時・分・秒を入力。Skipボタンで省略可能 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| バックタイトル | 画面上部 | "$OSNAME Installer" |
| タイトル | ダイアログタイトル | "Time & Date" |
| timeboxウィジェット | ダイアログ本文 | 時・分・秒の入力フィールド。幅40カラム |
| Set Timeボタン | OKボタン | 時刻設定を実行 |
| Skipボタン | Cancelボタン | 時刻設定をスキップ |

## イベント仕様

### 1-Set Timeボタン押下

Set Timeボタン押下時、以下の処理が実行される：
1. bsddialogのtimeboxウィジェットから時刻を `%H%M.%S` 形式で取得
2. `date $TIME` コマンドでシステム時刻を設定
3. TZ環境変数を元に戻してtimeスクリプト終了

### 2-Skipボタン押下

Skipボタン（cancel-label）押下時、時刻を変更せずにtimeスクリプトを終了する。`--default-no` オプションにより、デフォルトではSkipボタンにフォーカスが当たっている。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| Set Timeボタン押下 | システムクロック | UPDATE | dateコマンドによりカーネルのシステム時刻を更新 |

### テーブル別更新項目詳細

#### システムクロック

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| UPDATE | システム時刻 | timeboxで入力した時刻（%H%M.%S形式） | dateコマンドで設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | - | bsddialogのtimeboxウィジェット標準メッセージ | 常時 |

## 例外処理

- **dateコマンド失敗**：不正な時刻を指定した場合、dateコマンドがエラーを返す可能性があるが、timeboxウィジェットで入力しているため通常は発生しない
- **BSDINSTALL_SKIP_TIME設定時**：timeスクリプト自体が呼ばれないため、本画面も表示されない

## 備考

- `--default-no` オプションにより、デフォルトでSkipボタンにフォーカスが当たる。これは、多くの場合システムクロックが既に正しい時刻を保持しているため
- 時刻フォーマットは `%H%M.%S` であり、dateコマンドの時刻指定形式に直接対応している
- timeboxウィジェットの幅は40カラムに設定されている（59行目）
- 時刻設定完了後、TZ環境変数がタイムゾーン選択前の値に復元される（64-68行目）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | time | `usr.sbin/bsdinstall/scripts/time` | 58行目：時刻フォーマット `%H%M.%S` の意味 |

**読解のコツ**: `%H%M.%S` はdateコマンドの時刻設定引数形式（HHMM.SS）に対応している。bsddialogの `--time-format` オプションで指定する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | time | `usr.sbin/bsdinstall/scripts/time` | 52-61行目：timebox UI表示と時刻設定 |

**主要処理フロー**:
1. **52行目**: `exec 5>&1` でファイルディスクリプタ5を標準出力に複製
2. **53-60行目**: bsddialog --timebox で時刻入力UI表示、結果をTIME変数に格納
3. **60行目**: `date $TIME` でシステム時刻を設定（bsddialog成功時のみ）
4. **61行目**: `exec 5>&-` でファイルディスクリプタ5を閉じる
5. **64-68行目**: TZ環境変数を元に戻す

### プログラム呼び出し階層図

```
auto (452行目: bsdinstall time)
    |
    +-- time
            |
            +-- chroot tzsetup -s (タイムゾーン: 前々画面)
            +-- bsddialog --calendar (日付設定: 前画面)
            |
            +-- bsddialog --timebox (本画面: 時刻設定)
            |       |
            |       +-- date $TIME (システム時刻設定)
            |
            +-- TZ環境変数の復元
```

### データフロー図

```
[入力]                          [処理]                              [出力]

timebox UI入力 ────────────> bsddialog --timebox ──────────> TIME変数
                                --time-format '%H%M.%S'          |
                                                                   v
                                                            date $TIME ──> システムクロック更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| time | `usr.sbin/bsdinstall/scripts/time` | ソース | タイムゾーン・日付・時刻設定のメインスクリプト |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | インストーラメインフロー（time呼び出し元） |
| finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | ソース | 最終設定メニュー（time再呼び出し元） |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数ライブラリ |
