# 画面設計書 25-サービス選択画面

## 概要

本ドキュメントは、FreeBSD bsdinstallインストーラにおける「サービス選択画面」の画面設計書である。システム起動時に有効にするデーモンサービスを選択するチェックリスト画面の仕様を定義する。

### 本画面の処理概要

本画面は、FreeBSDのインストールプロセスにおいて、システム起動時に自動的に起動するサービス（デーモン）を選択するチェックリスト画面である。sshd、ntpd、powerd等のサービスをチェックボックスで選択し、rc.conf.servicesファイルに設定を書き出す。

**業務上の目的・背景**：FreeBSDではrc.confを通じてシステムサービスの有効/無効を管理する。インストール時に必要なサービスを事前に設定しておくことで、初回起動時から必要な機能が利用可能となる。特にsshdはリモート管理に不可欠であり、デフォルトでONとなっている。

**画面へのアクセス方法**：autoスクリプト（453行目）から `bsdinstall services` として呼び出される。環境変数 `BSDINSTALL_SKIP_SERVICES` が設定されている場合は省略される。また、最終設定メニュー画面から「Services」を選択することで再度アクセスできる。

**主要な操作・処理内容**：
1. chroot環境内の利用可能なサービスを動的に検出
2. チェックリスト形式でサービス一覧を表示
3. ユーザが有効にしたいサービスを選択
4. 選択結果をrc.conf.servicesファイルに書き出し

**画面遷移**：
- 遷移元：タイムゾーン・日付・時刻設定完了後（autoスクリプト）、最終設定メニュー画面（Services選択時）
- 遷移先：セキュリティ強化設定画面（No.26）

**権限による表示制御**：特になし。ただし、chroot環境内に各サービスのrc.dスクリプトが存在するかどうかで表示項目が動的に変わる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 69 | init / rc | 主機能 | sshd・ntpd・powerd等のRC起動サービスの有効/無効をrc.confに設定する処理 |
| 51 | SSH | 補助機能 | sshdサービスの起動設定（デフォルトON） |
| 98 | NTPデーモン | 補助機能 | ntpdサービスおよびntpd_sync_on_start設定 |
| 78 | 電源管理 | 補助機能 | powerdサービスの起動設定 |
| 76 | コアダンプ管理 | 補助機能 | dumpdevのAUTO/NO設定 |

## 画面種別

設定（チェックリスト選択）

## URL/ルーティング

シェルスクリプトベースのTUIアプリケーション。`bsdinstall services` コマンドにより起動される。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | デフォルト | 説明 |
|--------|--------|-----|------|----------|------|
| sshd | 入力 | チェックボックス | いいえ | ON | Secure shell daemon |
| ntpd | 入力 | チェックボックス | いいえ | OFF | Synchronize system and network time |
| ntpd_sync_on_start | 入力 | チェックボックス | いいえ | OFF | Sync time on ntpd startup, even if offset is high |
| local_unbound | 入力 | チェックボックス | いいえ | OFF | Local caching validating resolver |
| powerd | 入力 | チェックボックス | いいえ | OFF | Adjust CPU frequency dynamically if supported |
| moused | 入力 | チェックボックス | いいえ | OFF | PS/2 mouse pointer on console |
| dumpdev | 入力 | チェックボックス | いいえ | ON | Enable kernel crash dumps to /var/crash |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| バックタイトル | 画面上部 | "$OSNAME Installer" |
| タイトル | ダイアログタイトル | "System Configuration" |
| プロンプトメッセージ | ダイアログ本文 | "Choose the services you would like to be started at boot:" |
| サービスチェックリスト | ダイアログ本文 | 動的に生成されたサービス一覧 |

## イベント仕様

### 1-OKボタン押下

OKボタン押下時（`--no-cancel` のため実質的にOKのみ）、以下の処理が実行される：
1. 選択されたサービスのリストを取得（`--separate-output` で1行1サービス）
2. $BSDINSTALL_TMPETC/rc.conf.services を空にして再生成
3. 選択された各サービスについて `{service}_enable="YES"` を書き出し
4. ntpd_sync_on_startは特別扱いで `_enable` サフィックスなしで書き出し
5. mousedが未選択の場合、`moused_nondefault_enable="NO"` を追加
6. dumpdevが選択されている場合は `dumpdev="AUTO"`、未選択の場合は `dumpdev="NO"` を書き出し

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| OKボタン押下 | $BSDINSTALL_TMPETC/rc.conf.services | WRITE | サービス設定をrc.confフラグメントとして書き出し |

### テーブル別更新項目詳細

#### rc.conf.services

| 操作 | 項目（変数名） | 更新値・取得条件 | 備考 |
|-----|---------------|-----------------|------|
| WRITE | sshd_enable | "YES" | 選択時のみ |
| WRITE | ntpd_enable | "YES" | 選択時のみ |
| WRITE | ntpd_sync_on_start | "YES" | 選択時のみ。_enableサフィックスなし |
| WRITE | local_unbound_enable | "YES" | 選択時のみ |
| WRITE | powerd_enable | "YES" | 選択時のみ |
| WRITE | moused_enable | "YES" | moused選択時 |
| WRITE | moused_nondefault_enable | "NO" | moused未選択時 |
| WRITE | dumpdev | "AUTO" or "NO" | 選択状態により変化 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | 情報 | "Choose the services you would like to be started at boot:" | 常時表示 |

## 例外処理

- **bsddialog戻り値がBSDDIALOG_OK以外**：exit 1でスクリプトを終了（ただし `--no-cancel` のため通常は発生しない）
- **サービスのrc.dスクリプト不在**：該当サービスがチェックリストに表示されない（45-72行目の条件分岐）
- **BSDINSTALL_SKIP_SERVICES設定時**：servicesスクリプトが呼ばれず、本画面は表示されない
- **rc.conf.servicesの既存設定**：スクリプト開始時に既存のrc.conf.servicesを読み込み、前回選択状態をデフォルト値として使用する（33-39行目）

## 備考

- サービスの表示有無はchroot環境内の `/etc/rc.d/{service}` の存在と実行可能性（`-x`）で判定される
- sshdのデフォルトがONなのは、リモート管理の利便性を考慮した設計
- dumpdevは他のサービスと異なり `_enable` 変数ではなく `dumpdev` 変数で制御される（"AUTO" or "NO"）
- `--separate-output` オプションにより、選択結果が1行1項目で出力される
- `--no-cancel` オプションにより、キャンセルボタンは表示されない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | services | `usr.sbin/bsdinstall/scripts/services` | 33-39行目：既存rc.conf.servicesの読み込みとデフォルト値設定 |
| 1-2 | services | `usr.sbin/bsdinstall/scripts/services` | 43-80行目：DAEMON_OPTIONS変数の動的構築 |

**読解のコツ**: DAEMON_OPTIONS変数はbsddialogの引数として直接使われる文字列を構築している。各サービスは「タグ 説明 状態」の3つ組で指定される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 453行目：`bsdinstall services` の呼び出し条件 |
| 2-2 | services | `usr.sbin/bsdinstall/scripts/services` | 29-31行目：初期化処理 |

**主要処理フロー**:
1. **29-30行目**: common.subr読み込み
2. **33-39行目**: 既存rc.conf.servicesの読み込み（前回値の復元）
3. **41行目**: rc.conf.servicesを空にして初期化
4. **45-72行目**: 各サービスのrc.dスクリプト存在確認とDAEMON_OPTIONS構築
5. **74-83行目**: bsddialog --checklistの表示
6. **89-112行目**: 選択結果のrc.conf.servicesへの書き出し

#### Step 3: 結果書き出し処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | services | `usr.sbin/bsdinstall/scripts/services` | 89-112行目：選択結果の処理ロジック |

**主要処理フロー**:
- **91-100行目**: 各選択サービスのrc.conf変数書き出し
- **92行目**: dumpdevは特別処理（havedumpフラグ設定）
- **93行目**: mousedは特別処理（havemouseフラグ設定）
- **94-98行目**: ntpd_sync_on_startは_enableサフィックスなし
- **102-104行目**: moused未選択時のnondefault設定
- **106-112行目**: dumpdev設定（AUTO/NO）

### プログラム呼び出し階層図

```
auto (453行目: bsdinstall services)
    |
    +-- services
            |
            +-- common.subr (共通関数読み込み)
            |
            +-- rc.conf.services読み込み (前回値復元)
            |
            +-- rc.dスクリプト存在確認
            |       +-- /etc/rc.d/sshd
            |       +-- /etc/rc.d/ntpd
            |       +-- /etc/rc.d/local_unbound
            |       +-- /etc/rc.d/powerd
            |       +-- /etc/rc.d/moused
            |
            +-- bsddialog --checklist (チェックリスト表示)
            |
            +-- rc.conf.services書き出し
```

### データフロー図

```
[入力]                              [処理]                                  [出力]

$BSDINSTALL_TMPETC/               services スクリプト
  rc.conf.services ──────────> 前回値読み込み・デフォルト設定
  (前回値)                          |
                                     v
$BSDINSTALL_CHROOT/              rc.dスクリプト存在確認
  etc/rc.d/* ────────────────> DAEMON_OPTIONS構築
                                     |
                                     v
ユーザ選択 ──────────────────> bsddialog --checklist ──────> $BSDINSTALL_TMPETC/
                                     |                         rc.conf.services
                                     v                         (更新後)
                               選択結果のループ処理
                               {service}_enable="YES"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| services | `usr.sbin/bsdinstall/scripts/services` | ソース | サービス選択画面のメインスクリプト |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | インストーラメインフロー（services呼び出し元） |
| finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | ソース | 最終設定メニュー（services再呼び出し元） |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数ライブラリ |
| rc.conf.services | `$BSDINSTALL_TMPETC/rc.conf.services` | 設定 | サービス設定フラグメントファイル |
| rc.d/* | `$BSDINSTALL_CHROOT/etc/rc.d/` | スクリプト | 各サービスのRC起動スクリプト |
