# 画面設計書 26-セキュリティ強化設定画面

## 概要

本ドキュメントは、FreeBSD bsdinstallインストーラにおける「セキュリティ強化設定画面」の画面設計書である。システムのセキュリティ関連オプション（プロセス隠蔽、PIDランダム化等）を選択するチェックリスト画面の仕様を定義する。

### 本画面の処理概要

本画面は、FreeBSDのインストールプロセスにおいて、セキュリティ強化（hardening）オプションを選択するチェックリスト画面である。sysctl.conf、rc.conf、loader.conf、ttysの各設定ファイルに対してセキュリティ関連パラメータを書き出す。

**業務上の目的・背景**：FreeBSDはデフォルトでは利便性を優先した設定となっているが、サーバ用途やセキュリティが重視される環境では、プロセス情報の隠蔽、PIDランダム化、DTrace破壊モード無効化などの追加的なセキュリティ対策が求められる。本画面により、これらの設定をインストール時に一括で適用できる。

**画面へのアクセス方法**：autoスクリプト（454行目）から `bsdinstall hardening` として呼び出される。環境変数 `BSDINSTALL_SKIP_HARDENING` が設定されている場合は省略される。また、最終設定メニュー画面から「System Hardening」を選択することで再度アクセスできる。

**主要な操作・処理内容**：
1. セキュリティ強化オプションのチェックリスト表示（10項目）
2. ユーザが有効にしたいセキュリティオプションを選択
3. 選択結果をsysctl.conf.hardening、rc.conf.hardening、loader.conf.hardening、ttys.hardeningの各ファイルに書き出し

**画面遷移**：
- 遷移元：サービス選択画面（No.25）、最終設定メニュー画面（System Hardening選択時）
- 遷移先：ファームウェアインストール画面（No.27）

**権限による表示制御**：特になし。全オプションはデフォルトでOFF（未選択）となっている。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 44 | MAC（Mandatory Access Control） | 主機能 | プロセス隠蔽・PIDランダム化等のsysctlセキュリティパラメータ設定 |
| 7 | sysctl管理 | 補助機能 | sysctl.confへのセキュリティ関連カーネルパラメータ書き込み |
| 69 | init / rc | 補助機能 | rc.confへのclear_tmp_enable・syslogd_flags設定 |
| 8 | DTrace動的トレーシング | 補助機能 | DTrace破壊モード無効化のloader.conf設定 |

## 画面種別

設定（チェックリスト選択）

## URL/ルーティング

シェルスクリプトベースのTUIアプリケーション。`bsdinstall hardening` コマンドにより起動される。

## 入出力項目

| 項目名 | 入出力 | 型 | デフォルト | 説明 |
|--------|--------|-----|----------|------|
| 0 hide_uids | 入力 | チェックボックス | OFF | Hide processes running as other users |
| 1 hide_gids | 入力 | チェックボックス | OFF | Hide processes running as other groups |
| 2 hide_jail | 入力 | チェックボックス | OFF | Hide processes running in jails |
| 3 read_msgbuf | 入力 | チェックボックス | OFF | Disable reading kernel message buffer for unprivileged users |
| 4 proc_debug | 入力 | チェックボックス | OFF | Disable process debugging facilities for unprivileged users |
| 5 random_pid | 入力 | チェックボックス | OFF | Randomize the PID of newly created processes |
| 6 clear_tmp | 入力 | チェックボックス | OFF | Clean the /tmp filesystem on system startup |
| 7 disable_syslogd | 入力 | チェックボックス | OFF | Disable opening Syslogd network socket (disables remote logging) |
| 8 secure_console | 入力 | チェックボックス | OFF | Enable console password prompt |
| 9 disable_ddtrace | 入力 | チェックボックス | OFF | Disallow DTrace destructive-mode |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| バックタイトル | 画面上部 | "$OSNAME Installer" |
| タイトル | ダイアログタイトル | "System Hardening" |
| プロンプトメッセージ | ダイアログ本文 | "Choose system security hardening options:" |
| セキュリティオプション一覧 | ダイアログ本文 | 10項目のチェックリスト |

## イベント仕様

### 1-OKボタン押下

OKボタン押下時（`--nocancel` のため実質的にOKのみ）、以下の処理が実行される：

選択された各オプションに対応する設定が、以下の設定ファイルに書き出される：

| オプション | 設定ファイル | 設定内容 |
|-----------|-------------|---------|
| hide_uids | sysctl.conf.hardening | security.bsd.see_other_uids=0 |
| hide_gids | sysctl.conf.hardening | security.bsd.see_other_gids=0 |
| hide_jail | sysctl.conf.hardening | security.bsd.see_jail_proc=0 |
| read_msgbuf | sysctl.conf.hardening | security.bsd.unprivileged_read_msgbuf=0 |
| proc_debug | sysctl.conf.hardening | security.bsd.unprivileged_proc_debug=0 |
| random_pid | sysctl.conf.hardening | kern.randompid=1 |
| clear_tmp | rc.conf.hardening | clear_tmp_enable="YES" |
| disable_syslogd | rc.conf.hardening | syslogd_flags="-ss" |
| secure_console | ttys.hardening | "unknown off secure" を "unknown off insecure" に置換 |
| disable_ddtrace | loader.conf.hardening | security.bsd.allow_destructive_dtrace=0 |

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| OKボタン押下 | $BSDINSTALL_TMPETC/sysctl.conf.hardening | WRITE | sysctlセキュリティパラメータ |
| OKボタン押下 | $BSDINSTALL_TMPETC/rc.conf.hardening | WRITE | RCサービス設定 |
| OKボタン押下 | $BSDINSTALL_TMPBOOT/loader.conf.hardening | WRITE | ブートローダ設定 |
| OKボタン押下 | $BSDINSTALL_TMPETC/ttys.hardening | WRITE | ttys設定（secure_console選択時） |

### テーブル別更新項目詳細

#### sysctl.conf.hardening

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| WRITE | security.bsd.see_other_uids | 0 | hide_uids選択時 |
| WRITE | security.bsd.see_other_gids | 0 | hide_gids選択時 |
| WRITE | security.bsd.see_jail_proc | 0 | hide_jail選択時 |
| WRITE | security.bsd.unprivileged_read_msgbuf | 0 | read_msgbuf選択時 |
| WRITE | security.bsd.unprivileged_proc_debug | 0 | proc_debug選択時 |
| WRITE | kern.randompid | 1 | random_pid選択時 |

#### rc.conf.hardening

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| WRITE | clear_tmp_enable | "YES" | clear_tmp選択時 |
| WRITE | syslogd_flags | "-ss" | disable_syslogd選択時 |

#### loader.conf.hardening

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| WRITE | security.bsd.allow_destructive_dtrace | 0 | disable_ddtrace選択時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | 情報 | "Choose system security hardening options:" | 常時表示 |

## 例外処理

- **bsddialog戻り値がBSDDIALOG_OK以外**：exit 1でスクリプトを終了
- **BSDINSTALL_SKIP_HARDENING設定時**：hardeningスクリプトが呼ばれず、本画面は表示されない
- **何も選択しない場合**：hardeningファイルは空のまま（33-35行目で初期化済み）

## 備考

- 全オプションはデフォルトでOFFであり、ユーザが明示的に有効化する必要がある
- secure_consoleオプションは他のオプションと異なり、sedによる既存ファイルの置換処理を行う（87行目）
- syslogd_flagsを"-ss"に設定すると、syslogdがネットワークソケットを開かなくなり、リモートログ受信が無効化される
- 各hardeningファイル（.hardening拡張子）は、後続のbsdinstall configステップで本来の設定ファイルにマージされる
- `--nocancel` オプションにより、キャンセルボタンは表示されない
- チェックリストのタグにはプレフィックス番号（0-9）が付与されており、表示順を制御している

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | hardening | `usr.sbin/bsdinstall/scripts/hardening` | 33-35行目：3つの出力ファイルの初期化 |
| 1-2 | hardening | `usr.sbin/bsdinstall/scripts/hardening` | 42-51行目：チェックリスト項目定義 |

**読解のコツ**: チェックリストの各項目タグには「番号 機能名」の形式（例："0 hide_uids"）が使われている。case文での処理時にはスペース後の機能名部分のみが使用される（60行目以降）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 454行目：`bsdinstall hardening` の呼び出し条件 |
| 2-2 | hardening | `usr.sbin/bsdinstall/scripts/hardening` | 28-31行目：初期化処理 |

**主要処理フロー**:
1. **28-29行目**: common.subr読み込み
2. **33-35行目**: 3つのhardening設定ファイルを空で初期化
3. **37-53行目**: bsddialog --checklistの表示
4. **60-93行目**: 選択結果のcase文による各設定ファイルへの書き出し

#### Step 3: 設定書き出し処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | hardening | `usr.sbin/bsdinstall/scripts/hardening` | 60-93行目：case文による分岐処理 |

**主要処理フロー**:
- **62-78行目**: sysctl.conf.hardeningへの書き出し（hide_uids, hide_gids, hide_jail, read_msgbuf, proc_debug, random_pid）
- **80-81行目**: rc.conf.hardeningへの書き出し（clear_tmp）
- **83-84行目**: rc.conf.hardeningへの書き出し（disable_syslogd）
- **86-87行目**: ttys.hardeningへの書き出し（secure_console）
- **89-90行目**: loader.conf.hardeningへの書き出し（disable_ddtrace）

### プログラム呼び出し階層図

```
auto (454行目: bsdinstall hardening)
    |
    +-- hardening
            |
            +-- common.subr (共通関数読み込み)
            |
            +-- 初期化: rc.conf.hardening, sysctl.conf.hardening, loader.conf.hardening を空に
            |
            +-- bsddialog --checklist (10項目チェックリスト表示)
            |
            +-- case文分岐
                    +-- hide_uids/gids/jail/read_msgbuf/proc_debug/random_pid
                    |       --> sysctl.conf.hardening
                    +-- clear_tmp/disable_syslogd
                    |       --> rc.conf.hardening
                    +-- secure_console
                    |       --> ttys.hardening (sed置換)
                    +-- disable_ddtrace
                            --> loader.conf.hardening
```

### データフロー図

```
[入力]                              [処理]                                  [出力]

ユーザ選択 ──────────────────> bsddialog --checklist         sysctl.conf.hardening
(10項目チェックリスト)            |                              rc.conf.hardening
                                   v                              loader.conf.hardening
                              case文による                       ttys.hardening
                              設定ファイル振り分け

$BSDINSTALL_CHROOT/             sed置換
  etc/ttys ──────────────> (secure_console時)  ──────> ttys.hardening
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| hardening | `usr.sbin/bsdinstall/scripts/hardening` | ソース | セキュリティ強化設定画面のメインスクリプト |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | インストーラメインフロー（hardening呼び出し元） |
| finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | ソース | 最終設定メニュー（hardening再呼び出し元） |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数ライブラリ |
| sysctl.conf.hardening | `$BSDINSTALL_TMPETC/sysctl.conf.hardening` | 設定 | sysctlパラメータ設定フラグメント |
| rc.conf.hardening | `$BSDINSTALL_TMPETC/rc.conf.hardening` | 設定 | rc.conf設定フラグメント |
| loader.conf.hardening | `$BSDINSTALL_TMPBOOT/loader.conf.hardening` | 設定 | loader.conf設定フラグメント |
| ttys | `$BSDINSTALL_CHROOT/etc/ttys` | 設定 | ターミナル設定ファイル（secure_console参照元） |
