# 画面設計書 28-ユーザ追加確認画面

## 概要

本ドキュメントは、FreeBSD bsdinstallインストーラにおける「ユーザ追加確認画面」の画面設計書である。ユーザアカウントを追加するかどうかを確認するYes/Noダイアログの仕様を定義する。

### 本画面の処理概要

本画面は、FreeBSDのインストールプロセスにおいて、一般ユーザアカウントを追加するかどうかをユーザに確認するためのYes/Noダイアログ画面である。bsddialogの--yesnoウィジェットを使用して簡潔な確認メッセージを表示する。

**業務上の目的・背景**：FreeBSDではrootアカウントでの日常的なログインはセキュリティ上推奨されない。一般ユーザアカウントを作成し、su/sudoを通じてroot権限を取得する運用が標準的である。本画面により、インストール時にユーザアカウントの作成要否をユーザに問い合わせ、必要に応じてユーザ追加画面（No.29）に遷移する。

**画面へのアクセス方法**：autoスクリプト（457-460行目）に直接記述されたbsddialogコマンドとして実行される。環境変数 `BSDINSTALL_SKIP_USERS` が設定されている場合は省略される。

**主要な操作・処理内容**：
1. "Would you like to add users to the installed system now?" メッセージの表示
2. Yes/No選択
3. Yes選択時にbsdinstall adduserの呼び出し

**画面遷移**：
- 遷移元：ファームウェアインストール画面（No.27）
- 遷移先（Yes）：ユーザ追加画面（No.29）
- 遷移先（No）：最終設定メニュー画面（No.30）

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 73 | ユーザ・グループ管理 | 主機能 | ユーザアカウント追加の実行有無を確認するYes/Noダイアログ |

## 画面種別

確認（Yes/Noダイアログ）

## URL/ルーティング

シェルスクリプトベースのTUIアプリケーション。autoスクリプト457-460行目に直接記述されている。独立したスクリプトファイルは持たない。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| Yes/No選択 | 入力 | ボタン | はい | ユーザ追加を行うかどうかの選択 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| バックタイトル | 画面上部 | "$OSNAME Installer" |
| タイトル | ダイアログタイトル | "Add User Accounts" |
| 確認メッセージ | ダイアログ本文 | "Would you like to add users to the installed system now?" |
| Yesボタン | ボタン | ユーザ追加画面へ遷移 |
| Noボタン | ボタン | スキップして次へ |

## イベント仕様

### 1-Yesボタン押下

Yesボタン押下時、`bsdinstall adduser` コマンドが実行され、ユーザ追加画面（No.29）に遷移する。

### 2-Noボタン押下

Noボタン押下時、ユーザ追加を行わずに最終設定メニュー画面（No.30）に遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| - | - | - | 本画面自体はデータ更新を行わない。Yes選択時はadduser画面でデータ更新が行われる |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-01 | 確認 | Would you like to add users to the installed system now? | 常時表示 |

## 例外処理

- **BSDINSTALL_SKIP_USERS設定時**：本画面およびadduser画面がスキップされる
- **bsdinstall adduser失敗**：adduserスクリプトのエラーはautoスクリプトでは捕捉されない（trap true SIGINTの範囲内のため）

## 備考

- 本画面はautoスクリプト内に直接記述されており、独立したスクリプトファイルを持たない
- `trap true SIGINT` の範囲内にあるため、Ctrl-Cが押されてもエラー処理は発生せず無視される（448行目）
- bsddialogの戻り値が0（Yes）の場合にのみ `bsdinstall adduser` が実行される（460行目の `&&` による条件実行）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面ではデータ構造は特にない。単純なYes/Noダイアログである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 457-460行目：ユーザ追加確認ダイアログの定義 |

**読解のコツ**: シェルスクリプトの `&&` 演算子により、bsddialogが成功（戻り値0 = Yes選択）した場合のみ `bsdinstall adduser` が実行される構造となっている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 457行目：BSDINSTALL_SKIP_USERS環境変数チェック |
| 2-2 | auto | `usr.sbin/bsdinstall/scripts/auto` | 458-460行目：bsddialog --yesno実行とadduser呼び出し |

**主要処理フロー**:
1. **457行目**: `[ -z "$BSDINSTALL_SKIP_USERS" ]` でスキップ判定
2. **457-459行目**: bsddialog --yesno で確認ダイアログ表示
3. **460行目**: bsddialog成功時（Yes選択）に `bsdinstall adduser` を実行

### プログラム呼び出し階層図

```
auto (457-460行目)
    |
    +-- [ -z "$BSDINSTALL_SKIP_USERS" ] (スキップ判定)
    |
    +-- bsddialog --yesno "Would you like to add users..." (確認ダイアログ)
            |
            +-- [Yes] bsdinstall adduser (ユーザ追加画面へ)
            +-- [No]  (次のステップへ)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

BSDINSTALL_SKIP_USERS ────> スキップ判定
                                |
                                v
ユーザ選択(Yes/No) ────────> bsddialog --yesno
                                |
                                +-- [Yes] --> bsdinstall adduser
                                +-- [No]  --> 次のステップ(finalconfig)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | ユーザ追加確認ダイアログを含むメインフロースクリプト |
| adduser | `usr.sbin/bsdinstall/scripts/adduser` | ソース | Yes選択時に呼び出されるユーザ追加スクリプト |
