# 画面設計書 29-ユーザ追加画面

## 概要

本ドキュメントは、FreeBSD bsdinstallインストーラにおける「ユーザ追加画面」の画面設計書である。adduserコマンドをchroot環境で実行し、対話的にユーザアカウントを追加するCLI画面の仕様を定義する。

### 本画面の処理概要

本画面は、FreeBSDのインストールプロセスにおいて、一般ユーザアカウントを対話的に追加するための画面である。TUI（Text User Interface）ではなく、FreeBSD標準のadduserコマンドをchroot環境内で直接実行するCLI画面となっている。

**業務上の目的・背景**：FreeBSDでは、セキュリティ上の理由からrootアカウントでの日常的なログインは推奨されない。一般ユーザアカウントを作成し、wheelグループに追加することで、su/sudoを通じたroot権限取得を可能にする運用が標準的である。adduserコマンドは対話形式でユーザ名、フルネーム、UID、ログイングループ、追加グループ、ホームディレクトリ、シェル、パスワード等を設定できる。

**画面へのアクセス方法**：ユーザ追加確認画面（No.28）でYesを選択した場合、autoスクリプト（460行目）から `bsdinstall adduser` として呼び出される。また、最終設定メニュー画面から「Add User」を選択することで再度アクセスできる。

**主要な操作・処理内容**：
1. コンソール画面のクリアとヘッダ表示
2. chroot環境内でadduserコマンドの対話的実行
3. ユーザ名、パスワード、グループ等の対話的入力

**画面遷移**：
- 遷移元：ユーザ追加確認画面（No.28）でYes選択時、最終設定メニュー画面（Add User選択時）
- 遷移先：最終設定メニュー画面（No.30）

**権限による表示制御**：特になし。インストーラはroot権限で動作する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 73 | ユーザ・グループ管理 | 主機能 | chroot環境内でのadduserコマンドによる対話的ユーザアカウント作成 |

## 画面種別

設定（CLI対話インターフェース）

## URL/ルーティング

シェルスクリプトベースのCLIアプリケーション。`bsdinstall adduser` コマンドにより起動される。

## 入出力項目

adduserコマンドの対話的入力項目（adduserコマンドのデフォルト設定による）：

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| Username | 入力 | 文字列 | はい | ユーザ名 |
| Full name | 入力 | 文字列 | いいえ | フルネーム（GECOS） |
| Uid | 入力 | 数値 | いいえ | ユーザID（自動割当可） |
| Login group | 入力 | 文字列 | いいえ | ログイングループ |
| Login group is ... Invite into other groups? | 入力 | 文字列 | いいえ | 追加グループ（例: wheel） |
| Login class | 入力 | 文字列 | いいえ | ログインクラス |
| Shell | 入力 | 選択 | いいえ | ログインシェル |
| Home directory | 入力 | パス | いいえ | ホームディレクトリ |
| Home directory permissions | 入力 | 文字列 | いいえ | ホームディレクトリパーミッション |
| Use password-based authentication? | 入力 | yes/no | いいえ | パスワード認証使用有無 |
| Use an empty password? | 入力 | yes/no | いいえ | 空パスワード使用有無 |
| Use a random password? | 入力 | yes/no | いいえ | ランダムパスワード使用有無 |
| Enter password | 入力 | パスワード | 条件付き | パスワード入力 |
| Enter password again | 入力 | パスワード | 条件付き | パスワード確認入力 |
| Add another user? | 入力 | yes/no | はい | 追加ユーザ作成有無 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| ヘッダ（OSNAMEタイトル） | 画面上部 | "$OSNAME Installer" |
| 区切り線 | ヘッダ直下 | "========================" |
| セクション名 | 区切り線直下 | "Add Users" |
| adduserプロンプト | 画面本文 | adduserコマンドの対話的プロンプト群 |

## イベント仕様

### 1-adduserコマンド実行

画面表示後、chroot環境内でadduserコマンドが自動的に実行される。adduserコマンドの対話的プロンプトに従ってユーザ情報を入力する。

### 2-ユーザ追加完了

adduserコマンドの対話が完了（"Add another user?" に "no" と回答）すると、adduserスクリプトが終了し、呼び出し元に制御が戻る。

### 3-複数ユーザ追加

adduserコマンドの "Add another user?" プロンプトに "yes" と回答すると、続けて別のユーザアカウントを追加できる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ユーザ追加完了 | $BSDINSTALL_CHROOT/etc/master.passwd | INSERT | 新規ユーザエントリの追加 |
| ユーザ追加完了 | $BSDINSTALL_CHROOT/etc/passwd | INSERT | 新規ユーザエントリの追加 |
| ユーザ追加完了 | $BSDINSTALL_CHROOT/etc/pwd.db | INSERT | パスワードデータベース更新 |
| ユーザ追加完了 | $BSDINSTALL_CHROOT/etc/spwd.db | INSERT | シャドウパスワードデータベース更新 |
| ユーザ追加完了 | $BSDINSTALL_CHROOT/etc/group | UPDATE | グループメンバーシップ更新 |

### テーブル別更新項目詳細

#### master.passwd

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| INSERT | 全フィールド | adduserコマンドの対話入力値 | adduserが自動生成 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-01 | 情報 | "$OSNAME Installer" | スクリプト開始時 |
| MSG-02 | 情報 | "========================" | スクリプト開始時 |
| MSG-03 | 情報 | "Add Users" | スクリプト開始時 |
| - | - | adduserコマンドの標準メッセージ群 | adduserコマンドの対話中 |

## 例外処理

- **adduserコマンドエラー**：adduserコマンドの標準エラーは標準出力にリダイレクトされる（36行目: `2>&1`）
- **chroot環境でadduserが不在**：コマンドエラーとなるが、通常のFreeBSDインストールでは発生しない
- **BSDINSTALL_SKIP_USERS設定時**：ユーザ追加確認画面自体がスキップされるため、本画面も表示されない

## 備考

- 本画面はTUI（bsddialog）ではなく、CLIのadduserコマンドを直接使用する
- `clear` コマンドで画面をクリアしてからヘッダを表示する
- adduserの標準エラーは標準出力にリダイレクトされている（`2>&1`）
- adduserコマンドはFreeBSD標準のユーザ追加ツールであり、/etc/adduser.confの設定に従ったデフォルト値を提供する
- スクリプトは非常にシンプル（7行のみ、コメント・ライセンス除く）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | adduser | `usr.sbin/bsdinstall/scripts/adduser` | 全体（36行目）：chroot環境内でadduserを実行 |

**読解のコツ**: このスクリプトは極めて単純で、画面クリア→ヘッダ表示→chroot adduser実行の3ステップのみ。adduserコマンドの対話的動作はFreeBSD標準のadduser(8)に委任されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 457-460行目：ユーザ追加確認とadduser呼び出し |
| 2-2 | finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | 62-63行目：最終設定メニューからの再呼び出し |
| 2-3 | adduser | `usr.sbin/bsdinstall/scripts/adduser` | 31-36行目：メイン処理 |

**主要処理フロー**:
1. **28-29行目**: common.subr読み込み
2. **31行目**: `clear` でコンソールクリア
3. **32行目**: `echo "$OSNAME Installer"` でタイトル表示
4. **33行目**: `echo "========================"` で区切り線表示
5. **34行目**: `echo "Add Users"` でセクション名表示
6. **35行目**: 空行表示
7. **36行目**: `chroot $BSDINSTALL_CHROOT adduser 2>&1` でadduser実行

### プログラム呼び出し階層図

```
auto (460行目: bsdinstall adduser)
    |
    +-- adduser (bsdinstallスクリプト)
            |
            +-- common.subr (共通関数読み込み)
            |
            +-- clear (コンソールクリア)
            |
            +-- echo (ヘッダ表示)
            |
            +-- chroot $BSDINSTALL_CHROOT adduser
                    |
                    +-- adduser(8) コマンド (対話的ユーザ追加)
                            +-- /etc/master.passwd 更新
                            +-- /etc/passwd 更新
                            +-- /etc/group 更新
                            +-- pwd_mkdb (データベース再構築)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

ユーザ対話入力 ────────────> chroot adduser ──────────────> master.passwd
(ユーザ名、パスワード、                                      passwd
 グループ等)                                                 pwd.db
                                                             spwd.db
                                                             group
                                                             ホームディレクトリ作成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| adduser | `usr.sbin/bsdinstall/scripts/adduser` | ソース | ユーザ追加画面のメインスクリプト |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | インストーラメインフロー（adduser呼び出し元） |
| finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | ソース | 最終設定メニュー（adduser再呼び出し元） |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数ライブラリ |
| adduser(8) | `/usr/sbin/adduser` | コマンド | FreeBSD標準ユーザ追加コマンド |
| master.passwd | `$BSDINSTALL_CHROOT/etc/master.passwd` | 設定 | パスワードデータベースソース |
| group | `$BSDINSTALL_CHROOT/etc/group` | 設定 | グループデータベース |
