# 画面設計書 3-インストール種別選択画面

## 概要

本ドキュメントは、FreeBSD bsdinstall インストーラにおける「インストール種別選択画面」の設計仕様を記述する。本画面はホスト名設定画面の次に表示され、Distribution Sets（従来方式）またはPackages（pkgbase）のどちらでベースシステムをインストールするかを選択する。

### 本画面の処理概要

本画面は、FreeBSDのベースシステムインストール方式を選択するTUI画面である。従来のDistribution Sets（tar.xzアーカイブベース）か、新しいPackages（pkgbase）方式かを選択する。

**業務上の目的・背景**：FreeBSDはベースシステムのインストール方式として、従来のDistribution Sets方式に加え、pkgbase（パッケージベースのベースシステム管理）方式をサポートしている。pkgbaseはベースシステムの個別パッケージ単位でのアップデートを可能にし、より柔軟なシステム管理を実現する。本画面はこの2つの方式をユーザに選択させることで、運用ポリシーに合ったインストール方式を決定させる。

**画面へのアクセス方法**：ホスト名設定画面の後に自動的に表示される。autoスクリプト208-218行目のロジックにより制御される。ただし、MANIFESTファイルが存在しない場合は自動的にpkgbaseが選択され、本画面は表示されない（208-209行目）。

**主要な操作・処理内容**：
1. インストール方式の選択：Yes/Noダイアログで「Distribution Sets」と「Packages」のどちらかを選択する
2. MANIFESTファイルの存在確認：`$BSDINSTALL_DISTDIR/MANIFEST`の存在により、Distribution Sets方式が利用可能か判定する
3. ローカルパッケージの存在確認：`/usr/freebsd-packages/repos/FreeBSD-base-offline.conf`の存在によりオフラインインストールの可否を判定する（200-206行目）

**画面遷移**：
- 遷移元：ホスト名設定画面
- 遷移先（Distribution Sets選択時）：配布セット選択画面（238-268行目）
- 遷移先（Packages選択時）：ネットワーク/オフラインインストール選択画面（220-236行目）
- MANIFESTなし時：自動的にpkgbase=yesとなり画面スキップ

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | パッケージ管理支援 | 主機能 | Distribution Sets（従来方式）またはPackages（pkgbase）の選択判定処理 |

## 画面種別

選択（Yes/Noダイアログ形式のインストール方式選択画面）

## URL/ルーティング

TUIベースのインストーラのため、URLは存在しない。autoスクリプト（`usr.sbin/bsdinstall/scripts/auto`）内の211-218行目で直接bsddialogが呼び出される。

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 | 初期値 | 必須 |
|--------|----------|-----|------|--------|------|
| 選択結果 | 出力 | ブール | Distribution Sets（Yes）またはPackages（No） | HAVE_BASE_PACKAGESがyesの場合はPackagesがデフォルト | はい |
| PKGBASE | 出力 | 文字列 | "yes"または未設定 | MANIFESTなし時は"yes" | - |
| HAVE_BASE_PACKAGES | 参照 | 文字列 | ローカルパッケージの有無 | "yes"または未設定 | - |

## 表示項目

| 項目名 | 説明 | 表示形式 |
|--------|------|----------|
| タイトル | "Select Installation Type" | ダイアログタイトル |
| バックタイトル | "$OSNAME Installer" | ダイアログバックタイトル |
| プロンプト | "Would you like to install the base system using legacy distribution sets or packages?" | テキスト |
| Yesボタン | "Distribution Sets" | ボタン（yes-label） |
| Noボタン | "Packages" | ボタン（no-label） |

## イベント仕様

### 1-Distribution Sets選択（Yesボタン）

bsddialogの戻り値が0の場合、PKGBASE変数は未設定のまま。DISTRIBUTIONS変数に`base.txz kernel.txz`がデフォルトとして設定され（238行目）、MANIFESTファイルからオプション配布セットを読み込む処理に進む（239-255行目）。

### 2-Packages選択（Noボタン）

bsddialogの戻り値が1の場合（215-217行目）、PKGBASE=yesが設定される。その後、HAVE_BASE_PACKAGESの値に応じてネットワーク/オフライン選択画面（画面No.4）に遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はファイル書き込みを行わない。環境変数の設定のみ。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| Packages選択 | PKGBASE環境変数 | SET | PKGBASE=yesを設定 |
| Distribution Sets選択 | DISTRIBUTIONS環境変数 | SET | "base.txz kernel.txz"を設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | 説明 | "Would you like to install the base system using legacy distribution sets or packages?" | MANIFESTファイルが存在する場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| MANIFESTファイルが存在しない | 自動的にPKGBASE=yesが設定され、本画面は表示されない（208-209行目） |

## 備考

- MANIFESTファイルが`$BSDINSTALL_DISTDIR`に存在しない場合、pkgbaseが自動選択される
- ローカルパッケージ（`/usr/freebsd-packages/repos/FreeBSD-base-offline.conf`）の存在により、デフォルトボタンが変化する（`--default-no`が付与される場合はPackagesがデフォルト）
- 本画面は単独のスクリプトではなく、autoスクリプト内に直接記述されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 42行目のuser_env_vars（BSDINSTALL_DISTSITE、DISTRIBUTIONS等）の役割を理解する |
| 1-2 | auto | `usr.sbin/bsdinstall/scripts/auto` | 200-206行目のHAVE_BASE_PACKAGES判定ロジックを理解する |

**読解のコツ**: autoスクリプトは複数の画面ロジックを含む大きなスクリプト。本画面に関連するのは200-269行目の範囲。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 200-218行目がインストール種別選択の主ロジック |

**主要処理フロー**:
1. **200-206行目**: ローカルパッケージ存在確認とデフォルトボタン設定
2. **208-209行目**: MANIFESTファイル不在時の自動pkgbase選択
3. **211-214行目**: bsddialogによるYes/No選択ダイアログ表示
4. **215-217行目**: Packages選択時のPKGBASE=yes設定

#### Step 3: 後続処理分岐を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 220-236行目のpkgbase選択後のネットワーク/オフライン判定 |
| 3-2 | auto | `usr.sbin/bsdinstall/scripts/auto` | 238-268行目のDistribution Sets選択後の配布セット選択処理 |

### プログラム呼び出し階層図

```
auto (bsdinstall起動スクリプト)
    |
    +-- ローカルパッケージ存在確認 (200-206行目)
    |      +-- /usr/freebsd-packages/repos/FreeBSD-base-offline.conf チェック
    |
    +-- MANIFESTファイル存在確認 (208行目)
    |      +-- $BSDINSTALL_DISTDIR/MANIFEST チェック
    |
    +-- bsddialog --yesno (211-214行目)
    |      +-- Distribution Sets / Packages 選択
    |
    +-- [Packages選択時]
    |      +-- PKGBASE=yes 設定
    |      +-- ネットワーク/オフライン選択画面 (画面No.4)
    |
    +-- [Distribution Sets選択時]
         +-- DISTRIBUTIONS設定
         +-- MANIFEST解析 (awk)
         +-- bsddialog --checklist (配布セット選択、画面No.5)
```

### データフロー図

```
[入力]                          [処理]                          [出力]

/usr/freebsd-packages/     -->  存在確認            -------->  HAVE_BASE_PACKAGES
  repos/FreeBSD-base-                                          PKGBASE_DEFAULT_BUTTON
  offline.conf

$BSDINSTALL_DISTDIR/       -->  存在確認            -------->  PKGBASE自動設定
  MANIFEST                                                     (MANIFESTなし時)

ユーザ選択                 -->  bsddialog --yesno   -------->  PKGBASE変数
                                                               ("yes" or 未設定)

PKGBASE値                  -->  分岐処理            -------->  後続画面への遷移
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | 本画面のロジックを含むメインスクリプト |
| MANIFEST | `$BSDINSTALL_DISTDIR/MANIFEST` | データ | 配布セット情報ファイル（存在確認に使用） |
| FreeBSD-base-offline.conf | `/usr/freebsd-packages/repos/FreeBSD-base-offline.conf` | 設定 | ローカルパッケージリポジトリ設定 |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数群 |
| dialog.subr | `/usr/share/bsdconfig/dialog.subr` | ライブラリ | ダイアログ表示関数群 |
