# 画面設計書 30-最終設定メニュー画面

## 概要

本ドキュメントは、FreeBSD bsdinstallインストーラにおける「最終設定メニュー画面」の画面設計書である。インストール完了前に各種設定を再変更できるメニュー画面の仕様を定義する。

### 本画面の処理概要

本画面は、FreeBSDのインストールプロセスにおいて、インストール完了前に各種設定を再確認・変更するための統合メニュー画面である。bsddialogのmenuウィジェットを使用し、10個のメニュー項目（Finish/Add User/Root Password/Hostname/Network/Services/System Hardening/Time Zone/Firmware/Handbook）から選択できる。

**業務上の目的・背景**：インストールプロセスは多段階にわたるため、後から設定を変更したい場合がある。本画面は、全設定画面に再アクセスするための中央ハブとして機能し、ユーザが最終確認と修正を行えるようにする。これにより、インストールのやり直しを防ぎ、ユーザ体験を向上させる。

**画面へのアクセス方法**：autoスクリプト（463行目）から `bsdinstall finalconfig` として呼び出される。環境変数 `BSDINSTALL_SKIP_FINALCONFIG` が設定されている場合は省略される。

**主要な操作・処理内容**：
1. メニュー形式で設定項目一覧を表示
2. 選択された設定項目に対応するbsdinstallサブコマンドを実行
3. サブコマンド完了後、再度メニューに戻る（ループ）
4. 「Finish」選択でメニューを終了

**画面遷移**：
- 遷移元：ユーザ追加確認画面（No.28）/ ユーザ追加画面（No.29）
- 遷移先（Finish）：手動設定確認画面（No.32）
- 遷移先（各メニュー項目）：対応する設定画面に遷移し、完了後に本画面に戻る

**権限による表示制御**：特になし。全メニュー項目が常時表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | パッケージ管理支援 | 主機能 | インストール完了前の各種設定再変更メニューの表示・選択処理 |
| 73 | ユーザ・グループ管理 | 遷移先機能 | Add User選択時のadduser画面への遷移 |
| 35 | ネットワークインタフェース管理 | 遷移先機能 | Network選択時のnetconfig画面への遷移 |
| 69 | init / rc | 遷移先機能 | Services選択時のサービス選択画面への遷移 |
| 5 | タイマー・クロック管理 | 遷移先機能 | Time Zone選択時のタイムゾーン設定画面への遷移 |

## 画面種別

メニュー（選択メニュー）

## URL/ルーティング

シェルスクリプトベースのTUIアプリケーション。`bsdinstall finalconfig` コマンドにより起動される。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| メニュー選択 | 入力 | メニュー選択 | はい | 10個のメニュー項目から1つを選択 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| バックタイトル | 画面上部 | "$OSNAME Installer" |
| タイトル | ダイアログタイトル | "Final Configuration" |
| プロンプトメッセージ | ダイアログ本文 | "Setup of your $OSNAME system is nearly complete. You can now modify your configuration choices. After this screen, you will have an opportunity to make more complex changes using a shell." |
| Finish | メニュー項目 | Apply configuration and exit installer |
| Add User | メニュー項目 | Add a user to the system |
| Root Password | メニュー項目 | Change root password |
| Hostname | メニュー項目 | Set system hostname |
| Network | メニュー項目 | Networking configuration |
| Services | メニュー項目 | Set daemons to run on startup |
| System Hardening | メニュー項目 | Set security options |
| Time Zone | メニュー項目 | Set system timezone |
| Firmware | メニュー項目 | Install Firmware (requires network) |
| Handbook | メニュー項目 | Install $OSNAME Handbook (requires network) |

## イベント仕様

### 1-Finish選択

「Finish」選択時、whileループを抜けてfinalconfigスクリプトが終了する。制御はautoスクリプトに戻り、手動設定確認画面に遷移する。

### 2-Add User選択

「Add User」選択時、`bsdinstall adduser` が実行される。adduser完了後、再度最終設定メニューに戻る。

### 3-Root Password選択

「Root Password」選択時、`bsdinstall rootpass` が実行される。パスワード設定完了後、再度最終設定メニューに戻る。

### 4-Hostname選択

「Hostname」選択時、`bsdinstall hostname` が実行される。ホスト名設定完了後、再度最終設定メニューに戻る。

### 5-Network選択

「Network」選択時、`bsdinstall netconfig` が実行される。ネットワーク設定完了後、再度最終設定メニューに戻る。

### 6-Services選択

「Services」選択時、`bsdinstall services` が実行される。サービス設定完了後、再度最終設定メニューに戻る。

### 7-System Hardening選択

「System Hardening」選択時、`bsdinstall hardening` が実行される。セキュリティ強化設定完了後、再度最終設定メニューに戻る。

### 8-Time Zone選択

「Time Zone」選択時、`bsdinstall time` が実行される。タイムゾーン・日付・時刻設定完了後、再度最終設定メニューに戻る。

### 9-Firmware選択

「Firmware」選択時、`bsdinstall firmware` が実行される。ファームウェアインストール完了後、再度最終設定メニューに戻る。ネットワーク接続が必要。

### 10-Handbook選択

「Handbook」選択時、`bsdinstall docsinstall` が実行される。ドキュメントインストール完了後、再度最終設定メニューに戻る。ネットワーク接続が必要。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| - | - | - | 本画面自体はデータ更新を行わない。各サブコマンドの実行により間接的にデータが更新される |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-01 | 情報 | "Setup of your $OSNAME system is nearly complete. You can now modify your configuration choices. After this screen, you will have an opportunity to make more complex changes using a shell." | 常時表示 |

## 例外処理

- **bsddialog戻り値がBSDDIALOG_OK以外**：whileループを抜けてスクリプト終了（54-56行目）
- **BSDINSTALL_SKIP_FINALCONFIG設定時**：finalconfigスクリプトが呼ばれず、本画面は表示されない
- **サブコマンド実行エラー**：各サブコマンドのエラーは個別に処理され、メニューへの復帰には影響しない

## 備考

- `--no-cancel` オプションにより、キャンセルボタンは表示されない
- OKボタンのラベルは「Select」に変更されている（38行目: `--ok-label "Select"`）
- whileループ（35行目）により、「Finish」以外を選択した場合は処理完了後に再度メニューが表示される
- case文（58-89行目）で選択結果に応じたbsdinstallサブコマンドを実行する
- 各メニュー項目から呼び出される設定画面は、それぞれ独立したbsdinstallスクリプトとして実装されている
- FirmwareとHandbookにはネットワーク接続が必要である旨がメニュー説明に明記されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | 37-50行目：メニュー項目定義（タグ・説明の対応） |

**読解のコツ**: bsddialogの--menuウィジェットは「タグ 説明」のペアでメニュー項目を定義する。REVISIT変数にはユーザが選択したタグ（例: "Finish", "Add User"等）が格納される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 463行目：`bsdinstall finalconfig` の呼び出し条件 |
| 2-2 | finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | 30-33行目：初期化処理 |

**主要処理フロー**:
1. **30-31行目**: common.subr読み込みとBSDDIALOG_OK初期化
2. **35行目**: `while true` でメインループ開始
3. **36-51行目**: bsddialog --menuでメニュー表示、選択結果をREVISIT変数に格納
4. **54-56行目**: 戻り値チェック（BSDDIALOG_OK以外でbreak）
5. **58-89行目**: case文による選択結果の分岐処理
6. **59-60行目**: "Finish"でbreak（ループ終了）
7. **62-88行目**: 各メニュー項目に対応するbsdinstallサブコマンドの実行

#### Step 3: メニュー分岐処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | 58-89行目：case文によるメニュー項目→サブコマンドの対応 |

**主要処理フロー**:
- **62-63行目**: "Add User" → `bsdinstall adduser`
- **65-66行目**: "Root Password" → `bsdinstall rootpass`
- **68-69行目**: "Hostname" → `bsdinstall hostname`
- **71-72行目**: "Network" → `bsdinstall netconfig`
- **74-75行目**: "Services" → `bsdinstall services`
- **77-78行目**: "System Hardening" → `bsdinstall hardening`
- **80-81行目**: "Time Zone" → `bsdinstall time`
- **83-84行目**: "Firmware" → `bsdinstall firmware`
- **86-87行目**: "Handbook" → `bsdinstall docsinstall`

### プログラム呼び出し階層図

```
auto (463行目: bsdinstall finalconfig)
    |
    +-- finalconfig
            |
            +-- common.subr (共通関数読み込み)
            |
            +-- while true (メインループ)
                    |
                    +-- bsddialog --menu (メニュー表示)
                    |
                    +-- case "$REVISIT"
                            +-- "Finish"          --> break (ループ終了)
                            +-- "Add User"        --> bsdinstall adduser
                            +-- "Root Password"   --> bsdinstall rootpass
                            +-- "Hostname"        --> bsdinstall hostname
                            +-- "Network"         --> bsdinstall netconfig
                            +-- "Services"        --> bsdinstall services
                            +-- "System Hardening"--> bsdinstall hardening
                            +-- "Time Zone"       --> bsdinstall time
                            +-- "Firmware"        --> bsdinstall firmware
                            +-- "Handbook"        --> bsdinstall docsinstall
```

### データフロー図

```
[入力]                          [処理]                              [出力]

ユーザメニュー選択 ────────> bsddialog --menu ──────────> REVISIT変数
                                     |
                                     v
                              case文分岐
                                     |
                    +----------------+----------------+
                    |                |                |
              [Finish]        [Add User]        [Network]
              break        bsdinstall adduser  bsdinstall netconfig
                           → passwd更新        → rc.conf更新
                                     ...
                                     |
                                     v
                              メニューに戻る (while true)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | ソース | 最終設定メニュー画面のメインスクリプト |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | インストーラメインフロー（finalconfig呼び出し元） |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数ライブラリ |
| adduser | `usr.sbin/bsdinstall/scripts/adduser` | ソース | ユーザ追加スクリプト（メニューから呼び出し） |
| rootpass | `usr.sbin/bsdinstall/scripts/rootpass` | ソース | rootパスワード設定スクリプト（メニューから呼び出し） |
| hostname | `usr.sbin/bsdinstall/scripts/hostname` | ソース | ホスト名設定スクリプト（メニューから呼び出し） |
| netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | ソース | ネットワーク設定スクリプト（メニューから呼び出し） |
| services | `usr.sbin/bsdinstall/scripts/services` | ソース | サービス選択スクリプト（メニューから呼び出し） |
| hardening | `usr.sbin/bsdinstall/scripts/hardening` | ソース | セキュリティ強化設定スクリプト（メニューから呼び出し） |
| time | `usr.sbin/bsdinstall/scripts/time` | ソース | タイムゾーン・日時設定スクリプト（メニューから呼び出し） |
| firmware | `usr.sbin/bsdinstall/scripts/firmware` | ソース | ファームウェアインストールスクリプト（メニューから呼び出し） |
| docsinstall | `usr.sbin/bsdinstall/scripts/docsinstall` | ソース | ドキュメントインストールスクリプト（メニューから呼び出し） |
