# 画面設計書 31-ドキュメントインストール画面

## 概要

本ドキュメントは、FreeBSD bsdinstall インストーラにおける「ドキュメントインストール画面」の画面設計書である。本画面は、FreeBSD Documentation Project が提供する公式ドキュメント（Handbook、FAQ、記事）の各言語版を選択してインストールする機能を提供する。

### 本画面の処理概要

本画面では、FreeBSD の公式ドキュメントセット（Handbook、FAQ、記事等）を複数の言語から選択し、pkg(8) 経由でインストール先システムにインストールする処理を行う。

**業務上の目的・背景**：FreeBSD のインストール後にユーザが参照できるオフラインドキュメントを提供するために、この画面が存在する。Handbook はシステム管理の基本的なリファレンスであり、英語版を推奨しつつも各国語版を選択可能にすることで、国際的なユーザベースに対応する。

**画面へのアクセス方法**：最終設定メニュー画面（finalconfig）から「Handbook」メニュー項目を選択することで本画面に遷移する。最終設定メニュー画面の `case "$REVISIT"` 分岐で `"Handbook"` が選択された場合に `bsdinstall docsinstall` が呼び出される（`usr.sbin/bsdinstall/scripts/finalconfig` 87行目）。

**主要な操作・処理内容**：
1. 対応言語一覧（20言語）をチェックリスト形式で表示する。英語（English Documentation）はデフォルトでON、その他はデフォルトでOFF。
2. ユーザが矢印キー・スペースキーで言語を選択・解除する。
3. OK ボタン押下で選択された言語のドキュメントパッケージ（`{lang}-freebsd-doc`）を `pkg install` でインストールする。
4. Cancel ボタン押下で画面を閉じ、最終設定メニューに戻る。

**画面遷移**：
- 遷移元：最終設定メニュー画面（No.30）の「Handbook」メニュー選択
- 遷移先：最終設定メニュー画面（No.30）へ戻る（OK/Cancel いずれも）

**権限による表示制御**：本画面はインストーラ内で動作するため、すべての操作は root 権限で実行される。権限による表示制御は存在しない。ただし、ネットワーク接続が必要であり、ネットワーク未設定時はパッケージのダウンロードに失敗する可能性がある。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | パッケージ管理支援 | 主機能 | pkg installによるFreeBSDドキュメントパッケージの選択・インストール処理 |
| 109 | manページ | 補助機能 | Handbook・FAQ・記事等のドキュメントセット内容 |

## 画面種別

選択（チェックリスト形式）

## URL/ルーティング

シェルスクリプト: `usr.sbin/bsdinstall/scripts/docsinstall`
呼び出し方法: `bsdinstall docsinstall`（最終設定メニューからの呼び出し）

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | デフォルト値 | 説明 |
|--------|--------|-----|------|-------------|------|
| 言語チェックリスト | 入力 | チェックリスト（複数選択） | いいえ | en=ON, 他=OFF | インストールするドキュメントの言語を選択 |
| DOCSINSTALL_LANGS | 環境変数（入力） | 文字列 | いいえ | bn da de el en es fr hu id it ja ko mn nl pl pt ru tr zh_cn zh_tw | 表示する言語の一覧 |
| DIST_DOC_{LANG} | 環境変数（入力） | on/off | いいえ | en=on, 他=off | 各言語のデフォルト選択状態 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| タイトル | テキスト | "FreeBSD Documentation Installation"（$OSNAME に応じて変動） |
| バックタイトル | テキスト | "FreeBSD Installer"（$OSNAME に応じて変動） |
| 説明文 | テキスト | ドキュメントセット（Handbook、FAQ、記事）のインストール案内。英語版のインストールを推奨するメッセージ |
| bn | チェックボックス | Bengali Documentation |
| da | チェックボックス | Danish Documentation |
| de | チェックボックス | German Documentation |
| el | チェックボックス | Greek Documentation |
| en | チェックボックス | English Documentation (recommended) ※デフォルトON |
| es | チェックボックス | Spanish Documentation |
| fr | チェックボックス | French Documentation |
| hu | チェックボックス | Hungarian Documentation |
| id | チェックボックス | Indonesian Documentation |
| it | チェックボックス | Italian Documentation |
| ja | チェックボックス | Japanese Documentation |
| ko | チェックボックス | Korean Documentation |
| mn | チェックボックス | Mongolian Documentation |
| nl | チェックボックス | Dutch Documentation |
| pl | チェックボックス | Polish Documentation |
| pt | チェックボックス | Portuguese Documentation |
| ru | チェックボックス | Russian Documentation |
| tr | チェックボックス | Turkish Documentation |
| zh_cn | チェックボックス | Simplified Chinese Documentation |
| zh_tw | チェックボックス | Traditional Chinese Documentation |

## イベント仕様

### 1-OK ボタン押下

1. `dialog_menu_main()` 関数がユーザの選択結果を `$selected` に格納する（行119-133）。
2. `f_dialog_menutag_fetch` で選択された言語コードを取得する（行149）。
3. `$BSDINSTALL_TMPETC/resolv.conf` を `$BSDINSTALL_CHROOT/etc/` にコピーし、pkg が名前解決できるようにする（行152）。
4. 選択された各言語コードに `-freebsd-doc` を付与してパッケージ名を組み立てる（行158-160）。
5. `ASSUME_ALWAYS_YES=YES chroot $BSDINSTALL_CHROOT pkg install $docsets` でパッケージをインストールする（行162）。
6. 最終設定メニュー画面に戻る。

### 2-Cancel ボタン押下

1. `dialog_menu_main` 関数が非ゼロを返す（行131-133）。
2. `f_die` が呼ばれ、スクリプトが終了する（行148）。
3. 最終設定メニュー画面の while ループに制御が戻る。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースを使用しない。代わりにファイルシステムへの書き込みを行う。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| OK ボタン押下 | $BSDINSTALL_CHROOT/etc/resolv.conf | ファイルコピー | DNS解決設定のコピー |
| OK ボタン押下 | $BSDINSTALL_CHROOT 内パッケージDB | pkg install | 選択されたドキュメントパッケージのインストール |

### テーブル別更新項目詳細

該当なし（RDBMSは使用しない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| msg_docsinstall_menu_text | 案内 | "This menu allows you to install the whole documentation set from the FreeBSD Documentation Project: Handbook, FAQ, and articles. Please select the language versions you wish to install. At minimum, you should install the English version, the original version of the documentation." | 画面表示時（常時） |
| msg_freebsd_documentation_installation | タイトル | "FreeBSD Documentation Installation" | 画面表示時（常時） |
| msg_freebsd_installer | バックタイトル | "FreeBSD Installer" | 画面表示時（常時） |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ネットワーク未設定 | resolv.conf が存在しない場合、DNS解決に失敗し pkg install がエラーとなる。スクリプト自体はエラーハンドリングを行わず、pkg のエラー出力が表示される |
| pkg リポジトリ接続失敗 | pkg install コマンドがエラーを返すが、ASSUME_ALWAYS_YES=YES により確認なしで処理される。最終設定メニューに戻る |
| Cancel 押下 | f_die によりスクリプトが終了し、最終設定メニューに戻る |
| bsdconfig ライブラリ読み込み失敗 | common.subr の読み込み失敗時は exit 1 で即座に終了する（行32） |

## 備考

- 本画面はネットワーク接続が必須である。最終設定メニューでは "Install FreeBSD Handbook (requires network)" と表記されている。
- `ASSUME_ALWAYS_YES=YES` により、pkg の確認プロンプトが抑制される。
- パッケージ名の形式は `{lang}-freebsd-doc`（例: `en-freebsd-doc`, `ja-freebsd-doc`）。
- 対応言語リストは環境変数 `DOCSINSTALL_LANGS` でカスタマイズ可能（行43-45）。
- bsdconfig の dialog.subr および packages.subr ライブラリに依存している。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、スクリプトが扱う変数・データ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | docsinstall | `usr.sbin/bsdinstall/scripts/docsinstall` | 行43-45: `DOCSINSTALL_LANGS` 変数で対応言語リストを定義。行52-77: 各言語の表示名を `msg_*doc_desc` 変数で定義 |
| 1-2 | docsinstall | `usr.sbin/bsdinstall/scripts/docsinstall` | 行99-104: 各言語のデフォルト選択状態を `DIST_DOC_{LANG}` 変数で管理。en のみ on、他は off |

**読解のコツ**: bsdconfig フレームワークの `f_getvar` 関数は間接参照で変数値を取得する。`msg_${lang}doc_desc` のように変数名を動的に構築している点に注意。

#### Step 2: エントリーポイントを理解する

処理の起点は `docsinstall` スクリプトの MAIN セクション。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | docsinstall | `usr.sbin/bsdinstall/scripts/docsinstall` | 行141-143: ダイアログの初期化処理。`f_dialog_title` でタイトル設定、`f_mustberoot_init` で root 権限確認 |
| 2-2 | docsinstall | `usr.sbin/bsdinstall/scripts/docsinstall` | 行148: `dialog_menu_main` 呼び出し。失敗時は `f_die` で終了 |

**主要処理フロー**:
1. **行141**: `f_dialog_title` でダイアログタイトルを設定
2. **行142**: `f_dialog_backtitle` でバックタイトルを設定
3. **行143**: `f_mustberoot_init` で root 権限の確認
4. **行148**: `dialog_menu_main` でチェックリストダイアログを表示
5. **行149**: `f_dialog_menutag_fetch` で選択結果を取得
6. **行152**: resolv.conf をコピー
7. **行157-160**: 選択された言語からパッケージ名リストを構築
8. **行162**: `pkg install` でパッケージをインストール

#### Step 3: ダイアログ表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | docsinstall | `usr.sbin/bsdinstall/scripts/docsinstall` | 行85-134: `dialog_menu_main()` 関数。チェックリストの構築と表示を担当 |
| 3-2 | docsinstall | `usr.sbin/bsdinstall/scripts/docsinstall` | 行94-109: 言語ループで `check_list` 変数にチェックリスト項目を動的構築 |
| 3-3 | docsinstall | `usr.sbin/bsdinstall/scripts/docsinstall` | 行119-130: `$DIALOG` コマンド（bsddialog）でチェックリストを表示し、結果を `$selected` に格納 |

**主要処理フロー**:
- **行94-109**: 各言語について、表示名の取得(`f_getvar`)、デフォルト状態の設定、チェックリスト項目への追加
- **行112-117**: `f_dialog_checklist_size` でダイアログサイズを自動計算
- **行119-130**: `$DIALOG --checklist` でチェックリストダイアログを表示
- **行132**: `f_dialog_menutag_store` で選択結果を保存

#### Step 4: パッケージインストール処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | docsinstall | `usr.sbin/bsdinstall/scripts/docsinstall` | 行152: resolv.conf コピーによるDNS解決の準備 |
| 4-2 | docsinstall | `usr.sbin/bsdinstall/scripts/docsinstall` | 行157-162: パッケージ名リスト構築と chroot 内での pkg install 実行 |

#### Step 5: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | 行50: メニュー項目 "Handbook" の定義 |
| 5-2 | finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | 行87-88: "Handbook" 選択時に `bsdinstall docsinstall` を呼び出す |

### プログラム呼び出し階層図

```
finalconfig (最終設定メニュー)
    |
    +-- case "Handbook" --> bsdinstall docsinstall
            |
            +-- common.subr (bsdconfigライブラリ)
            +-- dialog.subr (ダイアログライブラリ)
            +-- mustberoot.subr (root権限チェック)
            +-- packages.subr (パッケージ管理)
            |
            +-- dialog_menu_main()
            |       +-- f_getvar (言語説明取得)
            |       +-- f_shell_escape (文字列エスケープ)
            |       +-- f_dialog_checklist_size (サイズ計算)
            |       +-- $DIALOG --checklist (チェックリスト表示)
            |       +-- f_dialog_menutag_store (選択結果保存)
            |
            +-- f_dialog_menutag_fetch (選択結果取得)
            +-- cp resolv.conf (DNS設定コピー)
            +-- chroot pkg install (パッケージインストール)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

DOCSINSTALL_LANGS ---------> dialog_menu_main() ------->  チェックリスト表示
msg_*doc_desc                (言語一覧構築)
DIST_DOC_* (デフォルト状態)

ユーザ選択 ----------------> f_dialog_menutag_fetch ---->  $selected (言語コード一覧)

$selected -----------------> パッケージ名構築 ---------->  $docsets
                             ({lang}-freebsd-doc)            (例: "en-freebsd-doc ja-freebsd-doc")

$BSDINSTALL_TMPETC/ -------> cp resolv.conf ------------>  $BSDINSTALL_CHROOT/etc/resolv.conf
  resolv.conf

$docsets ------------------> chroot pkg install -------->  ドキュメントパッケージ
                                                            ($BSDINSTALL_CHROOT内にインストール)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| docsinstall | `usr.sbin/bsdinstall/scripts/docsinstall` | ソース | 本画面のメインスクリプト |
| finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | ソース | 本画面の呼び出し元（最終設定メニュー） |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | インストーラメインスクリプト。finalconfig を呼び出す |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通ライブラリ |
| dialog.subr | `/usr/share/bsdconfig/dialog.subr` | ライブラリ | ダイアログ操作ライブラリ |
| mustberoot.subr | `/usr/share/bsdconfig/mustberoot.subr` | ライブラリ | root権限チェックライブラリ |
| packages.subr | `/usr/share/bsdconfig/packages/packages.subr` | ライブラリ | パッケージ管理ライブラリ |
