# 画面設計書 32-手動設定確認画面

## 概要

本ドキュメントは、FreeBSD bsdinstall インストーラにおける「手動設定確認画面」の画面設計書である。本画面は、インストール完了後にユーザが chroot 環境内のシェルを開いて手動で追加設定を行うかどうかを確認する Yes/No ダイアログである。

### 本画面の処理概要

本画面では、インストールの全工程が完了した後に、ユーザがインストール先システムの chroot 環境内でシェルを開き、手動で追加のカスタマイズや設定変更を行うかどうかを確認する。

**業務上の目的・背景**：FreeBSD のインストーラが提供する標準的な設定項目だけでは対応できない、高度なシステムカスタマイズが必要なユーザ向けの機能である。インストール完了直後に chroot シェルを提供することで、ユーザはインストーラを終了する前にカスタム設定ファイルの編集、追加パッケージのインストール、カーネルモジュールの設定など、任意の操作を実行できる。これにより、インストーラの標準フローに含まれない設定を安全に実施する手段が提供される。

**画面へのアクセス方法**：最終設定メニュー画面（finalconfig）での操作完了後、`auto` スクリプト内の処理フローにより自動的に表示される（`usr.sbin/bsdinstall/scripts/auto` 行474-484）。環境変数 `BSDINSTALL_SKIP_MANUAL` が設定されている場合は本画面をスキップする。

**主要な操作・処理内容**：
1. Yes/No ダイアログを表示し、chroot シェルを開くかどうかをユーザに確認する。
2. Yes を選択した場合、画面をクリアし chroot 環境内で `/bin/sh -l` を起動する。
3. ユーザがシェルで `exit` と入力すると、インストーラの終了処理に進む。
4. No を選択した場合、直接インストーラの終了処理に進む。

**画面遷移**：
- 遷移元：最終設定メニュー画面（No.30）の処理完了後
- 遷移先（Yes）：chroot シェル → インストール完了
- 遷移先（No）：インストール完了

**権限による表示制御**：本画面はインストーラ内で動作するため、すべての操作は root 権限で実行される。権限による表示制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | パッケージ管理支援 | 主機能 | インストール完了後のchroot環境シェル起動確認ダイアログ |
| 79 | シェル（sh / csh） | 遷移先機能 | Yes選択時のchroot環境内シェル起動 |

## 画面種別

確認（Yes/No ダイアログ）

## URL/ルーティング

シェルスクリプト: `usr.sbin/bsdinstall/scripts/auto`（行474-484）
呼び出し方法: `auto` スクリプト内のメインフローにインラインで実装（独立したスクリプトではない）

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | デフォルト値 | 説明 |
|--------|--------|-----|------|-------------|------|
| Yes/No 選択 | 入力 | ボタン選択 | はい | No（--default-no） | chroot シェルを開くかどうかの確認 |
| BSDINSTALL_SKIP_MANUAL | 環境変数（入力） | 文字列 | いいえ | 未設定 | 設定時は本画面をスキップ |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| バックタイトル | テキスト | "FreeBSD Installer"（$OSNAME に応じて変動） |
| タイトル | テキスト | "Manual Configuration" |
| メッセージ | テキスト | "The installation is now finished. Before exiting the installer, would you like to open a shell in the new system to make any final manual modifications?" |
| Yes ボタン | ボタン | chroot シェルを開く |
| No ボタン | ボタン | シェルを開かずにインストーラを終了する（デフォルト選択） |

## イベント仕様

### 1-Yes ボタン押下

1. `bsddialog --yesno` が戻り値 0 を返す（行478）。
2. `clear` コマンドで画面をクリアする（行479）。
3. chroot 環境内でのシェル操作に関する案内メッセージを表示する（行480-481）。メッセージ内容: "This shell is operating in a chroot in the new system. When finished making configuration changes, type \"exit\"."
4. `chroot "$BSDINSTALL_CHROOT" /bin/sh -l` でインストール先システムの chroot 環境内にログインシェルを起動する（行482）。
5. ユーザが `exit` でシェルを終了すると、`bsdinstall entropy` → `bsdinstall umount` → インストール完了の処理に進む（行486-489）。

### 2-No ボタン押下

1. `bsddialog --yesno` が非ゼロを返す（行478）。
2. chroot シェルをスキップし、直接 `bsdinstall entropy` → `bsdinstall umount` → インストール完了の処理に進む（行486-489）。

### 3-画面スキップ

1. 環境変数 `BSDINSTALL_SKIP_MANUAL` が設定されている場合、`bsddialog` を呼び出さずにインストーラ終了処理に直接進む（行474）。

## データベース更新仕様

### 操作別データベース影響一覧

本画面自体はデータベースやファイルの更新を行わない。chroot シェル内でユーザが実施する操作に依存する。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| Yes 選択後のシェル操作 | $BSDINSTALL_CHROOT 内の任意ファイル | ユーザ依存 | ユーザがシェル内で行う任意の設定変更 |

### テーブル別更新項目詳細

該当なし（本画面自体はデータ更新を行わない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| （インライン文字列） | 確認 | "The installation is now finished. Before exiting the installer, would you like to open a shell in the new system to make any final manual modifications?" | ダイアログ表示時 |
| （インライン文字列） | 案内 | "This shell is operating in a chroot in the new system. When finished making configuration changes, type \"exit\"." | Yes 選択時のシェル起動直前 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| BSDINSTALL_SKIP_MANUAL が設定されている | ダイアログを表示せずにインストーラ終了処理に進む（行474） |
| chroot が失敗する | /bin/sh の戻り値に関わらず、後続の entropy / umount 処理が実行される |

## 備考

- `--default-no` オプションによりデフォルト選択は No（シェルを開かない）である。これは多くのユーザにとって手動設定が不要であることを反映している。
- chroot シェルは `/bin/sh -l`（ログインシェル）として起動される。`-l` フラグにより、インストール先システムの `.profile` 等が読み込まれる。
- 標準エラー出力は標準出力にリダイレクトされる（`2>&1`）。
- 本画面は `auto` スクリプト内にインラインで実装されており、独立したスクリプトファイルは存在しない。
- `BSDINSTALL_SKIP_MANUAL` 環境変数で本画面の表示を省略可能。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面で使用される主要な変数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行58: `$OSNAME` 変数（"FreeBSD Installer" のOS名部分） |
| 1-2 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行474: `$BSDINSTALL_SKIP_MANUAL` 環境変数によるスキップ制御 |
| 1-3 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行482: `$BSDINSTALL_CHROOT` 変数（chroot先のパス） |

**読解のコツ**: 本画面は独立スクリプトではなく `auto` スクリプト内にインラインで記述されている。`auto` スクリプトの末尾付近（行474-484）に該当コードが集中している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行463: `bsdinstall finalconfig` の呼び出し完了後 |
| 2-2 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行465-466: SIGINT トラップ再設定と config 保存 |
| 2-3 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行474-484: 手動設定確認ダイアログとchroot処理 |

**主要処理フロー**:
1. **行474**: `BSDINSTALL_SKIP_MANUAL` のチェック。設定されていれば以下をスキップ。
2. **行475-477**: `bsddialog --yesno` で Yes/No ダイアログを表示。`--default-no` でデフォルトを No に設定。
3. **行478**: 戻り値チェック。0（Yes）の場合のみ以下を実行。
4. **行479**: `clear` で画面クリア。
5. **行480-481**: chroot 環境の案内メッセージを echo で出力。
6. **行482**: `chroot "$BSDINSTALL_CHROOT" /bin/sh -l 2>&1` でログインシェル起動。
7. **行486**: `bsdinstall entropy` でエントロピー処理。
8. **行487**: `bsdinstall umount` でファイルシステムのアンマウント。

#### Step 3: 後続処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行486: `bsdinstall entropy` -- エントロピーシード処理 |
| 3-2 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行487: `bsdinstall umount` -- ファイルシステムアンマウント |
| 3-3 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行489: インストール完了ログ出力 |

### プログラム呼び出し階層図

```
auto (インストーラメインスクリプト)
    |
    +-- bsdinstall finalconfig (行463)
    +-- bsdinstall config (行466)
    |
    +-- [手動設定確認画面] (行474-484)
    |       +-- bsddialog --yesno (行475-477)
    |       +-- (Yes の場合)
    |       |       +-- clear (行479)
    |       |       +-- echo 案内メッセージ (行480-481)
    |       |       +-- chroot $BSDINSTALL_CHROOT /bin/sh -l (行482)
    |       |
    |       +-- (No の場合) → 次へ
    |
    +-- bsdinstall entropy (行486)
    +-- bsdinstall umount (行487)
```

### データフロー図

```
[入力]                       [処理]                       [出力]

BSDINSTALL_SKIP_MANUAL ---> スキップ判定 (行474) ------> スキップ時: 直接終了処理へ

ユーザ選択 (Yes/No) ------> bsddialog --yesno (行475) -> 戻り値 0 or 非0

(Yes の場合)
BSDINSTALL_CHROOT --------> chroot /bin/sh -l (行482) --> chroot内シェルセッション
                                                          (ユーザが任意操作)

(シェル終了後 / No の場合)
                            bsdinstall entropy (行486) -> エントロピーシード
                            bsdinstall umount (行487) --> ファイルシステムアンマウント
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | 本画面を含むインストーラメインスクリプト（行474-484） |
| finalconfig | `usr.sbin/bsdinstall/scripts/finalconfig` | ソース | 本画面の直前に実行される最終設定メニュー |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通ライブラリ（auto スクリプトの依存） |
| dialog.subr | `/usr/share/bsdconfig/dialog.subr` | ライブラリ | ダイアログ操作ライブラリ（auto スクリプトの依存） |
